-- www.schwabenmodding.bplaced.net 
-- by modelleicher
spSetLights = {};

local spSetLights_mt = Class(spSetLights);
  
function spSetLights.onCreate(id)
    g_currentMission:addUpdateable(spSetLights:new(id));
    print("spSetLights: spSetLights onCreate aufgerufen  OnCreate Id: "..id.." .")	
end;
  
function spSetLights:new(id, customMt) 
    local instance = {};
    if customMt ~= nil then
        setmetatable(instance, customMt);
    else
        setmetatable(instance, spSetLights_mt);
    end;
  
    instance.triggerId = id;
    addTrigger(id, "triggerCallback", instance);
  	instance.spSetLights = {};	  	
	local part = {};
	local partIndex = getUserAttribute(id, "partIndex");
	part.partIndex = getChildAt(id, partIndex);
	part.isOn = false;

	self.count = 0;
	if part.partIndex ~= nil then
		table.insert(instance.spSetLights, part);
	else
		print("Error spSetLights: No partIndex specified at Trigger, insert a partIndex Attribute.");
	end;	
    return instance;
end;
  
function spSetLights:delete()
    removeTrigger(self.triggerId);
end;
function spSetLights:update(dt) 
    for i=1, table.getn(self.spSetLights) do
		if self.count > 0 then
			if g_currentMission.missionDynamicInfo.isMultiplayer == false then
				if InputBinding.hasEvent(InputBinding.TOGGLE_VISIBILITY) then
					self.spSetLights[i].isOn = not self.spSetLights[i].isOn;
				end;	
			end;
		end;

		setVisibility(self.spSetLights[i].partIndex, self.spSetLights[i].isOn);
	end;
end;
function spSetLights:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
    if onEnter then
        self.count = self.count + 1;
		g_showspSetLightsIcon = true;
    elseif onLeave then
        self.count = self.count - 1;
		g_showspSetLightsIcon = false;
    end; 
end;
    
g_onCreateUtil.addOnCreateFunction("spSetLightsOnCreate", spSetLights.onCreate);

lightsOverlay = {};
lightsOverlay.modDirectory = g_currentModDirectory;

g_lightsOverlayModDirectory = lightsOverlay.modDirectory

function lightsOverlay:loadMap(name)
	g_showspSetLightsIcon = false;
	
	self.iconPath = tostring(lightsOverlay.modDirectory .. "icon_light1.png")
	self.iconOverlay = createImageOverlay(self.iconPath);	
end;

function lightsOverlay:deleteMap()
end;

function lightsOverlay:mouseEvent(posX, posY, isDown, isUp, button)
end;

function lightsOverlay:keyEvent(unicode, sym, modifier, isDown)
end;

function lightsOverlay:update(dt)
end;

function lightsOverlay:draw()
	if g_showspSetLightsIcon == true then
		renderOverlay(self.iconOverlay, 0.4, 0.4, 0.14, 0.17);		
	end;
end;
addModEventListener(lightsOverlay);
