-- www.schwabenmodding.bplaced.net 

mistPlane = {};
local mistPlane_mt = Class(mistPlane);
function mistPlane.onCreate(id)
	g_currentMission:addUpdateable(mistPlane:new(id));	
	print("mistPlane: mistPlane onCreate aufgerufen. OnCreate Id: "..id.." .");
end;
function mistPlane:new(id, customMt)
	local instance = {};
	if customMt ~= nil then
		setmetatable(instance, customMt);
	else
		setmetatable(instance, mistPlane_mt);
	end;

	instance.mistPlane = {};
	local index = getUserAttribute(id, "planeIndex");
	instance.mistPlane.index = getChildAt(id, index);
	instance.mistPlane.minTrans = 0;
	instance.mistPlane.maxTrans = getUserAttribute(id, "maxTrans");
	instance.mistPlane.maxFillLevel = Utils.getNoNil(getUserAttribute(id, "maxFillLevel"), 18000);
	instance.mistPlane.currentFillLevel = 0;
	instance.mistPlane.trans = 0;
	instance.mistPlane.isFull = false;

	return instance;
end;
function mistPlane:delete()
end;
function mistPlane:update(dt)
	-- Aktuellen Fllstand herausfinden, und gleich berprfen ob der Haufen schon voll ist
	self.mistPlane.currentFillLevel = Utils.getNoNil(g_currentMission.missionStats.farmSiloAmounts[Fillable.FILLTYPE_MANURE], 0);
	if self.mistPlane.currentFillLevel >= self.mistPlane.maxFillLevel then
		self.mistPlane.isFull = true;
	elseif self.mistPlane.currentFillLevel < self.mistPlane.maxFillLevel then
		self.mistPlane.isFull = false;
	end;
	-- Wenn der Haufen voll ist den Text einblenden und das weitere steigen der Fllmenge verhindern
	if self.mistPlane.isFull == true then
		renderText(0.02, 0.02, 0.021, "Misthaufen ist voll. Bitte Mist wegfahren!");
		g_currentMission:setSiloAmount(Fillable.FILLTYPE_MANURE, tonumber(self.mistPlane.maxFillLevel));
	end;
	-- Berechnung der Planetranslation
	local rw = self.mistPlane.maxTrans / self.mistPlane.maxFillLevel;
	local translation = self.mistPlane.currentFillLevel * rw;
	if translation < self.mistPlane.maxTrans then
		self.mistPlane.trans = translation;
	elseif translation >= self.mistPlane.maxTrans then
		self.mistPlane.trans = self.mistPlane.maxTrans;
	end;
	-- Ausfhrung der Planetranslation
	if self.mistPlane.index ~= nil then
		setTranslation(self.mistPlane.index, 0, self.mistPlane.trans, 0);
	end;
end;
  

    
g_onCreateUtil.addOnCreateFunction("mistPlaneOnCreate", mistPlane.onCreate);

