-- www.schwabenmodding.bplaced.net 

grassPlane = {};
local grassPlane_mt = Class(grassPlane);
function grassPlane.onCreate(id)
	g_currentMission:addUpdateable(grassPlane:new(id));	
	print("grassPlane: grassPlane onCreate aufgerufen. OnCreate Id: "..id.." .");
end;
function grassPlane:new(id, customMt)
	local instance = {};
	if customMt ~= nil then
		setmetatable(instance, customMt);
	else
		setmetatable(instance, grassPlane_mt);
	end;

	instance.grassPlane = {};
	local index = getUserAttribute(id, "planeIndex");
	instance.grassPlane.index = getChildAt(id, 0);
	instance.grassPlane.minTrans = 0;
	instance.grassPlane.maxTrans = getUserAttribute(id, "maxTrans");
	instance.grassPlane.maxFillLevel = Utils.getNoNil(getUserAttribute(id, "maxFillLevel"), 18000);
	instance.grassPlane.currentFillLevel = 0;
	instance.grassPlane.trans = 0;
	instance.grassPlane.isFull = false;

	return instance;
end;
function grassPlane:delete()
end;
function grassPlane:update(dt)
	-- Aktuellen Fllstand herausfinden, und gleich berprfen ob der Haufen schon voll ist
	self.grassPlane.currentFillLevel = Utils.getNoNil(g_currentMission.missionStats.farmSiloAmounts[Fillable.FILLTYPE_GRASS], 0);
	if self.grassPlane.currentFillLevel >= self.grassPlane.maxFillLevel then
		self.grassPlane.isFull = true;
	elseif self.grassPlane.currentFillLevel < self.grassPlane.maxFillLevel then
		self.grassPlane.isFull = false;
	end;
	-- Wenn der Haufen voll ist den Text einblenden und das weitere steigen der Fllmenge verhindern
	if self.grassPlane.isFull == true then
		renderText(0.1, 0.02, 0.021, "Du hast aktuell genug Gras an deine Kuehe gefuettert.");
		g_currentMission:setSiloAmount(Fillable.FILLTYPE_GRASS, tonumber(self.grassPlane.maxFillLevel));
	end;
	-- Berechnung der Planetranslation
	local rw = self.grassPlane.maxTrans / self.grassPlane.maxFillLevel;
	local translation = self.grassPlane.currentFillLevel * rw;
	if translation < self.grassPlane.maxTrans then
		self.grassPlane.trans = translation;
	elseif translation >= self.grassPlane.maxTrans then
		self.grassPlane.trans = self.grassPlane.maxTrans;
	end;
	-- Ausfhrung der Planetranslation
	setTranslation(self.grassPlane.index, 0, self.grassPlane.trans, 0)
end;
  

    
g_onCreateUtil.addOnCreateFunction("grassPlaneOnCreate", grassPlane.onCreate);

