-- www.schwabenmodding.bplaced.net 
-- by modelleicher
-- used some parts of Giants BarnMoverTrigger.lua
--
-- Sorgt dafr dass man Ballen reinwerfen kann und daraus Chaff entsteht. Fr Maps die kein Chaffsilo mehr haben.
-- This LUA deletes Bales in a Trigger and add a specified value to "chaff" per each bale

baleToChaff = {};
  
local baleToChaff_mt = Class(baleToChaff);

function baleToChaff.onCreate(id)
    g_currentMission:addUpdateable(baleToChaff:new(id));
    print("baleToChaff: baleToChaff onCreate aufgerufen  OnCreate Id: "..id.." .")	
end;

 
function baleToChaff:new(id, customMt) 
    local instance = {};
    if customMt ~= nil then
        setmetatable(instance, customMt);
    else
        setmetatable(instance, baleToChaff_mt);
    end;
	
    instance.baleToChaff = id;
	addTrigger(instance.baleToChaff, "baleDeleteTrigger", instance);	

    return instance;
end;
  
function baleToChaff:delete()
      removeTrigger(self.baleDeleteTrigger);
end;
function baleToChaff:update(dt) 
end;
function baleToChaff:updateTick(dt) 
end;
function baleToChaff:draw()
end;

function baleToChaff:baleDeleteTrigger(triggerId, otherId, onEnter, onLeave, onStay)
    if onEnter then
           -- this happens, if a compound child of a deleted compound is entering
        if otherId ~= 0 then
            local object = g_currentMission:getNodeObject(otherId);
            if object ~= nil then
				local isStrawbale = getUserAttribute(otherId, "isStrawbale");
				local isHaybale = getUserAttribute(otherId, "isHaybale");
				local isRoundbale = getUserAttribute(otherId, "isRoundbale");
				if isStrawbale == true or isHaybale == true or isRoundbale == true then
                    if g_currentMission:getIsServer() then   
						local fillamount = 200
						g_currentMission:setSiloAmount(Fillable.FILLTYPE_CHAFF, fillamount)
                        object:delete();
                    end;
                elseif not object:isa(Vehicle) then -- do not delete vehicles, but everything else
                    if g_currentMission:getIsServer() then
                        object:delete();
                    end;
                else
                    if g_currentMission.nodeToVehicle[otherId] == nil then
                       -- there is nothing that could end up here, since physics objects are an object, thus this could only introduce bugs
                       --delete(otherId);
				    end;
                end;
            end;
        end;
    end;  
end;
  
    
g_onCreateUtil.addOnCreateFunction("baleToChaffOnCreate", baleToChaff.onCreate);

