--
-- OldAlbMap
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

OldAlbMap = {}

local SampleModMap_mt = Class(OldAlbMap, Mission00);

function OldAlbMap:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = SampleModMap_mt;
    end;
    local self = OldAlbMap:superClass():new(baseDirectory, mt);
    return self;
end;

function OldAlbMap:delete()
    OldAlbMap:superClass().delete(self);
end;

function OldAlbMap:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
    
    -- load paths for AI traffic vehicles
    --self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));
    
    -- load paths for AI pedestrians
    --self:loadMap(Utils.getFilename("map01/paths/pedestrianPaths.i3d", self.baseDirectory));
        
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("missions/CattleMeadow.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
    
    OldAlbMap:superClass().load(self);
end
function OldAlbMap:loadFinished()
    OldAlbMap:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function OldAlbMap:mouseEvent(posX, posY, isDown, isUp, button)
    OldAlbMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function OldAlbMap:keyEvent(unicode, sym, modifier, isDown)
    OldAlbMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function OldAlbMap:update(dt)
    OldAlbMap:superClass().update(self, dt);
end;

function OldAlbMap:draw()
    OldAlbMap:superClass().draw(self);
end;
