-- Skrypt: ZGCol
-- Wersja: 1.0
--30.10.2009
-- Autor: hannibal5

---LOG---
-------------------------------------
--Wersja: 1.0 (30.10.2009)
-----Animacja obrotu gwiazd wraz z kolizjami
-----Animacja ruchu podpory wraz z kolizja
-------------------------------------

ZGCol = {};
------------------------------------------------------------------------------------------------------------------------------------
function ZGCol.prerequisitesPresent(specializations)

    return true;
	
end;
------------------------------------------------------------------------------------------------------------------------------------
function ZGCol:load(xmlFile)
	
	self.transParts = {};
	local i = 0;
	while true do
		local baseName = string.format("vehicle.translationParts.transPart(%d)", i);
		local index = getXMLString(xmlFile, baseName.. "#index");
		if index == nil then
			break;
		end;
		
		local node = Utils.indexToObject(self.components, index);
		if node ~= nil then
			local entry = {};
			entry.node = node;
			
			local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, baseName.. "#minTrans"));
			entry.minTrans = {};
			entry.minTrans[1] = Utils.getNoNil(x, 0);
			entry.minTrans[2] = Utils.getNoNil(y, 0);
			entry.minTrans[3] = Utils.getNoNil(z, 0);

			x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, baseName.. "#maxTrans"));
			entry.maxTrans = {};
			entry.maxTrans[1] = Utils.getNoNil(x, 0);
			entry.maxTrans[2] = Utils.getNoNil(y, 0);
			entry.maxTrans[3] = Utils.getNoNil(z, 0);

			entry.transTime = Utils.getNoNil(getXMLString(xmlFile, baseName.. "#transTime"), 2) * 1000;
			entry.touchTransLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, baseName.. "#touchTransLimit"), 10));

			table.insert(self.transParts, entry);		
		end;
		i = i + 1;
	end;
	
	self.rotParts = {};
	local i = 0;
	while true do
		local baseName = string.format("vehicle.rotationParts.rotPart(%d)", i);
		local index = getXMLString(xmlFile, baseName.. "#index");
		if index == nil then
			break;
		end;
		
		local node = Utils.indexToObject(self.components, index);
		if node ~= nil then
			local entry = {};
			entry.node = node;

			local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, baseName.. "#minRot"));
			entry.minRot = {};
			entry.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
			entry.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
			entry.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

			x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, baseName.. "#maxRot"));
			entry.maxRot = {};
			entry.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
			entry.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
			entry.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

			entry.rotTime = Utils.getNoNil(getXMLString(xmlFile, baseName.. "#rotTime"), 2)*1000;
			entry.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, baseName.. "#touchRotLimit"), 10));
			
			table.insert(self.rotParts, entry);		
		end;
		i = i + 1;
    end;
	
	self.rotTransport = false;
	self.rotPrzetrzasanie = false;
	self.rotOdwracanie = false;
	self.transPodpora = false;

end;
------------------------------------------------------------------------------------------------------------------------------------
function ZGCol:mouseEvent(posX, posY, isDown, isUp, button)

end;
------------------------------------------------------------------------------------------------------------------------------------
function ZGCol:keyEvent(unicode, sym, modifier, isDown)

end;
------------------------------------------------------------------------------------------------------------------------------------
function ZGCol:update(dt)

	if self.transParts[1] ~= nil then
		local x, y, z = getTranslation(self.transParts[1].node);
		local trans = {x,y,z};
		local newTrans = Utils.getMovedLimitedValues(trans, self.transParts[1].maxTrans, self.transParts[1].minTrans, 3, self.transParts[1].transTime, dt, not self.transPodpora);
		setTranslation(self.transParts[1].node, unpack(newTrans));
		setJointFrame(self.componentJoints[1].jointIndex, 0, self.componentJoints[1].jointNode);
	end;
	
	if self.farmerNear then
		if self.activeMode == ZG.ODW_TRANSPORT then
			if self.rotParts[1] ~= nil then
				local x, y, z = getRotation(self.rotParts[1].node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotParts[1].maxRot, self.rotParts[1].minRot, 3, self.rotParts[1].rotTime, dt, not self.rotTransport);
				setRotation(self.rotParts[1].node, unpack(newRot));
				setJointFrame(self.componentJoints[2].jointIndex, 0, self.componentJoints[2].jointNode);
				setJointFrame(self.componentJoints[3].jointIndex, 0, self.componentJoints[3].jointNode);
			end;
		elseif self.activeMode == ZG.ODW_PRZETRZASANIE then	
			if self.rotParts[2] ~= nil then
				local x, y, z = getRotation(self.rotParts[2].node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotParts[2].maxRot, self.rotParts[2].minRot, 3, self.rotParts[2].rotTime, dt, not self.rotPrzetrzasanie);
				setRotation(self.rotParts[2].node, unpack(newRot));
				setJointFrame(self.componentJoints[2].jointIndex, 0, self.componentJoints[2].jointNode);
				setJointFrame(self.componentJoints[3].jointIndex, 0, self.componentJoints[3].jointNode);
			end;
		elseif self.activeMode == ZG.ODW_ODWRACANIE_POKOSOW then
			if self.rotParts[2] ~= nil then
				local x, y, z = getRotation(self.rotParts[2].node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotParts[2].maxRot, self.rotParts[2].minRot, 3, self.rotParts[2].rotTime, dt, not self.rotOdwracanie);
				setRotation(self.rotParts[2].node, unpack(newRot));
				setJointFrame(self.componentJoints[2].jointIndex, 0, self.componentJoints[2].jointNode);
				setJointFrame(self.componentJoints[3].jointIndex, 0, self.componentJoints[3].jointNode);
			end;
			if self.rotParts[3] ~= nil then
				local x, y, z = getRotation(self.rotParts[3].node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotParts[3].maxRot, self.rotParts[3].minRot, 3, self.rotParts[3].rotTime, dt, not self.rotOdwracanie);
				setRotation(self.rotParts[3].node, unpack(newRot));
				setJointFrame(self.componentJoints[2].jointIndex, 0, self.componentJoints[2].jointNode);
			end;
			if self.rotParts[4] ~= nil then
				local x, y, z = getRotation(self.rotParts[4].node);
				local rot = {x,y,z};
				local newRot = Utils.getMovedLimitedValues(rot, self.rotParts[4].maxRot, self.rotParts[4].minRot, 3, self.rotParts[4].rotTime, dt, not self.rotOdwracanie);
				setRotation(self.rotParts[4].node, unpack(newRot));
				setJointFrame(self.componentJoints[3].jointIndex, 0, self.componentJoints[3].jointNode);
			end;
		end;
	end;

end;

------------------------------------------------------------------------------------------------------------------------------------
function ZGCol:draw()

end;
------------------------------------------------------------------------------------------------------------------------------------
function ZGCol:onAttach()

	self.transPodpora = not self.transPodpora;

end; 	
------------------------------------------------------------------------------------------------------------------------------------
function ZGCol:onDetach()

	self.transPodpora = not self.transPodpora;
	
end;
------------------------------------------------------------------------------------------------------------------------------------
function ZGCol:delete()

end;
------------------------------------------------------------------------------------------------------------------------------------
