-- 
-- Terra Trac
--
-- BETA by shangri66
-- 
-- Nimmt die rotation der Rder und bertrgt sie auf die TTwheels.
-- Jedes TTwheel kann ein "reference Wheel" zugewiesen werden, dessen rotation bertragen wird.
-- Das erlaubt, das sich die Tracs unterschiedlich schnell in den Kurven drehen knnen
--
-- Zustzlich wird die Y-translation auf das Laufband bertragen, damit das Laufband auch "federt".
-- Um eine mglichst einfache und zudem noch anschauliche Terra Trac zu bekommen, wird dazu noch ein custom shader genutzt
-- dafr nehmen wir einfach den ScrollUV-Shader des Strohballen-Elevators und lassen die UVmap nach unten/oben verschieben
--
-- Vorsicht, BETA-Version!
--


TerraTrac = {};

function TerraTrac.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function TerraTrac:load(xmlFile)
 
 self.numTerraTrackWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.TerraTrackWheels#count"), 0);
    self.TerraTracks = {};
    for i=1, self.numTerraTrackWheels do
        local TerraTracksnamei = string.format("vehicle.TerraTrackWheels.TTWheel" .. "%d", i);
        self.TerraTracks[i] = {};
		self.TerraTracks[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, TerraTracksnamei .. "#index"));
		self.TerraTracks[i].refWheel = Utils.getNoNil(getXMLInt(xmlFile,  TerraTracksnamei .. "#referenceWheel"), 1);			
    end;
		
	self.trackL = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TerraTracLeft#index"));
	self.trackR = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TerraTracRight#index"));
	
	self.terraL = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TracBodyLeft#index"));
	self.terraR = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TracBodyRight#index"));
	
	self.txL, self.tyL, self.tzL = getTranslation(self.terraL);
	self.txR, self.tyR, self.tzR = getTranslation(self.terraR);
	self.wxL, self.wyL, self.wzL = getTranslation(self.wheels[3].repr);
	self.wxR, self.wyR, self.wzR = getTranslation(self.wheels[4].repr);
	self.deltaLwy = self.tyL - self.wyL;
	self.deltaRwy = self.tyR - self.wyR;
end;
	
function TerraTrac:delete()
end;

function TerraTrac:mouseEvent(posX, posY, isDown, isUp, button)
end;

function TerraTrac:keyEvent(unicode, sym, modifier, isDown)
end;

function TerraTrac:update(dt)

	---
	--- let the tracs "bounce" ;)
	---
	local Lwx, Lwy, Lwz = getTranslation(self.wheels[3].repr);
	local Ltx, Lty, Ltz = getTranslation(self.terraL);
	setTranslation(self.terraL, Ltx, (Lwy+self.deltaLwy), Ltz);
	
	local Rwx, Rwy, Rwz = getTranslation(self.wheels[4].repr);
	local Rtx, Rty, Rtz = getTranslation(self.terraR);
	setTranslation(self.terraR, Rtx, (Rwy+self.deltaRwy), Rtz);
	
	---
	--- the uv-coords are set by the rotation value of the wheel
	---
	local xt,yt,zt = getRotation(self.wheels[3].repr);	
	setShaderParameter(self.trackL, "UVPlaySpeed", 0, xt*0.1, 0, 0, false);
	local xt2,yt2,zt2 = getRotation(self.wheels[4].repr);	
	setShaderParameter(self.trackR, "UVPlaySpeed", 0, xt2*0.1, 0, 0, false);
		
	---
	--- rotate the little wheels
	---	
	for i=1, self.numTerraTrackWheels do	
			
		local q = self.TerraTracks[i].refWheel
	
		local x,y,z = getRotation(self.wheels[q].repr);
		local TTWheel = self.TerraTracks[i].index;
		setRotation(TTWheel, -x,y,z);
	end;
		

		

end;

function TerraTrac:draw()
end;