--
-- Fortschritt E303
-- author: Burner
-- 

E303 = {};

function E303.initSpecialization()
	Vehicle.registerJointType("cutter");
end;

function E303.prerequisitesPresent(specializations)
    return true;
end;

function E303:load(xmlFile)
	self.setConditioner = SpecializationUtil.callSpecializationsFunction("setConditioner");
	self.objectInRange = E303.objectInRange;
	
	self.conditionerActive = false;
	self.conditionerNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.conditioner#index"));
	
	self.rollNodes = {};
    local rollNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.roll#index"));
    if rollNode ~= nil then
        local speed = 0.003*3;
        table.insert(self.rollNodes, {node=rollNode, speed=speed});
    end;
    local i = 0;
    while true do
        local key = string.format("vehicle.rolls.roll(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local rollNode = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local speed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#speed"), 0.003);
        if rollNode ~= nil then
            table.insert(self.rollNodes, {node=rollNode, speed=speed});
        end;
        i = i + 1;
    end;
	
    local wiperAnimRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wiper#rootNode"));
    self.wiperAnimCharSet = 0;
    if wiperAnimRootNode ~= nil and wiperAnimRootNode ~= 0 then
        self.wiperAnimCharSet = getAnimCharacterSet(wiperAnimRootNode);
        if self.wiperAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.wiperAnimCharSet, getXMLString(xmlFile, "vehicle.wiper#clip"));
            assignAnimTrackClip(self.wiperAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.wiperAnimCharSet, 0, true);
            local wiperAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wiper#speedScale"), 1);
			setAnimTrackSpeedScale(self.wiperAnimCharSet, 0, wiperAnimSpeedScale);
            self.wiperAnimDuration = getAnimClipDuration(self.wiperAnimCharSet, clip);
        end;
    end;
	self.isWiperActive = false;
	self.finishWiper = true;
end;

function E303:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'conditioner="'.. tostring(self.conditionerActive) ..'"';
	return attributes, nil;
end;

function E303:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local conditioner = Utils.getNoNil(getXMLBool(xmlFile, key.."#conditioner"), false);
		if conditioner == true then
			self:setConditioner(conditioner);
		end;
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function E303:delete()
end;

function E303:readStream(streamId, connection)
	self:setConditioner(streamReadBool(streamId), true);
end;

function E303:writeStream(streamId, connection)
	streamWriteBool(streamId, self.conditionerActive);
end;

function E303:readUpdateStream(streamId, timestamp, connection)
end;

function E303:writeUpdateStream(streamId, connection, dirtyMask)
end;

function E303:mouseEvent(posX, posY, isDown, isUp, button)
end;

function E303:keyEvent(unicode, sym, modifier, isDown)
end;

function E303:update(dt)
	if self:getIsActive() then	
		if not self.finishWiper then
			if getAnimTrackTime(self.wiperAnimCharSet, 0) % self.wiperAnimDuration <= 100 then
				setAnimTrackTime(self.wiperAnimCharSet, 0, 0.0);
				disableAnimTrack(self.wiperAnimCharSet, 0);			
				self.finishWiper = true;
			end;			
		end;
		
		if g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 then
			if not self.isWiperActive then
				enableAnimTrack(self.wiperAnimCharSet, 0);
				self.isWiperActive = true;
			end;
		else
			if self.isWiperActive then
				self.isWiperActive = false;
				self.finishWiper = false;
			end;
		end;
	end;
	
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.E303_ToggleDoor) then
			if self.animationParts[2].clipEndTime then
				self:setAnimationTime(2, self.animationParts[2].startPosition);
			elseif self.animationParts[2].clipStartTime then
				self:setAnimationTime(2, self.animationParts[2].animDuration);
			end;
		end;
		if self.isMotorStarted then
			if InputBinding.isPressed(InputBinding.E303_CutterUp) then
				self:setAnimationTime(1, self.animationParts[1].currentPosition+(self.animationParts[1].offSet+dt), false);
			elseif InputBinding.isPressed(InputBinding.E303_CutterDown) then
				self:setAnimationTime(1, self.animationParts[1].currentPosition-(self.animationParts[1].offSet+dt), false);
			end;
		end;
	end;
	if self:objectInRange(self.conditionerNode) then
		if InputBinding.hasEvent(InputBinding.E303_MountConditioner) then
			self:setConditioner(not self.conditionerActive);
		end;
		if self.conditionerActive then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("E303_ConditionerUnmount")), InputBinding.E303_MountConditioner);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("E303_ConditionerMount")), InputBinding.E303_MountConditioner);
		end;
	end;
	if self.conditionerNode ~= nil then
		setVisibility(self.conditionerNode, self.conditionerActive);
	end;
	for i=1, table.getn(self.attachedImplements) do
		if self.attachedImplements[i].object.isTurnedOn then
			for _, rollNode in pairs(self.rollNodes) do
				rotate(rollNode.node, -dt*rollNode.speed, 0, 0);
			end;			
		end;
	end;
end;

function E303:updateTick(dt)	
end;

function E303:onLeave()
	if self.isWiperActive then
		disableAnimTrack(self.wiperAnimCharSet, 0);	
	end;
end;

function E303:onEnter()
	if self.isWiperActive then
		enableAnimTrack(self.wiperAnimCharSet, 0);	
	end;
end;

function E303:draw()
	if self.isClient then
		if self.animationParts[2].clipEndTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("E303_CloseDoor"), self.typeDesc), InputBinding.E303_ToggleDoor);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("E303_OpenDoor"), self.typeDesc), InputBinding.E303_ToggleDoor);
		end;
		if self.isMotorStarted then
			g_currentMission:addExtraPrintText(string.format(""..string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.E303_CutterUp), "PAD ", "") .. "/" .. string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.E303_CutterDown), "PAD", "")..": "..g_i18n:getText("E303_CutterMove")..""));
		end;
	end;
end;

function E303:objectInRange(object)
	if g_currentMission.player ~= nil and object ~= nil then
		local nearestDistance = 3;
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local px, py, pz = getWorldTranslation(object); 
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			return true;
		else
			return false;
		end;
	else
		return false;
	end;
end;

function E303:setConditioner(conditionerActive,noEventSend)
	SetConditionerStateEvent.sendEvent(self, conditionerActive, noEventSend);
	self.conditionerActive = conditionerActive;
end;

function E303:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

SetConditionerStateEvent = {};
SetConditionerStateEvent_mt = Class(SetConditionerStateEvent, Event);

InitEventClass(SetConditionerStateEvent, "SetConditionerStateEvent");

function SetConditionerStateEvent:emptyNew()
    local self = Event:new(SetConditionerStateEvent_mt);
    self.className="SetConditionerStateEvent";
    return self;
end;

function SetConditionerStateEvent:new(vehicle, conditionerState)
    local self = SetConditionerStateEvent:emptyNew()
    self.vehicle = vehicle;
	self.conditionerState = conditionerState;
    return self;
end;

function SetConditionerStateEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.conditionerState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetConditionerStateEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.conditionerState);
end;

function SetConditionerStateEvent:run(connection)   
	self.vehicle:setConditioner(self.conditionerState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetConditionerStateEvent:new(self.vehicle, self.conditionerState), nil, connection, self.vehicle);
    end;
end;

function SetConditionerStateEvent.sendEvent(vehicle, conditionerState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetConditionerStateEvent:new(vehicle, conditionerState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetConditionerStateEvent:new(vehicle, conditionerState));
		end;
	end;
end;