--
-- Specialization for farmer car mod
--
-- @author  Stefan Geiger
-- @date  10/01/09
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
--
-- Specialization for Blinker mod
--
-- @autor Sebastian B. (Edit StianBY)
-- @update 01/12/10
--

wheels = {};

function wheels.prerequisitesPresent(specializations)
    return true;
end;

function wheels:load(xmlFile)

    self.twinVL = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.twinVL#index"));
    self.twinVR = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.twinVR#index"));
    self.twinHL = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.twinHL#index"));
    self.twinHR = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.twinHR#index"));

end;

function wheels:delete()
end;

function wheels:mouseEvent(posX, posY, isDown, isUp, button)
end;

function wheels:keyEvent(unicode, sym, modifier, isDown)

     if isDown and sym == Input.KEY_k then
		self.dualwheels = not self.dualwheels;
		setVisibility(self.twinVL, self.dualwheels);
		setVisibility(self.twinVR, self.dualwheels);
        setVisibility(self.twinHL, self.dualwheels);
		setVisibility(self.twinHR, self.dualwheels);			
	end;
    

	-- Anfang Info Panel 
	if isDown and sym == Input.KEY_KP_0 then
        self.helpPanel = not self.helpPanel;
    end;
	-- Ende Info Panel
end;

function wheels:update(dt)
end;

function wheels:draw()

		if not self.helpPanel then
            renderText(0.80, 0.22, 0.021, "");
        else
            renderText(0.80, 0.22, 0.021, "");
        end;
        
        if self.helpPanel then
            renderText(0.80, 0.66, 0.02, "- IHC 1455 XLA -");
			
			renderText(0.79, 0.62, 0.02, "Taste 7 : Auspuff aendern");
                        renderText(0.79, 0.60, 0.02, "Leertaste : Handbremse");
                        renderText(0.79, 0.58, 0.02, "Taste U: Allrad zuschalten");
                        renderText(0.79, 0.56, 0.02, "Taste Num 1: Blinker links");
                        renderText(0.79, 0.54, 0.02, "Taste Num 2: Warnblinker");
                        renderText(0.79, 0.52, 0.02, "Taste Num 3: Blinker rechts");
                        renderText(0.79, 0.50, 0.02, "Taste Num 7: Tuer links");
			renderText(0.79, 0.48, 0.02, "Taste Num 9: Tuer rechts");
			renderText(0.79, 0.46, 0.02, "Taste Num 6: Dachluke");
			renderText(0.79, 0.44, 0.02, "Taste K: Zwillingsreifen");
			renderText(0.79, 0.42, 0.02, "Taste Num 8: Heckfenster");
                       
			
		end;
	
end;

function wheels:onLeave()
end;