
extraWeights = {};

function extraWeights.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function extraWeights:load(xmlFile)

	self.extraWeights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.extraWeights#count"), 0);
    self.weights = {};
    for i=1, self.extraWeights do
        local weightnamei = string.format("vehicle.extraWeights.weight%d", i);
        self.weights[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, weightnamei .. "#index"));
        setVisibility(self.weights[i], false);
    end;
	
	self.currentWeight = 0;
	self.controlWeight = 0;
	self.singleWeight = 0;
	self.maxWeight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.maxWeight#weight"), 100);
end;

function extraWeights:delete()
end;

function extraWeights:mouseEvent(posX, posY, isDown, isUp, button)
end;

function extraWeights:keyEvent(unicode, sym, modifier, isDown)
end;

function extraWeights:update(dt)
	
	if self.isEntered then
	    self.singleWeight = (self.maxWeight / self.extraWeights);
	
		if InputBinding.hasEvent(InputBinding.WEIGHT_ACTIVE_FIAT) then
			if self.currentWeight >= self.maxWeight then
				self.currentWeight = 0;
			else
				self.currentWeight = self.currentWeight + self.singleWeight;
			end;
		end;
		
		if self.weights ~= nil then
		    if self.currentWeight ~= self.controlWeight then
		        self.controlWeight = self.currentWeight;
			
			    if self.currentWeight > 0 then
		            for i = 1, self.extraWeights do
				        if i * self.singleWeight <= self.currentWeight then
					        setVisibility(self.weights[i], true);
					    end;
				    end;
				else
				    for i = 1, self.extraWeights do
					    setVisibility(self.weights[i], false);
					end;
			    end;
		    end;

			if self.emptyMass == nil then
				self.emptyMass = getMass(self.components[1].node);
				self.currentMass = self.emptyMass;
			end;
			local newMass = self.emptyMass + self.currentWeight;
			if newMass ~= self.currentMass then
				setMass(self.components[1].node, newMass);
				self.currentMass = newMass;
				for k,v in pairs(self.components) do
					if v.node == self.components[1].node then
						if v.centerOfMass ~= nil then
							setCenterOfMass(v.node, v.centerOfMass[1], v.centerOfMass[2], v.centerOfMass[3]);
						end;
						break;
					end;
				end;
			end;
		end;
	end;
end;

function extraWeights:onLeave()
	self.weightActive = false;
end;

function extraWeights:draw()
	g_currentMission:addHelpButtonText("Frontgewicht: " ..string.format("%d kg", self.currentWeight*8), InputBinding.WEIGHT_ACTIVE_FIAT);
end;

