--
-- Gear
-- Specialization class for Gears
--
-- @author  MySQly
-- @date  10/06/09
--
-- Copyright (C) MySQly, All Rights Reserved.

Gear = {};

function Gear.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Gear:load(xmlFile)
    self.handbrakelight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.handbrakelight#index"));
    self.brakelight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.brakelight#index"));
	self.reverselight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.reverselight#index"));
	
	self.handbrake = true;
	self.cos = 20000;
	self.druckLevel = 0;

	handbrakeSoundFile = Utils.getFilename("handbrake.wav", self.baseDirectory);
    self.handbrakeSoundId = createSample("handbrakeSound");
    loadSample(self.handbrakeSoundId, handbrakeSoundFile, false);
    self.handbrakePlaying = false;
	
	brakeSoundFile = Utils.getFilename("brake2.wav", self.baseDirectory);
    self.brakeSoundId = createSample("brakeSound");
    loadSample(self.brakeSoundId, brakeSoundFile, false);
    self.brakePlaying = false;
	
	brakereleaseSoundFile = Utils.getFilename("brake.wav", self.baseDirectory);
    self.brakereleaseSoundId = createSample("brakereleaseSound");
    loadSample(self.brakereleaseSoundId, brakereleaseSoundFile, false);
    self.brakereleasePlaying = false;
	
	fuelwarningSoundFile = Utils.getFilename("fuelwarning.wav", self.baseDirectory);
    self.fuelwarningSoundId = createSample("fuelwarningSound");
    loadSample(self.fuelwarningSoundId, fuelwarningSoundFile, false);
    self.fuelwarningPlaying = false;
	
	compressorSoundFile = Utils.getFilename("compressor.wav", self.baseDirectory);
    self.compressorSoundId = createSample("compressorSound");
    loadSample(self.compressorSoundId, compressorSoundFile, false);
    self.compressorPlaying = false;
	
	compressorstopSoundFile = Utils.getFilename("compressorstop.wav", self.baseDirectory);
    self.compressorstopSoundId = createSample("compressorstopSound");
    loadSample(self.compressorstopSoundId, compressorstopSoundFile, false);
    self.compressorstopPlaying = false;
end;

function Gear:delete()

end;

function Gear:mouseEvent(posX, posY, isDown, isUp, button)

end;

function Gear:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym == Input.KEY_space then
		self.handbrake = not self.handbrake; 
		if self.handbrake then
			playSample(self.handbrakeSoundId,1,1,0);
		end;
	end;


end;

function Gear:update(dt)
    if self.isEntered then

        
        if g_currentMission.allowSteerableMoving and not self.playMotorSound then
			
			if Input.isKeyPressed(Input.KEY_w) then
				self.motor:setSpeedLevel(0, true)
			end;
			if Input.isKeyPressed(Input.KEY_w) then
				self.motor:setSpeedLevel(0,true)
			end;
			
        if self.fuelFillLevel == 0 then
            acceleration = 0;
        end;
			
		
		
			
			
        end;
		if not self.handbrake then
		    brakeTorque = 20;
			self.motor.brakeForce = brakeTorque;
			setVisibility(self.handbrakelight, false);
		else
			if not Input.isKeyPressed(Input.KEY_s) then
				setVisibility(self.handbrakelight, true);
			end;
		end;		
		if Input.isKeyPressed(Input.KEY_s) then
			if not self.druckWarning then
				if not self.braking then
					if self.attachedTrailer then
						self.druckLevel = self.druckLevel -350;
					else
						self.druckLevel = self.druckLevel -250;
					end;
					self.braking = true;
				end;
				setVisibility(self.brakelight, true);
				if not self.brakePlaying then
					playSample(self.brakeSoundId,1,1,0);
					self.brakePlaying = true;
				end;
				self.brakereleasePlaying = false;				
			end;
		else
			self.brakePlaying = false;
			setVisibility(self.brakelight, false);
			self.braking = false;
			if not self.handbrake then
				brakeTorque = 20;
				self.motor.brakeForce = brakeTorque;
			end;
			if not self.brakereleasePlaying then
				playSample(self.brakereleaseSoundId,1,1,0);
				self.brakereleasePlaying = true;
			end;
		end;

		
		if self.fuelFillLevel < 50 then
			self.cos = self.cos - dt;
			if self.cos <= 0 then
				playSample(self.brakereleaseSoundId,1,1,0);
				self.cos = 20000;
			end;
		else
			self.cos = 20000;
		end;
		
		
		
		if self.druckLevel >= -1 and self.druckLevel <= 6100 then
			self.compressorStart = true;
		end;
		if self.druckLevel >= 9999 then
			self.compressorStart = false;
		end;
		if self.compressorStart == true then
			if not self.compressorSoundRunning then
				playSample(self.compressorSoundId, 0, 1, 0);
				self.compressorSoundRunning = true;
			end;
			self.compressorstopSoundRunning = false;
			if self.druckLevel <= 10000 then
				self.druckLevel = self.druckLevel +(dt/3);
			end;
		end;
		if self.compressorStart == false then
			stopSample(self.compressorSoundId, 0, 1, 0);
			self.compressorSoundRunning = false;
			if not self.compressorstopSoundRunning then
				playSample(self.compressorStopSoundId, 1, 1, 0);
				self.compressorstopSoundRunning = true;
			end;
			if self.druckLevel >= 6099 then
				self.druckLevel = self.druckLevel -(dt/40);
			end;
		end;
		if self.druckLevel <= 6000 then
			self.druckWarning = true;
			self.drucklightActive = true;
		else
			self.druckWarning = false;
			self.drucklightActive = false;
		end;
	end;
end;

function Gear:draw()

	if self.isEntered then
		if self.hudjohndeereOverlay ~= nil then
			self.hudjohndeereOverlay:render();
		end;
		if self.handbrake then
			setTextBold(true);
			setTextColor(1,0,0,1);
			if Input.isKeyPressed(Input.KEY_w) then
				setTextBold(true);
				setTextColor(1,0,0,1);
				renderText(0.74, 0.26, 0.02, "Handbremse loesen! -Leertaste-");
			end;
			renderText(0.74, 0.22, 0.02, "(!) Handbremse aktiv!");	
		end;
		
		if self.druckWarning then
			setTextBold(true);
			setTextColor(1,0,0,1);
			renderText(0.74, 0.40, 0.02, "   Systemdruck zu gering.");
			renderText(0.74, 0.37, 0.02, "   Eingeschraenkte Bremswirkung!");
		end;
	end;
end;


function Gear:drawGrainLevel(level, capacity, warnPercent)

end;
