SipmaZ224CreateBaleEvent = {};
SipmaZ224CreateBaleEvent_mt = Class(SipmaZ224CreateBaleEvent, Event);

InitEventClass(SipmaZ224CreateBaleEvent, "SipmaZ224CreateBaleEvent");

function  SipmaZ224CreateBaleEvent:emptyNew()
	local self = Event:new(SipmaZ224CreateBaleEvent_mt);
	self.className="SipmaZ224CreateBaleEvent";
	return self;
end;

function SipmaZ224CreateBaleEvent:new(object, usedFruitType, baleTime)
	local self = SipmaZ224CreateBaleEvent:emptyNew()
	self.usedFruitType = usedFruitType;
	self.baleTime = baleTime;
	self.object = object;
	return self;
end;

function SipmaZ224CreateBaleEvent:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.usedFruitType = streamReadInt8(streamId);
	self.baleTime = streamReadFloat32(streamId);
	self:run(connection);
end;

function SipmaZ224CreateBaleEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt8(streamId, self.usedFruitType);
	streamWriteFloat32(streamId, self.baleTime);
end;

function SipmaZ224CreateBaleEvent:run(connection)
	--print("creating bale");
	SipmaZ224.createBale(self.object, self.usedFruitType);
	SipmaZ224.setBaleTime(self.object, table.getn(self.object.bales), self.baleTime);
end;

SipmaZ224SetBaleTimeEvent = {};
SipmaZ224SetBaleTimeEvent_mt = Class( SipmaZ224SetBaleTimeEvent, Event);

InitEventClass(SipmaZ224SetBaleTimeEvent, "SipmaZ224SetBaleTimeEvent");

function SipmaZ224SetBaleTimeEvent:emptyNew()
	local self = Event:new(SipmaZ224SetBaleTimeEvent_mt);
	self.className=" SipmaZ224SetBaleTimeEvent";
	return self;
end;

function SipmaZ224SetBaleTimeEvent:new(object, bale, baleTime)
	local self =  SipmaZ224SetBaleTimeEvent:emptyNew()
	self.bale = bale;
	self.baleTime = baleTime;
	self.object = object;
	return self;
end;

function SipmaZ224SetBaleTimeEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.bale = streamReadInt32(streamId);
	self.baleTime = streamReadFloat32(streamId);
	self.object = networkGetObject(id);
	self:run(connection);
end;

function SipmaZ224SetBaleTimeEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt32(streamId, self.bale);
	streamWriteFloat32(streamId, self.baleTime);
end;

function SipmaZ224SetBaleTimeEvent:run(connection)
	SipmaZ224.setBaleTime(self.object, self.bale, self.baleTime);
end;

-- Counterweight panel event
SetCounterweightPanelEvent = {};
SetCounterweightPanelEvent_mt = Class(SetCounterweightPanelEvent, Event);

InitEventClass(SetCounterweightPanelEvent, "SetCounterweightPanelEvent");

function SetCounterweightPanelEvent:emptyNew()
    local self = Event:new(SetCounterweightPanelEvent_mt);
    self.className="SetCounterweightPanelEvent";
    return self;
end;

function SetCounterweightPanelEvent:new(vehicle, isCounterweightPanelState)
    local self = SetCounterweightPanelEvent:emptyNew()
    self.vehicle = vehicle;
	self.isCounterweightPanelState = isCounterweightPanelState;
    return self;
end;

function SetCounterweightPanelEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isCounterweightPanelState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetCounterweightPanelEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isCounterweightPanelState);
end;

function SetCounterweightPanelEvent:run(connection)   
	self.vehicle:setCounterweightPanel(self.isCounterweightPanelState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetCounterweightPanelEvent:new(self.vehicle, self.isCounterweightPanelState), nil, connection, self.vehicle);
    end;
end;

function SetCounterweightPanelEvent.sendEvent(vehicle, isCounterweightPanelState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetCounterweightPanelEvent:new(vehicle, isCounterweightPanelState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetCounterweightPanelEvent:new(vehicle, isCounterweightPanelState));
		end;
	end;
end;

-- Mechanism panel event
SetMechanismPanelEvent = {};
SetMechanismPanelEvent_mt = Class(SetMechanismPanelEvent, Event);

InitEventClass(SetMechanismPanelEvent, "SetMechanismPanelEvent");

function SetMechanismPanelEvent:emptyNew()
    local self = Event:new(SetMechanismPanelEvent_mt);
    self.className="SetMechanismPanelEvent";
    return self;
end;

function SetMechanismPanelEvent:new(vehicle, isMechanismPanelState)
    local self = SetMechanismPanelEvent:emptyNew()
    self.vehicle = vehicle;
	self.isMechanismPanelState = isMechanismPanelState;
    return self;
end;

function SetMechanismPanelEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isMechanismPanelState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetMechanismPanelEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isMechanismPanelState);
end;

function SetMechanismPanelEvent:run(connection)   
	self.vehicle:setMechanismPanel(self.isMechanismPanelState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetMechanismPanelEvent:new(self.vehicle, self.isMechanismPanelState), nil, connection, self.vehicle);
    end;
end;

function SetMechanismPanelEvent.sendEvent(vehicle, isMechanismPanelState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetMechanismPanelEvent:new(vehicle, isMechanismPanelState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetMechanismPanelEvent:new(vehicle, isMechanismPanelState));
		end;
	end;
end;

-- Rope panel event
SetRopePanelEvent = {};
SetRopePanelEvent_mt = Class(SetRopePanelEvent, Event);

InitEventClass(SetRopePanelEvent, "SetRopePanelEvent");

function SetRopePanelEvent:emptyNew()
    local self = Event:new(SetRopePanelEvent_mt);
    self.className="SetRopePanelEvent";
    return self;
end;

function SetRopePanelEvent:new(vehicle, isRopePanelState)
    local self = SetRopePanelEvent:emptyNew()
    self.vehicle = vehicle;
	self.isRopePanelState = isRopePanelState;
    return self;
end;

function SetRopePanelEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isRopePanelState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetRopePanelEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isRopePanelState);
end;

function SetRopePanelEvent:run(connection)   
	self.vehicle:setRopePanel(self.isRopePanelState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetRopePanelEvent:new(self.vehicle, self.isRopePanelState), nil, connection, self.vehicle);
    end;
end;

function SetRopePanelEvent.sendEvent(vehicle, isRopePanelState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetRopePanelEvent:new(vehicle, isRopePanelState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetRopePanelEvent:new(vehicle, isRopePanelState));
		end;
	end;
end;

-- BackFlap event --
SetBackFlapEvent = {};
SetBackFlapEvent_mt = Class(SetBackFlapEvent, Event);

InitEventClass(SetBackFlapEvent, "SetBackFlapEvent");

function SetBackFlapEvent:emptyNew()
    local self = Event:new(SetBackFlapEvent_mt);
    self.className="SetBackFlapEvent";
    return self;
end;

function SetBackFlapEvent:new(vehicle, isBackFlap)
    local self = SetBackFlapEvent:emptyNew()
    self.vehicle = vehicle;
	self.isBackFlap = isBackFlap;
    return self;
end;

function SetBackFlapEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isBackFlap = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetBackFlapEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isBackFlap);
end;

function SetBackFlapEvent:run(connection)   
	self.vehicle:setBackFlap(self.isBackFlap, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetBackFlapEvent:new(self.vehicle, self.isBackFlap), nil, connection, self.vehicle);
    end;
end;

function SetBackFlapEvent.sendEvent(vehicle, isBackFlap, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetBackFlapEvent:new(vehicle, isBackFlap), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetBackFlapEvent:new(vehicle, isBackFlap));
		end;
	end;
end;

-- Reset counter event --
ResetBaleCounterEvent = {};
ResetBaleCounterEvent_mt = Class(ResetBaleCounterEvent, Event);

InitEventClass(ResetBaleCounterEvent, "ResetBaleCounterEvent");

function ResetBaleCounterEvent:emptyNew()
    local self = Event:new(ResetBaleCounterEvent_mt);
    self.className="ResetBaleCounterEvent";
    return self;
end;

function ResetBaleCounterEvent:new(vehicle, resetCounter)
    local self = ResetBaleCounterEvent:emptyNew()
    self.vehicle = vehicle;
	self.resetCounter = resetCounter;
    return self;
end;

function ResetBaleCounterEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.resetCounter = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function ResetBaleCounterEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.resetCounter);
end;

function ResetBaleCounterEvent:run(connection)   
	self.vehicle:resetBaleCounter(self.resetCounter, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(ResetBaleCounterEvent:new(self.vehicle, self.resetCounter), nil, connection, self.vehicle);
    end;
end;

function ResetBaleCounterEvent.sendEvent(vehicle, resetCounter, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ResetBaleCounterEvent:new(vehicle, resetCounter), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(ResetBaleCounterEvent:new(vehicle, resetCounter));
		end;
	end;
end;

SetHasRopesEvent = {};
SetHasRopesEvent_mt = Class(SetHasRopesEvent, Event);

InitEventClass(SetHasRopesEvent, "SetHasRopesEvent");

function SetHasRopesEvent:emptyNew()
    local self = Event:new(SetHasRopesEvent_mt);
    self.className="SetHasRopesEvent";
    return self;
end;

function SetHasRopesEvent:new(vehicle, isLoadedWithRopes)
    local self = SetHasRopesEvent:emptyNew()
    self.vehicle = vehicle;
	self.isLoadedWithRopes = isLoadedWithRopes;
    return self;
end;

function SetHasRopesEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isLoadedWithRopes = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetHasRopesEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isLoadedWithRopes);
end;

function SetHasRopesEvent:run(connection)   
	self.vehicle:setHasRopes(self.isLoadedWithRopes, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetHasRopesEvent:new(self.vehicle, self.isLoadedWithRopes), nil, connection, self.vehicle);
    end;
end;

function SetHasRopesEvent.sendEvent(vehicle, isLoadedWithRopes, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetHasRopesEvent:new(vehicle, isLoadedWithRopes), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetHasRopesEvent:new(vehicle, isLoadedWithRopes));
		end;
	end;
end;

-- Bale transporter position event
SetBaleTransporterPositionEvent = {};
SetBaleTransporterPositionEvent_mt = Class(SetBaleTransporterPositionEvent, Event);

InitEventClass(SetBaleTransporterPositionEvent, "SetBaleTransporterPositionEvent");

function SetBaleTransporterPositionEvent:emptyNew()
    local self = Event:new(SetBaleTransporterPositionEvent_mt);
    self.className="SetBaleTransporterPositionEvent";
    return self;
end;

function SetBaleTransporterPositionEvent:new(vehicle, transporterState)
    local self = SetBaleTransporterPositionEvent:emptyNew()
    self.vehicle = vehicle;
	self.transporterState = transporterState;
    return self;
end;

function SetBaleTransporterPositionEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.transporterState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetBaleTransporterPositionEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.transporterState);
end;

function SetBaleTransporterPositionEvent:run(connection)   
	self.vehicle:setBaleTransporterPosition(self.transporterState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetBaleTransporterPositionEvent:new(self.vehicle, self.transporterState), nil, connection, self.vehicle);
    end;
end;

function SetBaleTransporterPositionEvent.sendEvent(vehicle, transporterState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetBaleTransporterPositionEvent:new(vehicle, transporterState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetBaleTransporterPositionEvent:new(vehicle, transporterState));
		end;
	end;
end;

-- Bale transporter visibility event
SetBaleTransporterVisibilityEvent = {};
SetBaleTransporterVisibilityEvent_mt = Class(SetBaleTransporterVisibilityEvent, Event);

InitEventClass(SetBaleTransporterVisibilityEvent, "SetBaleTransporterVisibilityEvent");

function SetBaleTransporterVisibilityEvent:emptyNew()
    local self = Event:new(SetBaleTransporterVisibilityEvent_mt);
    self.className="SetBaleTransporterVisibilityEvent";
    return self;
end;

function SetBaleTransporterVisibilityEvent:new(vehicle, transporterVisibility)
    local self = SetBaleTransporterVisibilityEvent:emptyNew()
    self.vehicle = vehicle;
	self.transporterVisibility = transporterVisibility;
    return self;
end;

function SetBaleTransporterVisibilityEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.transporterVisibility = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetBaleTransporterVisibilityEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.transporterVisibility);
end;

function SetBaleTransporterVisibilityEvent:run(connection)   
	self.vehicle:setBaleTransporterVisibility(self.transporterVisibility, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetBaleTransporterVisibilityEvent:new(self.vehicle, self.transporterVisibility), nil, connection, self.vehicle);
    end;
end;

function SetBaleTransporterVisibilityEvent.sendEvent(vehicle, transporterVisibility, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetBaleTransporterVisibilityEvent:new(vehicle, transporterVisibility), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetBaleTransporterVisibilityEvent:new(vehicle, transporterVisibility));
		end;
	end;
end;

-- Bale transporter visibility event
MoveBalesOutEvent = {};
MoveBalesOutEvent_mt = Class(MoveBalesOutEvent, Event);

InitEventClass(MoveBalesOutEvent, "MoveBalesOutEvent");

function MoveBalesOutEvent:emptyNew()
    local self = Event:new(MoveBalesOutEvent_mt);
    self.className="MoveBalesOutEvent";
    return self;
end;

function MoveBalesOutEvent:new(vehicle, moveBales)
    local self = MoveBalesOutEvent:emptyNew()
    self.vehicle = vehicle;
	self.moveBales = moveBales;
    return self;
end;

function MoveBalesOutEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.moveBales = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function MoveBalesOutEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.moveBales);
end;

function MoveBalesOutEvent:run(connection)   
	self.vehicle:doMoveBalesOut(self.moveBales, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(MoveBalesOutEvent:new(self.vehicle, self.moveBales), nil, connection, self.vehicle);
    end;
end;

function MoveBalesOutEvent.sendEvent(vehicle, moveBales, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(MoveBalesOutEvent:new(vehicle, moveBales), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(MoveBalesOutEvent:new(vehicle, moveBales));
		end;
	end;
end;