--
-- JDmanualIgnition
-- Specialization for manual Motor Ignition
--
-- @author  Templaer
-- @date  01/05/09
--
-- Modifikationen erst nach Rcksprache
-- Do not edit without my permission
--

JDmanualIgnition = {};

function JDmanualIgnition.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function JDmanualIgnition:load(xmlFile)
    -- Booleans
    self.ignitionKey = false;
	self.allowedIgnition = false;                                                  
	
    local aiMotorSound  = getXMLString(xmlFile, "vehicle.aiMotorSound#file");
    if aiMotorSound  ~= nil and aiMotorSound  ~= "" then
        aiMotorSound  = Utils.getFilename(aiMotorSound, self.baseDirectory);
        self.aiMotorSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundRun#pitchOffset"), 0);
        self.aiMotorSoundRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundRun#radius"), 50);
        self.aiMotorSoundInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundRun#innerRadius"), 10);
        self.aiMotorSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundRun#volume"), 1);
        self.aiMotorSound = createAudioSource("aiMotorSound", aiMotorSound, self.aiMotorSoundRadius, self.aiMotorSoundInnerRadius, self.aiMotorSoundVolume, 0);
        link(self.components[1].node, self.aiMotorSound);
        setVisibility(self.aiMotorSound, false);
    end;
	
	-- Backup Stop Sound volume
    self.motorStopSoundVolume2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStopSound#volume"), 1.0);
end;

function JDmanualIgnition:delete()
end;

function JDmanualIgnition:mouseEvent(posX, posY, isDown, isUp, button)
end;

function JDmanualIgnition:keyEvent(unicode, sym, modifier, isDown)
end;

function JDmanualIgnition:update(dt)
    acceleration = -InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);
    if InputBinding.isAxisZero(acceleration) then
        acceleration = -InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
    end;

	-- Does not execute when AI is activated
    if not self.isHired then
        -- Handles ignition key input
        if self:getIsActiveForInput() then
            if InputBinding.hasEvent(InputBinding.JDTIGNITION) then
				if not self.steeringEnabled and InputBinding.isPressed(InputBinding.BRAKEANDCLUTCH) or acceleration <= -0.5 then
					self.ignitionKey = not self.ignitionKey;
					self.allowedIgnition = true;
				elseif InputBinding.hasEvent(InputBinding.JDTIGNITION) then
					if self.steeringEnabled then
						self.ignitionKey = false;
						self.allowedIgnition = true;
					end;
				end
	        end;
	    end;
		
	    -- Mutes stop sound when engine is off
	    if not self.ignitionKey or not self.deactivateOnLeave then
	        self.motorStopSoundVolume = 0;
        else
	        self.motorStopSoundVolume = self.motorStopSoundVolume2;
	    end;
								
        if self.ignitionKey and self.allowedIgnition then	
		    self:startMotor();
			self.allowedIgnition = false;
			self.deactivateOnLeave = false;
			self.steeringEnabled = true;
			Utils.setEmittingState(self.exhaustParticleSystems, true)
		elseif not self.ignitionKey and self.allowedIgnition then
		    if self.motorStopSoundVolume == 0 then
			    self.motorStopSoundVolume = self.motorStopSoundVolume2;
			end;
			
			self:stopMotor();
			self.allowedIgnition = false;
	        self.steeringEnabled = false;
			self.deactivateOnLeave = true;
			setVisibility(self.aiMotorSound, false);
			
			-- Brakes the wheels upon turning off the engine
			for k,wheel in pairs(self.wheels) do
				setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
			end;
			self:onDeactivateAttachements();
		end;
		
    -- Prevents the AI from driving when engine is off
    elseif not self.ignitionKey and not self.deactivateOnLeave then
		WheelsUtil.updateWheelsPhysics(self, dt, self.lastSpeed, 0, false, 0);
		self.chopperActivated = false;
		self.isThreshing = false;
		for cutter,implement in pairs(self.attachedCutters) do
			local jointDesc = self.attacherJoints[implement.jointDescIndex];
			jointDesc.moveDown = false;

			cutter:onStopReel();
		end;
	end;
end;

function JDmanualIgnition:onLeave()
    if not self.deactivateOnLeave then
	    Utils.setEmittingState(self.exhaustParticleSystems, true)
		self.allowedIgnition = false;
		self.isMotorStarted = true;
		self.ignitionKey = true; 
		self.steeringEnabled = false;
		setVisibility(self.aiMotorSound, true);
		
		-- Brakes the wheels upon turning off the engine
		for k,wheel in pairs(self.wheels) do
			setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
		end;
	else
		self.allowedIgnition = false;
		self.isMotorStarted = false;
		self.ignitionKey = false;
	end;	
end;

function JDmanualIgnition:onEnter()
	-- Prevents the engine from starting upon entering
	if not self.ignitionKey then
		self.isMotorStarted = false;
		Motorized.stopSounds(self);
		self.steeringEnabled = false;
		Utils.setEmittingState(self.exhaustParticleSystems, false)
	else
	    self.steeringEnabled = true;
	end;
	
    setVisibility(self.aiMotorSound, false);
end;

function JDmanualIgnition:draw()
end;

