--
-- henly 20 (Ls_uk Modteam)
-- 06.09.2010
--
-- > www.LS-UK.info
--
IHduals = {}

function IHduals.prerequisitesPresent(specializations)
    return true;
end;

function IHduals:load(xmlFile)

	self.setAdditionalWheels = SpecializationUtil.callSpecializationsFunction("setAdditionalWheels");

	self.duelWheels = {};
	self.duelWheels[1] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.duelWheels#index1"));
	self.duelWheels[2] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.duelWheels#index2"));
	self.duelWheels[3] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.duelWheels#index3"));
	self.duelWheels[4] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.duelWheels#index4"));
	self.duelWheels.node = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.duelWheels#indexDuel"));
	
	self.duelWheelMode = 0;	
	self.duelWheel1Active = false;
	self.duelWheel2Active = false;
	self.duelWheel3Active = false;
	self.duelWheel4Active = false;
	
end;
      
function IHduals:delete()
end;

function IHduals:readStream(streamId, connection)
	self:setAdditionalWheels(streamReadInt8(streamId), true);
end;

function IHduals:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.duels);	
end;

function IHduals:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function IHduals:keyEvent(unicode, sym, modifier, isDown)
end;

function IHduals:update(dt)

	if not self:getIsActive() then


		if self.playerInRange then
		g_currentMission:addHelpButtonText(g_i18n:getText("DUAL"), InputBinding.IMPLEMENT_EXTRA3);
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
			if self.duelWheelMode > 2 then
				self.duelWheelMode = 0;
			end;
			self:setAdditionalWheels(math.abs(self.duelWheelMode + 1));
		end;
		end;
	end;


end;

function IHduals:updateTick(dt)	
	if g_currentMission.player ~= nil then
		local nearestDistance = 4.0;
		local x1,y1,z1 = getWorldTranslation(self.duelWheels.node);
		local x2,y2,z2 = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(x1-x2,y1-y2,z1-z2);
		if distance < nearestDistance then
			self.playerInRange = true; 
		else
			self.playerInRange = false; 
		end;
	end;
end;

function IHduals:onLeave()
end;

function IHduals:draw()


end;

function IHduals:setAdditionalWheels(duels, noEventSend)
	AdditionalWheelsEvent.sendEvent(self, duels, noEventSend);

	self.duelWheelMode = duels;

	if self.duelWheelMode == 0  then
		self.duelWheel1Active = false;
		self.duelWheel2Active = false;
		self.duelWheel3Active = false;
		self.duelWheel4Active = false;
	end;
	if self.duelWheelMode == 1 then
		self.duelWheel1Active = true;
		self.duelWheel2Active = true;
		self.duelWheel3Active = false;
		self.duelWheel4Active = false;
	end;
	if self.duelWheelMode == 2 then
		self.duelWheel1Active = true;
		self.duelWheel2Active = true;
		self.duelWheel3Active = true;
		self.duelWheel4Active = true;
	end;
	if self.duelWheelMode == 3  then
		self.duelWheel1Active = false;
		self.duelWheel2Active = false;
		self.duelWheel3Active = false;
		self.duelWheel4Active = false;
	end;	
	
	setVisibility(self.duelWheels[1], self.duelWheel1Active);
	setVisibility(self.duelWheels[2], self.duelWheel2Active);
	setVisibility(self.duelWheels[3], self.duelWheel3Active);
	setVisibility(self.duelWheels[4], self.duelWheel4Active);
end;

AdditionalWheelsEvent = {};
AdditionalWheelsEvent_mt = Class(AdditionalWheelsEvent, Event);

InitEventClass(AdditionalWheelsEvent, "AdditionalWheelsEvent");

function AdditionalWheelsEvent:emptyNew()
    local self = Event:new(AdditionalWheelsEvent_mt);
    self.className="AdditionalWheelsEvent";
    return self;
end;

function AdditionalWheelsEvent:new(vehicle, duels)
    local self = AdditionalWheelsEvent:emptyNew()
    self.vehicle = vehicle;
	self.duels = duels;
    return self;
end;

function AdditionalWheelsEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.duels = streamReadInt8(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function AdditionalWheelsEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt8(streamId, self.duels);	
end;

function AdditionalWheelsEvent:run(connection)
	self.vehicle:setAdditionalWheels(self.duels, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(AdditionalWheelsEvent:new(self.vehicle, self.duels), nil, connection, self.object);
	end;
end;

function AdditionalWheelsEvent.sendEvent(vehicle, duels, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(AdditionalWheelsEvent:new(vehicle, duels), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(AdditionalWheelsEvent:new(vehicle, duels));
		end;
	end;
end;