--
-- IH3 788
-- Specialization class for IH 3788
--
-- @author  PeterJ - LS UK mod team
-- @date  23/04/2012
--
-- Copyright (C) LS-UK modteam, Confidential, All Rights Reserved.

IH3788 = {};

function IH3788.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function IH3788:load(xmlFile)

	self.kinkJoint = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.kinkSteering#kinkJoint"), 0);
	self.kinkOrientation = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.kinkSteering#wheelOrientation"));

	local rotationLifter = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Lifter#index"));
	self.Lifter = {};
	self.Lifter.node = rotationLifter;

	local rotationLifterArm = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.LifterArm#index"));
	self.LifterArm = {};
	self.LifterArm.node = rotationLifterArm;

	local rotationLifterBottom = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.LifterBottom#index"));
	self.bottomArm2 = {};
	self.bottomArm2.node = rotationLifterBottom;

	local BottomArmNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.attacherJoints.attacherJoint.bottomArm#rotationNode"));
	self.bottomArm = {};
	self.bottomArm.node = BottomArmNode;

	self.drivingShaft = {};
	self.drivingShaft.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.drivingShaft#index"));

end;

function IH3788:delete()
end;

function IH3788:mouseEvent(posX, posY, isDown, isUp, button)
end;

function IH3788:keyEvent(unicode, sym, modifier, isDown)
end;

function IH3788:update(dt)
	if self.Lifter.node ~= nil and self.bottomArm2.node ~= nil then
		rBBArmX, rBBArmY, rBBArmZ = getRotation(self.bottomArm2.node);
        setRotation(self.Lifter.node, rBBArmX*1.52-0.55, 0, 0);
    end;
	if self.LifterArm.node ~= nil and self.bottomArm2.node ~= nil then
        setRotation(self.LifterArm.node, 0.55-rBBArmX*1.52, 0, 0);
    end;

	if self.drivingShaft ~= nil then
		local x,y,z = getRotation(self.wheels[1].driveNode);
		setRotation(self.drivingShaft.node, 0 ,0, x*2.3);	
	end;

end;

function IH3788:updateTick(dt)

	if self.isMotorStarted then
		if self.kinkJoint ~= 0 then
			setJointFrame(self.componentJoints[self.kinkJoint].jointIndex , 0, self.componentJoints[self.kinkJoint].jointNode);   
			local x, y, z = getRotation(self.kinkOrientation);	    
			setRotation(self.kinkOrientation, 0,y,0);
		end;
	end;
end;

function IH3788:validateAttacherJoint(implement, jointDesc, dt)
    if self.updateJoint then
        self.updateJoint = false;
        return true;
    end;
    return true;
end;

function IH3788:draw()
end;

function IH3788:onEnter()
end;

function IH3788:onLeave()
end;

function IH3788:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;
