--IFA W50LA
--powered by hz888
--hz888@freemail.hu

W50Kipper = {};

function W50Kipper.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function W50Kipper:load(xmlFile)

--motor

    self.startMotor = SpecializationUtil.callSpecializationsFunction("startMotor");
    self.stopMotor = SpecializationUtil.callSpecializationsFunction("stopMotor");
    self.startRefuel = SpecializationUtil.callSpecializationsFunction("startRefuel");
    self.stopRefuel = SpecializationUtil.callSpecializationsFunction("stopRefuel");
    self.setFuelFillLevel = SpecializationUtil.callSpecializationsFunction("setFuelFillLevel");


    self.fuelCapacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fuelCapacity"), 500);
    self.fuelUsage = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fuelUsage"), 0.01);


    self.hasRefuelStationInRange = false;
    self.doRefuel = false;
    self:setFuelFillLevel(self.fuelCapacity);

    self.refuelSampleRunning = false;
    self.refuelSample = createSample("refuelSample");
    loadSample(self.refuelSample, "data/maps/sounds/refuel.wav", false);

    local motorMinRpm = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motor#minRpm"), 1000);
    local motorMaxRpmStr = getXMLString(xmlFile, "vehicle.motor#maxRpm");
    local motorMaxRpm1, motorMaxRpm2, motorMaxRpm3 = Utils.getVectorFromString(motorMaxRpmStr);
    motorMaxRpm1 = Utils.getNoNil(motorMaxRpm1, 800);
    motorMaxRpm2 = Utils.getNoNil(motorMaxRpm2, 1000);
    motorMaxRpm3 = Utils.getNoNil(motorMaxRpm3, 1800);
    local motorMaxRpm = {motorMaxRpm1, motorMaxRpm2, motorMaxRpm3};
    local motorTorque = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motor#torque"), 15);
    local brakeForce = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motor#brakeForce"), 10)*2;
    local forwardGearRatioStr = getXMLString(xmlFile, "vehicle.motor#forwardGearRatio");
    local forwardGearRatio1, forwardGearRatio2, forwardGearRatio3 = Utils.getVectorFromString(forwardGearRatioStr);
    forwardGearRatio1 = Utils.getNoNil(forwardGearRatio1, 2);
    forwardGearRatio2 = Utils.getNoNil(forwardGearRatio2, forwardGearRatio1);
    forwardGearRatio3 = Utils.getNoNil(forwardGearRatio3, forwardGearRatio2);
    local forwardGearRatios = {forwardGearRatio1, forwardGearRatio2, forwardGearRatio3};
    local backwardGearRatio = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motor#backwardGearRatio"), 1.5);
    local differentialRatio = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motor#differentialRatio"), 1);
    local rpmFadeOutRange = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motor#rpmFadeOutRange"), 20);
    local torqueCurve = AnimCurve:new(linearInterpolator1);
    local torqueI = 0;
    while true do
        local key = string.format("vehicle.motor.torque(%d)", torqueI);
        local rpm = getXMLFloat(xmlFile, key.."#rpm");
        local torque = getXMLFloat(xmlFile, key.."#torque");
        if torque == nil or rpm == nil then
            break;
        end;
        torqueCurve:addKeyframe({v=torque*3, time = rpm});
        torqueI = torqueI +1;
    end;
    self.motor = VehicleMotor:new(motorMinRpm, motorMaxRpm, torqueCurve, brakeForce, forwardGearRatios, backwardGearRatio, differentialRatio, rpmFadeOutRange);

    local motorStartSound = getXMLString(xmlFile, "vehicle.motorStartSound#file");

    if motorStartSound ~= nil and motorStartSound ~= "" then
        motorStartSound = Utils.getFilename(motorStartSound, self.baseDirectory);
        self.motorStartSound = createSample("motorStartSound");
        loadSample(self.motorStartSound, motorStartSound, false);
        self.motorStartSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStartSound#pitchOffset"), 0);
        self.motorStartSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStartSound#volume"), 1.0);
    end;

    local motorStopSound = getXMLString(xmlFile, "vehicle.motorStopSound#file");
    if motorStopSound ~= nil and motorStopSound ~= "" then
        motorStopSound = Utils.getFilename(motorStopSound, self.baseDirectory);
        self.motorStopSound = createSample("motorStopSound");
        loadSample(self.motorStopSound, motorStopSound, false);
        self.motorStopSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStopSound#pitchOffset"), 0);
        self.motorStopSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStopSound#volume"), 1.0);
    end;

    local motorSound = getXMLString(xmlFile, "vehicle.motorSound#file");
    if motorSound ~= nil and motorSound ~= "" then
        motorSound = Utils.getFilename(motorSound, self.baseDirectory);
        self.motorSound = createSample("motorSound");
        loadSample(self.motorSound, motorSound, false);
        self.motorSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSound#pitchOffset"), 0);
        self.motorSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSound#pitchScale"), 0.05);
        self.motorSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSound#pitchMax"), 2.0);
        self.motorSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSound#volume"), 1.0);
    end;

    local motorSoundRun = getXMLString(xmlFile, "vehicle.motorSoundRun#file");
    if motorSoundRun ~= nil and motorSoundRun ~= "" then
        motorSoundRun = Utils.getFilename(motorSoundRun, self.baseDirectory);
        self.motorSoundRun = createSample("motorSoundRun");
        loadSample(self.motorSoundRun, motorSoundRun, false);
        self.motorSoundRunPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundRun#pitchOffset"), 0);
        self.motorSoundRunPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundRun#pitchScale"), 0.05);
        self.motorSoundRunPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundRun#pitchMax"), 2.0);
        self.motorSoundRunVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundRun#volume"), 1.0);
    end;

	self.isFadingInMotorSndRun        = false;
	self.fadeTime		    = 4000;
	self.currentFadeTime    = 0;
	self.motorSoundActualVolume    = 0;

    local reverseDriveSound = getXMLString(xmlFile, "vehicle.reverseDriveSound#file");
    if reverseDriveSound ~= nil and reverseDriveSound ~= "" then
        reverseDriveSound = Utils.getFilename(reverseDriveSound, self.baseDirectory);
        self.reverseDriveSound = createSample("reverseDriveSound");
        self.reverseDriveSoundEnabled = false;
        loadSample(self.reverseDriveSound, reverseDriveSound, false);
        self.reverseDriveSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.reverseDriveSound#volume"), 1.0);
    end;

    local compressedAirSound = getXMLString(xmlFile, "vehicle.compressedAirSound#file");
    if compressedAirSound ~= nil and compressedAirSound ~= "" then
        compressedAirSound = Utils.getFilename(compressedAirSound, self.baseDirectory);
        self.compressedAirSound = createSample("compressedAirSound");
        self.compressedAirSoundEnabled = false;
        loadSample(self.compressedAirSound, compressedAirSound, false);
        self.compressedAirSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.compressedAirSound#pitchOffset"), 1);
        self.compressedAirSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.compressedAirSound#volume"), 1);
    end;

    local compressionSound = getXMLString(xmlFile, "vehicle.compressionSound#file");
    if compressionSound ~= nil and compressionSound ~= "" then
        compressionSound = Utils.getFilename(compressionSound, self.baseDirectory);
        self.compressionSound = createSample("compressionSound");
        loadSample(self.compressionSound, compressionSound, false);
        self.compressionSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.compressionSound#pitchOffset"), 1);
        self.compressionSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.compressionSound#volume"), 1);
        self.compressionSoundTime = 0;
        self.compressionSoundEnabled = false;
    end;

	brakeSoundFile = Utils.getFilename("handbrake.wav", self.baseDirectory);
	self.brakeSoundId = createSample("brakeSound");
	loadSample(self.brakeSoundId, brakeSoundFile, false);

	turn1SoundFile = Utils.getFilename("turn1.wav", self.baseDirectory);
	self.turn1SoundId = createSample("turn1Sound");
	loadSample(self.turn1SoundId, turn1SoundFile, false);

	turn2SoundFile = Utils.getFilename("turn2.wav", self.baseDirectory);
	self.turn2SoundId = createSample("turn2Sound");
	loadSample(self.turn2SoundId, turn2SoundFile, false);

    self.isMotorStarted = false;

    self.exhaustParticleSystems = {};
    local exhaustParticleSystemCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.exhaustParticleSystems#count"), 0);
    for i=1, exhaustParticleSystemCount do
        local namei = string.format("vehicle.exhaustParticleSystems.exhaustParticleSystem%d", i);
        Utils.loadParticleSystem(xmlFile, self.exhaustParticleSystems, namei, self.components, false, nil, self.baseDirectory)
    end;

    self.lastRoundPerMinute = 0;

--steerable

    self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;

    self.onEnter = SpecializationUtil.callSpecializationsFunction("onEnter");
    self.onLeave = SpecializationUtil.callSpecializationsFunction("onLeave");
    self.drawGrainLevel = SpecializationUtil.callSpecializationsFunction("drawGrainLevel");


    self.enterReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.enterReferenceNode#index"));
    self.exitPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.exitPoint#index"));


    self.steering = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.steering#index"));
    if self.steering ~= nil then
        self.steeringSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.steering#rotationSpeed"), 0);
    end;

    self.numCameras = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cameras#count"), 0);
    if self.numCameras == 0 then
        print("Error: no cameras in xml file: ", configFile);
    end;
    self.cameras = {};
    for i=1, self.numCameras do
        local cameranamei = string.format("vehicle.cameras.camera%d", i);
        local camIndexStr = getXMLString(xmlFile, cameranamei .. "#index");
        local cameraNode = Utils.indexToObject(self.components, camIndexStr);
        local rotatable = getXMLBool(xmlFile, cameranamei .. "#rotatable");
        local limit = getXMLBool(xmlFile, cameranamei .. "#limit");
        local rotMinX = getXMLFloat(xmlFile, cameranamei .. "#rotMinX");
        local rotMaxX = getXMLFloat(xmlFile, cameranamei .. "#rotMaxX");
        local transMin = getXMLFloat(xmlFile, cameranamei .. "#transMin");
        local transMax = getXMLFloat(xmlFile, cameranamei .. "#transMax");
        local rotateNode = "";
        if rotatable then
            rotateNode = Utils.indexToObject(self.components, getXMLString(xmlFile, cameranamei .. "#rotateNode"));
        end;
        self.cameras[i] = VehicleCamera:new(cameraNode, rotatable, rotateNode, limit, rotMinX, rotMaxX, transMin, transMax);
    end;

    self.camIndex = 1;

    self.tipCamera = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tipCamera#index"));

    self.characterNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.characterNode#index"));
    if self.characterNode ~= nil then
        self.characterCameraMinDistance = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.characterNode#cameraMinDistance"), 1.5);
        setVisibility(self.characterNode, false);
    end;

    self.numLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.lights#count"), 0);
    self.lights = {};
    for i=1, self.numLights do
        local lightnamei = string.format("vehicle.lights.light" .. "%d", i);
        self.lights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, lightnamei .. "#index"));
        setVisibility(self.lights[i], false);
    end;

    self.numFarlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.farlights#count"), 0);
    self.farlights = {};
    for i=1, self.numFarlights do
        local farlightnamei = string.format("vehicle.farlights.farlight" .. "%d", i);
        self.farlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, farlightnamei .. "#index"));
        setVisibility(self.farlights[i], false);
    end;

    self.numBrakelights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.brakelights#count"), 0);
    self.brakelights = {};
    for i=1, self.numBrakelights do
        local brakelightnamei = string.format("vehicle.brakelights.brakelight" .. "%d", i);
        self.brakelights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, brakelightnamei .. "#index"));
        setVisibility(self.brakelights[i], false);
    end;

    self.numFlashlightsLeft = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.flashlightsLeft#count"), 0);
    self.flashlightsLeft = {};
    for i=1, self.numFlashlightsLeft do
        local flashlightLeftnamei = string.format("vehicle.flashlightsLeft.flashlightLeft" .. "%d", i);
        self.flashlightsLeft[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, flashlightLeftnamei .. "#index"));
        setVisibility(self.flashlightsLeft[i], false);
    end;
	
    self.numFlashlightsRight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.flashlightsRight#count"), 0);
    self.flashlightsRight = {};
    for i=1, self.numFlashlightsRight do
        local flashlightRightnamei = string.format("vehicle.flashlightsRight.flashlightRight" .. "%d", i);
        self.flashlightsRight[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, flashlightRightnamei .. "#index"));
        setVisibility(self.flashlightsRight[i], false);
    end;

    self.speedRotScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.speedRotScale#scale"), 80);
    self.speedRotScaleOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.speedRotScale#offset"), 0.7);
    self.automat = false;
    self.valt = true;
    self.isEntered = false;
    self.farlightsActive = false;
    self.frontlightsActive = false;
    self.lightsActive = false;
    self.brakelightsActive = false;
    self.flashlightsLeftActive = false;
    self.flashlightsRightActive = false;
    self.delayOnLeft = 0;
    self.delayOffLeft = 0;
    self.delayOnRight = 0;
    self.delayOffRight = 0;
    self.delayOn = 0;
    self.delayOff = 0;
    self.steeringEnabled = true;
    self.stopMotorOnLeave = true;
    self.disableCharacterOnLeave = true;
    self.deactivateOnLeave = true;
    self.stopRefuelOnLeave = true;
    self.deactivateLightsOnLeave = true;
    self.showWaterWarning = false;
    self.waterSplashSample = nil;
    self.hudBasePoxX = 0.8325;
    self.hudBasePoxY = (1-0.99);
    self.hudBaseWidth = 0.16;
    self.hudBaseHeight = 0.1625;
    self.hudBaseOverlay = Overlay:new("hudBaseOverlay", "dataS/missions/hud_vehicle_base".. g_languageSuffix .. ".png", self.hudBasePoxX, self.hudBasePoxY, self.hudBaseWidth, self.hudBaseHeight);
    self.gearfile = Utils.getFilename("ifagear.png", self.baseDirectory);
    self.hudGearWidth = 0.205;
    self.hudGearHeight = 0.255;
    self.hudGearPoxX = 0.81;
    self.hudGearPoxY = (1-0.3);
    self.hudGearOverlay = Overlay:new("hudGearpanel", self.gearfile, self.hudGearPoxX, self.hudGearPoxY, self.hudGearWidth, self.hudGearHeight);

end;

function W50Kipper:delete()

    Utils.deleteParticleSystem(self.exhaustParticleSystems);

    if self.refuelSample ~= nil then
        delete(self.refuelSample);
    end;
    if self.motorSound ~= nil then
        delete(self.motorSound);
    end;
    if self.motorSoundRun ~= nil then
        delete(self.motorSoundRun);
    end;
    if self.motorStartSound ~= nil then
        delete(self.motorStartSound);
    end;
    if self.motorStopSound ~= nil then
        delete(self.motorStopSound);
    end;
    if self.reverseDriveSound ~= nil then
        delete(self.reverseDriveSound);
    end;
    if self.compressedAirSound ~= nil then
        delete(self.compressedAirSound);
    end;
    if self.compressionSound ~= nil then
        delete(self.compressionSound);
    end;

    for i=1, table.getn(self.cameras) do
        self.cameras[i]:delete();
    end;

    if self.waterSplashSample ~= nil then
        delete(self.waterSplashSample);
    end;

    if self.hudBaseOverlay then
        self.hudBaseOverlay:delete();
    end;
end;

function W50Kipper:mouseEvent(posX, posY, isDown, isUp, button)
    self.cameras[self.camIndex]:mouseEvent(posX, posY, isDown, isUp, button);

	if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_LEFT) and not self.automat then
			if self.reverse == true then
				self.gang0 = true;
				self.reverse = false;
			elseif self.gang0 == true then
				self.gang1 = true;
				self.gang0 = false;
			elseif self.gang1 == true then
				self.gang2 = true;
				self.gang1 = false;
			elseif self.gang2 == true then
				self.gang3 = true;
				self.gang2 = false;
			elseif self.gang3 == true then
				self.gang4 = true;
				self.gang3 = false;
			elseif self.gang4 == true then
				self.gang5 = true;
				self.gang4 = false;
			elseif self.gang5 == true then
				self.gang6 = true;
				self.gang5 = false;
			elseif self.gang6 == true then
				self.gang7 = true;
				self.gang6 = false;
			elseif self.gang7 == true then
				self.gang8 = true;
				self.gang7 = false;
			end;
	end;
	if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_RIGHT) and not self.automat then
			if self.gang8 == true then
				self.gang7 = true;
				self.gang8 = false;
			elseif self.gang7 == true then
				self.gang6 = true;
				self.gang7 = false;
			elseif self.gang6 == true then
				self.gang5 = true;
				self.gang6 = false;
			elseif self.gang5 == true then
				self.gang4 = true;
				self.gang5 = false;
			elseif self.gang4 == true then
				self.gang3 = true;
				self.gang4 = false;
			elseif self.gang3 == true then
				self.gang2 = true;
				self.gang3 = false;
			elseif self.gang2 == true then
				self.gang1 = true;
				self.gang2 = false;
			elseif self.gang1 == true then
				self.gang0 = true;
				self.gang1 = false;
			elseif self.gang0 == true then
				self.reverse = true;
				self.gang0 = false;
			end;
	end;
end;

function W50Kipper:keyEvent(unicode, sym, modifier, isDown)

	if isDown and sym == (self.keys.kezifek) then
		self.handbrake = not self.handbrake
		if self.handbrake then
		playSample(self.brakeSoundId, 1, 1, 0);
		end;
	end;

	if isDown and sym == Input.KEY_backslash then
		self.helpPanel = not self.helpPanel;
	end;

	if isDown and sym == (self.keys.indexL) then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.flashlightsRightActive = false;
	end;
	if isDown and sym == (self.keys.indexR) then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.flashlightsLeftActive = false;
	end;
	if isDown and sym == (self.keys.elakadas) then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashlightsRightActive = false;
		self.flashlightsLeftActive = false;
	end;

	if isDown and sym == (self.keys.valto) then
		self.automat = not self.automat
		if self.automat then
			self.motor.backwardGearRatio = 1.5;
			self.motor.forwardGearRatios = {2, 2, 2};
			self.motor.brakeForce = 25;
			self.reverse = false;
			self.gang0 = true;
			self.gang1 = false;
			self.gang2 = false;
			self.gang3 = false;
			self.gang4 = false;
			self.gang5 = false;
			self.gang6 = false;
			self.gang7 = false;
			self.gang8 = false;

		end;
	end;

	if self.isEntered and not self.automat then
				if isDown and sym == Input.KEY_KP_9 then
						self.reverse = true;
						self.gang0 = false;
						self.gang1 = false;
						self.gang2 = false;
						self.gang3 = false;
						self.gang4 = false;
						self.gang5 = false;
						self.gang6 = false;
						self.gang7 = false;
						self.gang8 = false;
				end;
				if isDown and sym == Input.KEY_KP_0 then
						self.reverse = false;
						self.gang0 = true;
						self.gang1 = false;
						self.gang2 = false;
						self.gang3 = false;
						self.gang4 = false;
						self.gang5 = false;
						self.gang6 = false;
						self.gang7 = false;
						self.gang8 = false;
				end;
				if isDown and sym == Input.KEY_KP_1 then
						self.reverse = false;
						self.gang0 = false;
						self.gang1 = true;
						self.gang2 = false;
						self.gang3 = false;
						self.gang4 = false;
						self.gang6 = false;
						self.gang7 = false;
						self.gang8 = false;	
				end;
				if isDown and sym == Input.KEY_KP_2 then
						self.reverse = false;
						self.gang0 = false;
						self.gang1 = false;
						self.gang2 = true;
						self.gang3 = false;
						self.gang4 = false;
						self.gang5 = false;
						self.gang6 = false;
						self.gang7 = false;
						self.gang8 = false;
				end;
				if isDown and sym == Input.KEY_KP_3 then
						self.reverse = false;
						self.gang0 = false;
						self.gang1 = false;
						self.gang2 = false;
						self.gang3 = true;
						self.gang4 = false;
						self.gang5 = false;
						self.gang6 = false;
						self.gang7 = false;
						self.gang8 = false;		
				
				end;
				if isDown and sym == Input.KEY_KP_4 then
						self.reverse = false;
						self.gang0 = false;
						self.gang1 = false;
						self.gang2 = false;
						self.gang3 = false;
						self.gang4 = true;
						self.gang5 = false;
						self.gang6 = false;
						self.gang7 = false;
						self.gang8 = false;
				end;
				if isDown and sym == Input.KEY_KP_5 then
						self.reverse = false;
						self.gang0 = false;
						self.gang1 = false;
						self.gang2 = false;
						self.gang3 = false;
						self.gang4 = false;
						self.gang5 = true;
						self.gang6 = false;
						self.gang7 = false;
						self.gang8 = false;
				end;
				if isDown and sym == Input.KEY_KP_6 then
						self.reverse = false;
						self.gang0 = false;
						self.gang1 = false;
						self.gang2 = false;
						self.gang3 = false;
						self.gang4 = false;
						self.gang5 = false;
						self.gang6 = true;
						self.gang7 = false;
						self.gang8 = false;		
				end;
				if isDown and sym == Input.KEY_KP_7 then
						self.reverse = false;
						self.gang0 = false;
						self.gang1 = false;
						self.gang2 = false;
						self.gang3 = false;
						self.gang4 = false;
						self.gang5 = false;
						self.gang6 = false;
						self.gang7 = true;
						self.gang8 = false;
				end;
				if isDown and sym == Input.KEY_KP_8 then
						self.reverse = false;
						self.gang0 = false;
						self.gang1 = false;
						self.gang2 = false;
						self.gang3 = false;
						self.gang4 = false;
						self.gang5 = false;
						self.gang6 = false;
						self.gang7 = false;
						self.gang8 = true;
				end;
	end;
end;

function W50Kipper:update(dt)

    self.doRefuel = self.doRefuel and self.hasRefuelStationInRange;
    if self.doRefuel then

        if not self.refuelSampleRunning and self:getIsActiveForSound() then
            playSample(self.refuelSample, 0, 1, 0);
            self.refuelSampleRunning = true;
        end;

        local refuelSpeed = 0.01;
        local currentFillLevel = self.fuelFillLevel;
        self:setFuelFillLevel(self.fuelFillLevel+refuelSpeed*dt);
        local delta = (self.fuelFillLevel-currentFillLevel);

        if delta <= 0.05 then
            self.doRefuel = false;
        end;

        delta = delta * g_fuelPricePerLiter;

        g_currentMission.missionStats.expensesTotal = g_currentMission.missionStats.expensesTotal + delta;
        g_currentMission.missionStats.expensesSession = g_currentMission.missionStats.expensesSession + delta;
        g_currentMission.missionStats.money = g_currentMission.missionStats.money - delta;

    else
        if self.refuelSampleRunning then
            stopSample(self.refuelSample);
            self.refuelSampleRunning = false;
        end;
    end;

    if self.isMotorStarted then

        if self:getIsActiveForSound() then

            if self.playMotorSound then

                if self.motorSound ~= nil and self.playMotorSoundTime <= self.time then
                    playSample(self.motorSound, 0, self.motorSoundVolume, 0);
                    self.playMotorSound = false;



                    if self.motorSoundRun ~= nil then
                        playSample(self.motorSoundRun, 0, 0.0, 0);
                    end;
                end;

            end;

            if self.compressionSound ~= nil and self.compressionSoundTime < self.time then
                playSample(self.compressionSound, 1, self.compressionSoundVolume, 0);
                setSamplePitch(self.compressionSound, self.compressionSoundPitchOffset);
                self.compressionSoundTime = self.time + 180000;
                self.compressionSoundEnabled = true;
            end;

        end;

        if self.reverseDriveSound ~= nil then
            if self.movingDirection == -1 then
                if not self.reverseDriveSoundEnabled and self:getIsActiveForSound() then
                    playSample(self.reverseDriveSound, 0, self.reverseDriveSoundVolume, 0);
                    self.reverseDriveSoundEnabled = true;
                end;
            else
                if self.reverseDriveSoundEnabled then
                    stopSample(self.reverseDriveSound);
                    self.reverseDriveSoundEnabled = false;
                end;
            end;
        end;

        if table.getn(self.wheels) > 0 then
            local alpha = 0.9;
            local roundPerMinute = self.lastRoundPerMinute*alpha + (1-alpha)*(self.motor.lastMotorRpm-self.motor.minRpm);
            self.lastRoundPerMinute = roundPerMinute;
            local roundPerSecond = roundPerMinute / 60;

            if self.motorSound ~= nil then
                 setSamplePitch(self.motorSound, math.min(self.motorSoundPitchOffset + self.motorSoundPitchScale*math.abs(roundPerSecond), self.motorSoundPitchMax));

                if self.motorSoundRun ~= nil then
                    setSamplePitch(self.motorSoundRun, math.min(self.motorSoundRunPitchOffset + self.motorSoundRunPitchScale*math.abs(roundPerSecond), self.motorSoundRunPitchMax));
                end;

            end;

            self.input = InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);

            if InputBinding.isAxisZero(self.input) then
                self.input = InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
            end;


            if self.compressedAirSound ~= nil then

                if self.input == -1 and self.compressedAirSoundEnabled then
                    self.compressedAirSoundEnabled = false;
                end;

                if self.input == 1 and not self.compressedAirSoundEnabled then
                    if self:getIsActiveForSound() then
                        playSample(self.compressedAirSound, 1, self.compressedAirSoundVolume, 0);
                        setSamplePitch(self.compressedAirSound, self.compressedAirSoundPitchOffset);
			self.motor.brakeForce = 50;
                    end;
                    self.compressedAirSoundEnabled = true;
                end;

            end;

            if self.motorSoundRun ~= nil then

                local maxRpm  = self.motor.maxRpm[3];

                if self.input ~= 0 or self.motor.speedLevel ~= 0 then
                    local rpmVolume = Utils.clamp(math.abs(roundPerMinute)/((maxRpm - self.motor.minRpm)), 0.0, 1.0);
                    setSampleVolume(self.motorSoundRun, rpmVolume);
                else
                    local rpmVolume = Utils.clamp(math.abs(roundPerMinute)/((maxRpm - self.motor.minRpm)*2), 0.0, 1.0);
                    setSampleVolume(self.motorSoundRun, rpmVolume);
                end;

            end;

        end;
    end;


    if self:getIsActive() then
        if self.steering ~= nil then
            setRotation(self.steering, 0, self.rotatedTime*self.steeringSpeed, 0);
        end;

        local xt,yt,zt = getTranslation(self.components[1].node);
        local deltaWater = yt-g_currentMission.waterY+2.5;
        if deltaWater < 0 then
            self.isBroken = true;
            g_currentMission:onSunkVehicle();

            if self.isEntered then
                g_currentMission:onLeaveVehicle();

                if self:getIsActiveForSound() then
                    local volume = math.min(1, self.lastSpeed*3600/30);
                    if self.waterSplashSample == nil then
                        self.waterSplashSample = createSample("waterSplashSample");
                        loadSample(self.waterSplashSample, "data/maps/sounds/waterSplash.wav", false);
                    end;
                    playSample(self.waterSplashSample, 1, volume, 0);
                end;
            end;
        end;
        self.showWaterWarning = deltaWater < 2;

    end;


    if self.isEntered then

        if InputBinding.hasEvent(InputBinding.REFUEL) then
            if self.doRefuel then
                self:stopRefuel();
            else
                self:startRefuel();
            end;
        end;

        if self.characterNode ~= nil then
            local cx, cy, cz = getWorldTranslation(self.characterNode);
            local x,y,z = getWorldTranslation(getCamera());
            local dist = Utils.vector3Length(cx-x, cy-y, cz-z);
            if dist < self.characterCameraMinDistance then
                setVisibility(self.characterNode, false);
            else
                setVisibility(self.characterNode, true);
            end;
        end;

        if not g_currentMission.fixedCamera then
            setCamera(self.cameras[self.camIndex].cameraNode);
            self.cameras[self.camIndex]:update(dt);
        else
            if self.tipCamera ~= nil then
                setCamera(self.tipCamera);
            else
                self.cameras[self.camIndex]:resetCamera();
            end;
        end;

        if self.steeringEnabled then

            local fuelUsed = self.lastMovedDistance*self.fuelUsage;
            self:setFuelFillLevel(self.fuelFillLevel-fuelUsed);

            g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
            g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;

            g_currentMission.missionStats.traveledDistanceTotal = g_currentMission.missionStats.traveledDistanceTotal + self.lastMovedDistance*0.001;
            g_currentMission.missionStats.traveledDistanceSession = g_currentMission.missionStats.traveledDistanceSession + self.lastMovedDistance*0.001;

            local acceleration = 0;
            if g_currentMission.allowSteerableMoving and not self.playMotorSound and self.automat then
                acceleration = -InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);
                if InputBinding.isAxisZero(acceleration) then
                    acceleration = -InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
                end;
                if math.abs(acceleration) > 0.8 then
                    self.motor:setSpeedLevel(0, true)
                end;
                if self.motor.speedLevel ~= 0 then
                    acceleration = 1.0;
                end;
		if self.input == 1 and self.movingDirection == 1 then
			self.brakelightsActive = true;
		else
			self.brakelightsActive = false;
		end;
            end;

--transs

            if g_currentMission.allowSteerableMoving and not self.playMotorSound and not self.automat then
			if self.reverse then
                		if self.input == -1 or self.motor.speedLevel ~= 0 then 
					acceleration = -0.07;
				end;

			else
				if self.gang0 then
                		if self.input == -1 or self.motor.speedLevel ~= 0 then
						acceleration = 0;
					end;
				elseif self.gang1 then
                		if self.input == -1 or self.motor.speedLevel ~= 0 then
						acceleration = 0.1;
					end;
				elseif self.gang2 then
                		if self.input == -1 or self.motor.speedLevel ~= 0 then
						acceleration = 0.2;
					end;
				elseif self.gang3 then
                		if self.input == -1 or self.motor.speedLevel ~= 0 then
						acceleration = 0.25;
					end;
				elseif self.gang4 then
                		if self.input == -1 or self.motor.speedLevel ~= 0 then
						acceleration = 0.4;
					end;
				elseif self.gang5 then
                		if self.input == -1 or self.motor.speedLevel ~= 0 then
						acceleration = 0.5;
					end;
				elseif self.gang6 then
                		if self.input == -1 or self.motor.speedLevel ~= 0 then
						acceleration = 0.6;
					end;
				elseif self.gang7 then
                		if self.input == -1 or self.motor.speedLevel ~= 0 then
						acceleration = 0.7;
					end;
				elseif self.gang8 then
                		if self.input == -1 or self.motor.speedLevel ~= 0 then
						acceleration = 0.9;
					end;
				end;
			end;

			if self.input == 1 then
				self.motor:setSpeedLevel(0, true)
				self.motor.brakeForce = 50;
				self.brakelightsActive = true;
			else
				self.brakelightsActive = false;
			end;
			if self.input == -1 then
				self.motor:setSpeedLevel(0,true)
				self.motor.brakeForce = 0;
			end;

			local ratio = 0;

			if self.reverse then
				ratio = 10;
				self.motor.backwardGearRatio = ratio;
			elseif self.gang0 then
				ratio = 0;
				self.motor.backwardGearRatio = ratio;
				self.motor.forwardGearRatios = {ratio, ratio, ratio};
			elseif self.gang1 then
				ratio = 10;
				self.motor.forwardGearRatios = {ratio, ratio, ratio};
			elseif self.gang2 then
				ratio = 8;
				self.motor.forwardGearRatios = {ratio, ratio, ratio};
			elseif self.gang3 then
				ratio = 7;
				self.motor.forwardGearRatios = {ratio, ratio, ratio};
			elseif self.gang4 then
				ratio = 6;
				self.motor.forwardGearRatios = {ratio, ratio, ratio};
			elseif self.gang5 then
				ratio = 5;
				self.motor.forwardGearRatios = {ratio, ratio, ratio};
			elseif self.gang6 then
				ratio = 4;
				self.motor.forwardGearRatios = {ratio, ratio, ratio};
			elseif self.gang7 then
				ratio = 3;
				self.motor.forwardGearRatios = {ratio, ratio, ratio};
			elseif self.gang8 then
				ratio = 2;
				self.motor.forwardGearRatios = {ratio, ratio, ratio};
			end;
			
        end;
       
	if self.handbrake then
		acceleration = 0;
		self.motor.brakeForce = 100;
   		self.brakelightsActive = true;		
	elseif self.input == 0 and not self.automat then
		self.motor.brakeForce = 0;
    		self.brakelightsActive = false;
	end;

            if self.fuelFillLevel == 0 then
                acceleration = 0;
            end;


            local inputAxisX = InputBinding.getAnalogInputAxis(InputBinding.AXIS_SIDE);
            if not InputBinding.isAxisZero(inputAxisX) then
                if inputAxisX < 0 then
                    self.rotatedTime = math.min(-self.maxRotTime*inputAxisX, self.maxRotTime);
                else
                    self.rotatedTime = math.max(self.minRotTime*inputAxisX, self.minRotTime);
                end;
            else
                local rotScale = math.min(1.0/(self.lastSpeed*self.speedRotScale+self.speedRotScaleOffset), 1);
                local inputAxisX = InputBinding.getDigitalInputAxis(InputBinding.AXIS_SIDE);
                if inputAxisX < 0 then
                    self.rotatedTime = math.min(self.rotatedTime - dt/1000*inputAxisX*rotScale, self.maxRotTime);
                elseif inputAxisX > 0 then
                    self.rotatedTime = math.max(self.rotatedTime - dt/1000*inputAxisX*rotScale, self.minRotTime);
                else
                    if self.autoRotateBackSpeed ~= 0 then
                        if self.rotatedTime > 0 then
                            self.rotatedTime = math.max(self.rotatedTime - dt/1000*self.autoRotateBackSpeed*rotScale, 0);
                        else
                            self.rotatedTime = math.min(self.rotatedTime + dt/1000*self.autoRotateBackSpeed*rotScale, 0);
                        end;
                    end;
                end;
            end;

            if self.firstTimeRun then
                WheelsUtil.updateWheelsPhysics(self, dt, self.lastSpeed, acceleration, false, self.requiredDriveMode)
            end;
        end;


        if InputBinding.hasEvent(InputBinding.SWITCH_IMPLEMENT) then
            local selected = self.selectedImplement;
            local numImplements = table.getn(self.attachedImplements);
            if selected ~= 0 and numImplements > 1 then
                selected = selected+1;
                if selected > numImplements then
                    selected = 1;
                end;
                self:setSelectedImplement(selected);
            end;
        end;

        if not g_currentMission.fixedCamera then
            if InputBinding.hasEvent(InputBinding.CAMERA_SWITCH) then
                self.cameras[self.camIndex]:onDeactivate();
                self.camIndex = self.camIndex + 1;
                if self.camIndex > self.numCameras then
                    self.camIndex = 1;
                end;
                self.cameras[self.camIndex]:onActivate();
            end;
        end;
        if InputBinding.hasEvent(InputBinding.TOGGLE_LIGHTS) then
            	if self.lightsActive == false and self.farlightsActive == false and self.frontlightsActive == false then
			self.lightsActive = true;
			self.frontlightsActive = true;
		elseif self.frontlightsActive == true then
			self.farlightsActive = true;
			self.frontlightsActive = false;
		elseif self.farlightsActive == true then
			self.farlightsActive = false;
			self.lightsActive = false;
		end;
        end;
	if self.isEntered then
		if self.lightsActive then
			for i=1, self.numLights do
				local light = self.lights[i];
				setVisibility(light, self.lightsActive);		
			end;
		else
			for i=1, self.numLights	do
				local light = self.lights[i];
				setVisibility(light, self.lightsActive, false);
			end;
		end;

		if self.frontlightsActive then
				setTextBold(true);
				setTextColor(0,1,0,1);
				renderText(self.hudGearPoxX+0.123, self.hudGearPoxY+0.065, 0.026, "=");
				renderText(self.hudGearPoxX+0.119, self.hudGearPoxY+0.067, 0.026, "(");
		end;

		if self.farlightsActive then
			for i=1, self.numFarlights do
				local farlight = self.farlights[i];
				setVisibility(farlight, self.farlightsActive);
				setTextColor(0,0,1,1);
				renderText(self.hudGearPoxX+0.123, self.hudGearPoxY+0.065, 0.026, "=");
				renderText(self.hudGearPoxX+0.119, self.hudGearPoxY+0.067, 0.026, "(");
			end;
		else
			for i=1, self.numFarlights	do
				local farlight = self.farlights[i];
				setVisibility(farlight, self.farlightsActive, false);
			end;
		end;

		if self.brakelightsActive then
			for i=1, self.numBrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive);
			end;
		else
			for i=1, self.numBrakelights do
				local brakelight = self.brakelights[i];
				setVisibility(brakelight, self.brakelightsActive, false);
			end;
		end;

		if self.flashlightsLeftActive then
			for i=1, self.numFlashlightsLeft do
				local flashlightLeft = self.flashlightsLeft[i];
				setVisibility(flashlightLeft, self.flashlightsLeftActive);
			end;
		else
			for i=1, self.numFlashlightsLeft do
				local flashlightLeft = self.flashlightsLeft[i];
				setVisibility(flashlightLeft, self.flashlightsLeftActive, false);
			end;
		end;
	
		if self.flashlightsRightActive then
			for i=1, self.numFlashlightsRight do
				local flashlightRight = self.flashlightsRight[i];
				setVisibility(flashlightRight, self.flashlightsRightActive);
			end;
		else
			for i=1, self.numFlashlightsRight do
				local flashlightRight = self.flashlightsRight[i];
				setVisibility(flashlightRight, self.flashlightsRightActive, false);
			end;
		end;

		if self.flashLeft then
			if self.delayOnLeft >= -1 then
				self.delayOnLeft = self.delayOnLeft -dt;
			end;
			if not self.flashlightsLeftActive then
				if self.delayOnLeft < 0 then
					self.delayOffLeft = 500;
					self.flashlightsLeftActive = true;
					playSample(self.turn1SoundId, 1, 0.7, 0);
				end;
			end;
			if self.delayOffLeft >= 0 then
				self.delayOffLeft = self.delayOffLeft -dt;
			end;
			if self.flashlightsLeftActive then
				if self.delayOffLeft < 0 then
					self.delayOnLeft = 500;
					self.flashlightsLeftActive = false;
					playSample(self.turn2SoundId, 1, 0.7, 0);
				end;
			end;
		end;

		if self.flashRight then
			if self.delayOnRight >= 0 then
				self.delayOnRight = self.delayOnRight -dt;
			end;
			if not self.flashlightsRightActive then
				if self.delayOnRight < 0 then
					self.delayOffRight = 500;
					self.flashlightsRightActive = true;
					playSample(self.turn1SoundId, 1, 0.7, 0);
				end;
			end;
			if self.delayOffRight >= 0 then
				self.delayOffRight = self.delayOffRight -dt;
			end;
			if self.flashlightsRightActive then
				if self.delayOffRight < 0 then
					self.delayOnRight = 500;
					self.flashlightsRightActive = false;
					playSample(self.turn2SoundId, 1, 0.7, 0);
				end;
			end;
		end;

		if self.flash then
			if self.delayOn >= 0 then
				self.delayOn = self.delayOn -dt;
			end;
			if not self.flashlightsRightActive then
				if self.delayOn < 0 then
					self.delayOff = 500;
					self.flashlightsRightActive = true;
					self.flashlightsLeftActive = true;
					playSample(self.turn1SoundId, 1, 0.7, 0);
				end;
			end;
			if self.delayOff >= 0 then
				self.delayOff = self.delayOff -dt;
			end;
			if self.flashlightsRightActive then
				if self.delayOff < 0 then
					self.delayOn = 500;
					self.flashlightsLeftActive = false;
					self.flashlightsRightActive = false;
					playSample(self.turn2SoundId, 1, 0.7, 0);
				end;
			end;
		end;

		if not self.flashLeft and not self.flashRight then
			if not self.flash then
				self.flashlightsRightActive = false;
				self.flashlightsLeftActive = false;
			end;
		end;
		
		if not self.flash and not self.flashLeft then
			if not self.flashRight then
				self.flashlightsRightActive = false;
			end;
		end;

		if not self.flash and not self.flashRight then
			if not self.flashLeft then
				self.flashlightLeftActive = false;
			end;
		end;
	end;

        if InputBinding.hasEvent(InputBinding.SPEED_LEVEL1) then
            self.motor:setSpeedLevel(1, false);
        elseif InputBinding.hasEvent(InputBinding.SPEED_LEVEL2) then
            self.motor:setSpeedLevel(2, false);
        elseif InputBinding.hasEvent(InputBinding.SPEED_LEVEL3) then
            self.motor:setSpeedLevel(3, false);
        end;

        if InputBinding.hasEvent(InputBinding.ATTACH) then
            self:handleAttachEvent();
        end;

        if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
            self:handleLowerImplementEvent();
        end;
	if not self.helpPanel then
		setTextColor(1,1,1,1);
		renderText(0.92, 0.74, 0.021, "#: Info be");
	else
		setTextColor(1,1,1,1);
		renderText(0.92, 0.74, 0.021, "#: Info ki");
	end;
	if self.helpPanel then
		renderText(0.02, 0.50, 0.023, "IFA L60 info");
		renderText(0.02, 0.48, 0.021, "F: fenyszoro tompitott/tavolsagi/ki");
		renderText(0.02, 0.46, 0.021, "SPACE: rgzitfek");
		renderText(0.02, 0.44, 0.021, "f4: elakadasjelz");
		renderText(0.02, 0.42, 0.021, "f2/f3: iranyjelz bal/jobb");
		renderText(0.02, 0.40, 0.021, "ENTER: sebessgvalto automata/manual");
		renderText(0.02, 0.38, 0.021, "         sebesseg fokozat:");
		renderText(0.02, 0.36, 0.021, "NUM0: res NUM1: 1  NUM2: 2  NUM3: 3");
		renderText(0.02, 0.34, 0.021, "NUM4: 4  NUM5: 5  NUM6: 6  NUM7: 7");
		renderText(0.02, 0.32, 0.021, "NUM8: 8  NUM9: hatra");
	end;

    end;

end;

function W50Kipper:draw()

    local kmh = self.lastSpeed*self.speedDisplayScale*3600;

    self.hudBaseOverlay:render();

    setTextBold(true);

    setTextColor(1.0, 1.0, 1.0, 1.0);
    if kmh > 0 and kmh < 100 then
        renderText(self.hudBasePoxX+0.007, self.hudBasePoxY+0.095, 0.06, string.format("%2d", kmh));
    end;
    renderText(self.hudBasePoxX+0.058, self.hudBasePoxY+0.094, 0.06, g_i18n:getText("speedometer"));
    renderText(self.hudBasePoxX+0.031, self.hudBasePoxY+0.071, 0.03, string.format("%d", g_currentMission.missionStats.money));

    local fuelWarn = 50;
    if self.fuelFillLevel < fuelWarn then
        setTextColor(1,0,0,1);
    end;
    renderText(self.hudBasePoxX+0.031, self.hudBasePoxY+0.039, 0.03, string.format("%d " .. g_i18n:getText("fluid_unit_long"), self.fuelFillLevel));
    if self.fuelFillLevel < fuelWarn then
        setTextColor(1,1,1,1);
    end;

    setTextBold(false);


    if self.hasRefuelStationInRange and not self.doRefuel and self.fuelFillLevel ~= self.fuelCapacity then
        g_currentMission:addHelpButtonText(g_i18n:getText("Refuel"), InputBinding.REFUEL);
        g_currentMission.hudFuelOverlay:render();
    end;

    if self.showWaterWarning then
        g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_depth_into_the_water"), 0.05, 0.025+0.007);

    end;

    local trailerFillLevel, trailerCapacity = self:getAttachedTrailersFillLevelAndCapacity();
    if trailerFillLevel ~= nil and trailerCapacity ~= nil then
        self:drawGrainLevel(trailerFillLevel+self.fillLevel, trailerCapacity+self.capacity, 101);
    else
	self:drawGrainLevel(self.fillLevel, self.capacity, 101);
    end;
    if table.getn(self.attachedImplements) > 1 then
        g_currentMission:addHelpButtonText(g_i18n:getText("Change_tools"), InputBinding.SWITCH_IMPLEMENT);
    end;

    self.hudGearOverlay:render();

    if self.isEntered then

	if self.automat then
		setTextBold(true);
		setTextColor(1,0,0,1);
		renderText(self.hudGearPoxX+0.01, self.hudGearPoxY+0.15, 0.024, "A");
	else
		setTextBold(true);
		setTextColor(1,0,0,1);
		renderText(self.hudGearPoxX+0.01, self.hudGearPoxY+0.15, 0.024, "M");
	end;
	if self.handbrake then
		setTextBold(true);
		setTextColor(1,0,0,1);
		if self.input == -1 then
			setTextBold(true);
			setTextColor(1,0,0,1);
			renderText(0.3, 0.3, 0.05, "RGZITFEK KIENGED!");
		end;
		renderText(self.hudGearPoxX+0.0945, self.hudGearPoxY+0.163, 0.026, "(!)");
	end;

		if self.reverse then
			setTextColor(0,0.4,0.5,1);
			setTextBold(true);
			renderText(self.hudGearPoxX+0.014, self.hudGearPoxY+0.1, 0.024, "R");
		else
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(self.hudGearPoxX+0.014, self.hudGearPoxY+0.1, 0.024, "R");
		end;

		if self.gang0 then
			setTextColor(0,0.4,0.5,1);
			setTextBold(true);
			renderText(self.hudGearPoxX+0.098, self.hudGearPoxY+0.123, 0.024, "N");
		else
			setTextColor(0,0.5,0,1);
			setTextBold(true);
			renderText(self.hudGearPoxX+0.098, self.hudGearPoxY+0.123, 0.024, "N");
		end;
		if self.gang1 then
			setTextColor(0,0.4,0.5,1);
			setTextBold(true);
			renderText(self.hudGearPoxX+0.04, self.hudGearPoxY+0.15, 0.024, "1");
		else
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(self.hudGearPoxX+0.04, self.hudGearPoxY+0.15, 0.024, "1");
		end;

		if self.gang2 then
			setTextColor(0,0.4,0.5,1);
			setTextBold(true);
			renderText(self.hudGearPoxX+0.04, self.hudGearPoxY+0.1, 0.024, "2");
		else
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(self.hudGearPoxX+0.04, self.hudGearPoxY+0.1, 0.024, "2");
		end;
		if self.gang3 then
			setTextColor(0,0.4,0.5,1);
			setTextBold(true);
			renderText(self.hudGearPoxX+0.08, self.hudGearPoxY+0.15, 0.024, "3");
		else
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(self.hudGearPoxX+0.08, self.hudGearPoxY+0.15, 0.024, "3");
		end;
		if self.gang4 then
			setTextColor(0,0.4,0.5,1);
			setTextBold(true);
			renderText(self.hudGearPoxX+0.08, self.hudGearPoxY+0.1, 0.024, "4");
		else
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(self.hudGearPoxX+0.08, self.hudGearPoxY+0.1, 0.024, "4");
		end;
		if self.gang5 then
			setTextColor(0,0.4,0.5,1);
			setTextBold(true);
			renderText(self.hudGearPoxX+0.12, self.hudGearPoxY+0.15, 0.024, "5");
		else
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(self.hudGearPoxX+0.12, self.hudGearPoxY+0.15, 0.024, "5");
		end;
		if self.gang6 then
			setTextColor(0,0.4,0.5,1);
			setTextBold(true);
			renderText(self.hudGearPoxX+0.12, self.hudGearPoxY+0.1, 0.024, "6");
		else
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(self.hudGearPoxX+0.12, self.hudGearPoxY+0.1, 0.024, "6");
		end;
		if self.gang7 then
			setTextColor(0,0.4,0.5,1);
			setTextBold(true);
			renderText(self.hudGearPoxX+0.16, self.hudGearPoxY+0.15, 0.024, "7");
		else
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(self.hudGearPoxX+0.16, self.hudGearPoxY+0.15, 0.024, "7");
		end;
		if self.gang8 then
			setTextColor(0,0.4,0.5,1);
			setTextBold(true);
			renderText(self.hudGearPoxX+0.16, self.hudGearPoxY+0.1, 0.024, "8");
		else
			setTextColor(1,1,1,1);
			setTextBold(true);
			renderText(self.hudGearPoxX+0.16, self.hudGearPoxY+0.1, 0.024, "8");
		end;
	end;

end;

function W50Kipper:onEnter()

    self.isEntered = true;
    self.handbrake = true;
    self:startMotor();
    self.gang0 = true;
    self.camIndex = 1;
    self.cameras[self.camIndex]:onActivate();

    if self.characterNode ~= nil then
        setVisibility(self.characterNode, true);
    end;

    self:onActivateAttachements();
end;

function W50Kipper:onLeave()

    self.farlightsActive = false;
    self.frontlightsActive = false;
    self.lightsActive = false;
    self.handbrake = false;
    self.brakelightsActive = false;
    self.handbrakelightsActive = false;
    self.helpPanel = false;
    self.cameras[self.camIndex]:onDeactivate();
    self.motor.brakeForce = 100;
    self.flashlightsRightActive = false;
    self.flashlightsLeftActive = false;
    self.reverse = false;
    self.gang0 = true;
    self.gang1 = false;
    self.gang2 = false;
    self.gang3 = false;
    self.gang4 = false;
    self.gang5 = false;
    self.gang5 = false;
    self.gang5 = false;
    self.gang5 = false;
    if self.stopRefuelOnLeave then
        self:stopRefuel();
    end;
	for i=1, self.numFarlights	do
		local farlight = self.farlights[i];
		setVisibility(farlight, self.farlightsActive, false);
	end;
	for i=1, self.numBrakelights do
		local brakelight = self.brakelights[i];
		setVisibility(brakelight, self.brakelightsActive, false);
	end;
	for i=1, self.numFlashlightsLeft do
		local flashlightLeft = self.flashlightsLeft[i];
		setVisibility(flashlightLeft, self.flashlightsLeftActive, false);
	end;
	for i=1, self.numFlashlightsRight do
		local flashlightRight = self.flashlightsRight[i];
		setVisibility(flashlightRight, self.flashlightsRightActive, false);
	end;

    if self.deactivateLightsOnLeave then
        self:setLightsVisibility(false);
    end;

    if self.characterNode ~= nil then
        if self.disableCharacterOnLeave then
            setVisibility(self.characterNode, false);
        else
            setVisibility(self.characterNode, true);
        end;
    end;

    if self.stopMotorOnLeave then
        self:stopMotor();
    else
        Motorized.stopSounds(self);
    end;

    if self.deactivateOnLeave then
        for k,wheel in pairs(self.wheels) do
            setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
        end;
        self:onDeactivateAttachements();
    else
        if self.deactivateLightsOnLeave then
            self:onDeactivateAttachementsLights();
        end;
        self:onDeactivateAttachementsSounds();
    end;
    self.isEntered = false;
end;

function W50Kipper:drawGrainLevel(level, capacity, warnPercent)

    local percent = 0;
    if capacity > 0 then
        percent = level/capacity*100;
    end;
    setTextBold(true);

    if percent >= warnPercent then
        setTextColor(1.0, 0.0, 0.0, 1.0);
    else
        setTextColor(1.0, 1.0, 1.0, 1.0);
    end;

    renderText(self.hudBasePoxX+0.031, self.hudBasePoxY+0.006, 0.03, string.format("%d(%d%%)", level, percent));
    if percent >= warnPercent then
        setTextColor(1.0, 1.0, 1.0, 1.0);
    end;
    setTextBold(false);
end;

function W50Kipper:startMotor()

    if not self.isMotorStarted then
        self.isMotorStarted = true;

        self.reverseDriveSoundEnabled = false;

        local motorSoundOffset = 0;
        if self.motorStartSound ~= nil and self:getIsActiveForSound() then
            playSample(self.motorStartSound, 1, self.motorStartSoundVolume, 0);
            setSamplePitch(self.motorStartSound, self.motorStartSoundPitchOffset);
            motorSoundOffset = getSampleDuration(self.motorStartSound);
        end;

        self.playMotorSound = true;
        self.playMotorSoundTime = self.time+motorSoundOffset;
        self.playCompressionSoundTime = self.time+motorSoundOffset;
        self.compressionSoundTime = self.time + 180000;

        self.lastRoundPerMinute=0;

        Utils.setEmittingState(self.exhaustParticleSystems, true)
    else
        self.playMotorSound = true;
    end;
end;

function W50Kipper:stopMotor()

    self.isMotorStarted = false;
    Motorized.stopSounds(self);

    if self:getIsActiveForSound() then
        if self.motorStopSound ~= nil then
            setSamplePitch(self.motorStopSound, self.motorStopSoundPitchOffset);
            playSample(self.motorStopSound, 1, self.motorStopSoundVolume, 0);
        end;
    end;

    self.motor:setSpeedLevel(0, false);

    Utils.setEmittingState(self.exhaustParticleSystems, false)
end;

function W50Kipper:stopSounds()

    self.playMotorSound = false;
    if self.motorSound ~= nil then
        stopSample(self.motorSound);
    end;

    self.playMotorRunSound = false;
    if self.motorSoundRun ~= nil then
        stopSample(self.motorSoundRun);
    end;

    if self.motorStartSound ~= nil then
        stopSample(self.motorStartSound);
    end;

    if self.compressionSoundEnabled then
        stopSample(self.compressionSound);
        self.compressionSoundEnabled = false;
    end;

    if self.reverseDriveSoundEnabled then
        stopSample(self.reverseDriveSound);
        self.reverseDriveSoundEnabled = false;
    end;
end;

function W50Kipper:startRefuel()

    if self.hasRefuelStationInRange then
        self.doRefuel = true;
    end;
end;

function W50Kipper:stopRefuel()

    self.doRefuel = false;

    if self.refuelSampleRunning then
        stopSample(self.refuelSample);
        self.refuelSampleRunning = false;
    end;
end;


function W50Kipper:setFuelFillLevel(newFillLevel)

    self.fuelFillLevel = math.max(math.min(newFillLevel, self.fuelCapacity), 0);
end;