Kipper = {};

function Kipper.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Kipper:load(xmlFile)

	self.revLimit = 4200;
	self.maxRpm1 = self.motor.maxRpm[1];
	self.maxRpm2 = self.motor.maxRpm[2];
	self.maxRpm3 = self.motor.maxRpm[3];

    self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;

end;

function Kipper:delete()
end;

function Kipper:mouseEvent()
end;

function Kipper:keyEvent(unicode, sym, modifier, isDown)
end;

function Kipper:update(dt)

       if Input.isKeyPressed(self.keys.rev_up) and self.revLimit < 4200 then
          self.revLimit = self.revLimit + 25;
        elseif Input.isKeyPressed(self.keys.rev_down) and self.revLimit > 550 then
          self.revLimit = self.revLimit - 25;
       end;
        self.motor.maxRpm[1] = string.format("%d",(self.revLimit * self.maxRpm1 / 4200));
	self.motor.maxRpm[2] = string.format("%d",(self.revLimit * self.maxRpm2 / 4200));
	self.motor.maxRpm[3] = string.format("%d",(self.revLimit * self.maxRpm3 / 4200));
end;

function Kipper:draw()
end;