PlaneEvent = {};
PlaneEvent_mt = Class(PlaneEvent, Event);

InitEventClass(PlaneEvent, "PlaneEvent");

function PlaneEvent:emptyNew()
    local self = Event:new(PlaneEvent_mt);
    self.className="PlaneEvent";
    return self;
end;

function PlaneEvent:new(object, data)
    local self = PlaneEvent:emptyNew()
    self.object = object;
	self.data = data;
    return self;
end;

function PlaneEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.data = streamReadBool(streamId);
	self.object.planeActive = self.data;
	if not connection:getIsServer() then
        g_server:broadcastEvent(PlaneEvent:new(self.object, self.data), nil, connection, self.object);
    end;
end;

function PlaneEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.data);
end;

function PlaneEvent.sendEvent(vehicle, data)
	if g_server ~= nil then
		g_server:broadcastEvent(PlaneEvent:new(vehicle, data), nil, nil, vehicle);
	else
		g_client:getServerConnection():sendEvent(PlaneEvent:new(vehicle, data));
	end;
end;

