--
-- FMap
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

FMap = {}

local FMap_mt = Class(FMap, Mission00);

function FMap:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = FMap_mt;
    end;
    local self = FMap:superClass():new(baseDirectory, mt);
    return self;
end;

function FMap:delete()
    FMap:superClass().delete(self);
end;

function FMap:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
    
        
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("missions/CattleMeadow.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
    
    
	--load Glass Containers
    self:loadGlassContainers(Utils.getFilename("missions/glassContainers.i3d", self.baseDirectory));
	
	--load Bottles
    self:loadCollectableBottles(Utils.getFilename("missions/collectableBottles.i3d", self.baseDirectory));
 

    
	FMap:superClass().load(self);
end
function FMap:loadFinished()
    FMap:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function FMap:mouseEvent(posX, posY, isDown, isUp, button)
    FMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function FMap:keyEvent(unicode, sym, modifier, isDown)
    FMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function FMap:update(dt)
    FMap:superClass().update(self, dt);
end;

function FMap:draw()
    FMap:superClass().draw(self);
end;
