--
-- Rundumleuchte
-- Specialization for beacon-lights
-- Spezialisierung fr Rundumleuchten
-- @author  Sven777b
-- 
-- Modifikationen erst nach Rcksprache
--

Blaulicht = {};

function Blaulicht.prerequisitesPresent(specializations)
    return true;
end;

function Blaulicht:load(xmlFile)
    print("*****************");
    print("Holz LKW mit Kran");
		local i = 0;
		self.blaulicht = {};
    self.blaulichtAn = false;
		while true do
			local bRKL = {};
			local objname = string.format("vehicle.blaulichter.blaulicht(%d)",i);
      local rotnode = getXMLString(xmlFile, objname .. "#rotNode");
      if rotnode == nil then 
      	break;
      end;
      bRKL = {};
      bRKL.rotNode = Utils.indexToObject(self.components, rotnode);
      bRKL.light = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#light"));
      if(bRKL.rotNode == nil or bRKL.light == nil) then
      	print("Error: Index ("..rotnode..") zur Rundumleuchte nicht gefunden");
      else
	      bRKL.speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
	      bRKL.source = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#lightsource"));
	      if (bRKL.source == nil) then
	      	bRKL.emit = false;
	      else
      		bRKL.emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
      		if not bRKL.emit then
      			setVisibility(bRKL.source, false);
      		end;
      	end;
      	table.insert(self.blaulicht, bRKL);
      end;
      i=i+1;
    end;
    self.blaulichtAnz = table.getn(self.blaulicht);
end;

function Blaulicht:delete()
end;

function Blaulicht:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Blaulicht:keyEvent(unicode, sym, modifier, isDown)
end;

function Blaulicht:update(dt)
  if self:getIsActiveForInput() then
      if InputBinding.hasEvent(InputBinding.BLAULICHT) then
          self.blaulichtAn = not self.blaulichtAn;
          self.fl_activeLights["strassenfeger"] = not self.fl_activeLights["strassenfeger"];
	  self.fl_waitCounter["strassenfeger"] = 0;
      end;
  end;

--- if self.blaulichtAnz > 0 and self:getIsActive() then
  if self.blaulichtAnz > 0 then
    for i=1, self.blaulichtAnz do
      setVisibility(self.blaulicht[i].light, self.blaulichtAn);
      if self.blaulichtAn then
        rotate(self.blaulicht[i].rotNode, 0, dt*self.blaulicht[i].speed, 0);
      end;
    end;
  end;
end;

function Blaulicht:draw()
    --if self.blaulichtAnz > 0 and self:getIsActive() then
    --		g_currentMission:addHelpButtonText(g_i18n:getText("MANblaulicht"), InputBinding.BLAULICHT);
    --end;
end;

