--
-- Fliegl_Pritsche_FW NEW SCRIPT FOR LS2009
--
-- @Original-author Manuel L. (1.LS-Modschmiede)
-- @author Hoschiander (www.mein-ls.de)
-- @date 28/10/2009

Fliegl_Pritsche_FW = {};

function Fliegl_Pritsche_FW.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function Fliegl_Pritsche_FW:load(xmlFile)

	self.armPos = {};

	self.workingArmMoving = 0;

	self.doTransportMove = false;
	local doorflNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.animParts.part3#rootNode"));
	local doorfrNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.animParts.part5#rootNode"));
	local doorblNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.animParts.part4#rootNode"));
	local doorbrNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.animParts.part6#rootNode"));
	local doorbNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.animParts.part7#rootNode"));
    if doorflNode ~= nil and doorfrNode ~= nil and doorblNode ~= nil and doorbrNode ~= nil and doorbNode ~= nil then
        self.door = {};
        self.door.front = {};
        self.door.back = {};
        self.door.flnode = doorflNode;
        self.door.frnode = doorfrNode;
        self.door.blnode = doorblNode;
        self.door.brnode = doorbrNode;
        self.door.bnode = doorbNode;

		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.doorLimits#minRot"));
        self.door.minRot = {};
        self.door.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.door.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.door.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.doorLimits#maxRotf"));

        self.door.front.maxRot = {};
        self.door.front.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.door.front.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.door.front.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.doorLimits#maxRotb"));
        self.door.back.maxRot = {};
        self.door.back.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.door.back.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.door.back.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        
        self.door.flup = true;
        self.door.frup = true;
        self.door.blup = true;
        self.door.brup = true;
        self.door.bup = true;
        
        self.door.fldown = true;
        self.door.frdown = true;
        self.door.bldown = true;
        self.door.brdown = true;
        self.door.bdown = true;

        self.door.closeall = false;
		self.door.openall = false;
		self.door.docheck = false;
        
	end;
	
	
    self.hudInfoBasePosXd = 0.73;
    self.hudInfoBaseWidthd = 0.35;
    self.hudInfoBasePosYd = 0.2775;
    self.hudInfoBaseHeightd = 0.58;
    self.infoPanelPathd = Utils.getFilename("CraneDoors.png", self.baseDirectory);
	self.hudInfoBaseOverlayd = Overlay:new("hudInfoBaseOverlay", self.infoPanelPathd, self.hudInfoBasePosXd, self.hudInfoBasePosYd, self.hudInfoBaseWidthd, self.hudInfoBaseHeightd);
    self.showHudInfoBased = true;

end;

function Fliegl_Pritsche_FW:keyEvent(unicode, sym, modifier, isDown)
	if bitAND(modifier, Input.MOD_CTRL) > 0 and InputBinding.isPressed(InputBinding.OPENDOORALL) then
		self.door.closeall = true;
		self.door.docheck = true;
	elseif bitAND(modifier, Input.MOD_CTRL) == 0 and InputBinding.isPressed(InputBinding.OPENDOORALL) then
		self.door.openall = true;
		self.door.docheck = true;
	end;
end;

function Fliegl_Pritsche_FW:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Fliegl_Pritsche_FW:delete()

	if self.hudInfoBaseOverlay ~= nil then
		self.hudInfoBaseOverlay:delete();
	end;
	
	if self.hudInfoBaseOverlayd ~= nil then
		self.hudInfoBaseOverlayd:delete();
	end;

	if self.CraneSound ~= nil then
        delete(self.CraneSound);
    end;

end;

function Fliegl_Pritsche_FW:draw()

	if self.attacherVehicle ~= nil then
		self.showHudInfoBase = self.attacherVehicle.showHudInfoBaseh;
	end;

	if self.showHudInfoBase then
	setTextColor(1, 1, 1, 1);
		    self.hudInfoBaseOverlayd:render();
			renderText(0.815, 0.64, 0.02, string.format("%s\n%s", g_i18n:getText("craneMenuR1"), g_i18n:getText("craneMenuR2")));
   			renderText(0.815, 0.48, 0.02, string.format("%s:\n%s", g_i18n:getText("OpenAllDoors"), InputBinding.getButtonKeyName(InputBinding.OPENDOORALL)));
			renderText(0.815, 0.42, 0.02, string.format("%s:\nCTRL + %s", g_i18n:getText("CloseAllDoors"), InputBinding.getButtonKeyName(InputBinding.OPENDOORALL)));
			if self.Done.doorfl then
			    setTextColor(0, 1, 0, 1);
			else
			    setTextColor(1, 1, 1, 1);
			end;
			renderText(0.815, 0.82, 0.02, string.format("%s", InputBinding.getButtonKeyName(InputBinding.OPENDOORFL)));
			if self.Done.doorbl then
			    setTextColor(0, 1, 0, 1);
			else
			    setTextColor(1, 1, 1, 1);
			end;
		    renderText(0.815, 0.79, 0.02, string.format("%s", InputBinding.getButtonKeyName(InputBinding.OPENDOORBL)));
			if self.Done.doorfr then
			    setTextColor(0, 1, 0, 1);
			else
			    setTextColor(1, 1, 1, 1);
			end;
		    renderText(0.935, 0.82, 0.02, string.format("%s", InputBinding.getButtonKeyName(InputBinding.OPENDOORFR)));
			if self.Done.doorbr then
			    setTextColor(0, 1, 0, 1);
			else
			    setTextColor(1, 1, 1, 1);
			end;
		    renderText(0.935, 0.79, 0.02, string.format("%s", InputBinding.getButtonKeyName(InputBinding.OPENDOORBR)));
			if self.Done.doorb then
			    setTextColor(0, 1, 0, 1);
			else
			    setTextColor(1, 1, 1, 1);
			end;
		    renderText(0.875, 0.76, 0.02, string.format("%s", InputBinding.getButtonKeyName(InputBinding.OPENDOORB)));
			setTextColor(1, 1, 1, 1);
			renderText(0.88, 0.72, 0.02, string.format("%s\n%s - %s", g_i18n:getText("ActivateCraneR1"), g_i18n:getText("ActivateCraneR2"), InputBinding.getButtonKeyName(InputBinding.ACTIVATECRANE)));

	end;

end;

function Fliegl_Pritsche_FW:update(dt)

	if self:getIsActiveForInput() then

				if InputBinding.hasEvent(InputBinding.OPENDOORFL) then
					self.Go.doorfl = not self.Go.doorfl;
					self.Done.doorfl = true;
				end;
				if InputBinding.hasEvent(InputBinding.OPENDOORBL) then
					self.Go.doorbl = not self.Go.doorbl;
					self.Done.doorbl = true;
				end;
					if InputBinding.hasEvent(InputBinding.OPENDOORFR) then
					self.Go.doorfr = not self.Go.doorfr;
					self.Done.doorfr = true;
				end;
				if InputBinding.hasEvent(InputBinding.OPENDOORBR) then
					self.Go.doorbr = not self.Go.doorbr;
					self.Done.doorbr = true;
				end;
				if InputBinding.hasEvent(InputBinding.OPENDOORB) then
					self.Go.doorb = not self.Go.doorb;
					self.Done.doorb = true;
				end;
	end;
	
	if InputBinding.hasEvent(InputBinding.TRANSPORT_POSITION) and self.attachedImplements[1] == nil and self.leftSupportArm.isdown then
			self.doTransportMove = true;
			self.mainArm.zeroHomeSearch = true;
			self.rootArm.zeroHomeSearch = true;
	end;
	
	if self.doTransportMove then
				self.door.closeall = true;
				self.door.docheck = true;
				self.doTransportMove = false;
 	end;

	if self.door.docheck then
		local x, y, z = getRotation(self.door.flnode);
    	    local x1, y1, z1 = getRotation(self.door.frnode);
        	local x2, y2, z2 = getRotation(self.door.blnode);
	        local x3, y3, z3 = getRotation(self.door.brnode);
    	    local x4, y4, z4 = getRotation(self.door.bnode);
        	if z == self.door.minRot[3] then
	            self.door.flup = true;
    	        self.door.fldown= false;
			elseif z < self.door.front.maxRot[3] + 0.01 then
		    	self.door.flup = false;
			    self.door.fldown = true;
			else
			    self.door.flup = false;
				self.door.fldown = false;
		end;

		if z1 == self.door.minRot[3] then
        	    self.door.frup = true;
            	self.door.frdown= false;
			elseif z1 > self.door.front.maxRot[1] - 0.01 then
			    self.door.frup = false;
			    self.door.frdown = true;
			else
		    	self.door.frup = false;
				self.door.frdown = false;
		end;

	    	if z2 == self.door.minRot[3] then
            	self.door.blup = true;
	            self.door.bldown= false;
    	    elseif z2 < self.door.front.maxRot[3] + 0.01 then
			    self.door.blup = false;
		    	self.door.bldown = true;
			else
			    self.door.blup = false;
				self.door.bldown = false;
		end;

		if z3 == self.door.minRot[3] then
        	    self.door.brup = true;
            	self.door.brdown= false;
	        elseif z3 > self.door.front.maxRot[1] - 0.01 then
			    self.door.brup = false;
			    self.door.brdown = true;
			else
			    self.door.brup = false;
				self.door.brdown = false;
		end;

		if x4 == self.door.minRot[1] then
    	        self.door.bup = true;
        	    self.door.bdown= false;
	        elseif x4 < self.door.back.maxRot[1] + 0.01 then
			    self.door.bup = false;
			    self.door.bdown = true;
			else
			    self.door.bup = false;
				self.door.bdown = false;
		end;
	end;
	
	if self.door.closeall then
		if self.door.fldown then
				self.Go.doorfl = not self.Go.doorfl;
				self.Done.doorfl = true;
		end;
		if self.door.frdown then
				self.Go.doorfr = not self.Go.doorfr;
				self.Done.doorfr = true;
		end;
		if self.door.bldown then
				self.Go.doorbl = not self.Go.doorbl;
				self.Done.doorbl = true;
		end;
		if self.door.brdown then
				self.Go.doorbr = not self.Go.doorbr;
				self.Done.doorbr = true;
		end;
		if self.door.bdown then
				self.Go.doorb = not self.Go.doorb;
				self.Done.doorb = true;
		end;
		self.door.closeall = false;
		self.door.docheck = false;
	end;
	
	if self.door.openall then
		if self.door.flup then
				self.Go.doorfl = not self.Go.doorfl;
				self.Done.doorfl = true;
		end;
		if self.door.frup then
			self.Go.doorfr = not self.Go.doorfr;
			self.Done.doorfr = true;
		end;
		if self.door.blup then
				self.Go.doorbl = not self.Go.doorbl;
				self.Done.doorbl = true;
		end;
		if self.door.brup then
				self.Go.doorbr = not self.Go.doorbr;
				self.Done.doorbr = true;
		end;
		if self.door.bup then
				self.Go.doorb = not self.Go.doorb;
				self.Done.doorb = true;
		end;
		self.door.openall = false;
		self.door.docheck = false;
	end;



	if self.Go.doorfl ~= nil and self.Done.doorfl ~= false then
		self:anim("doorfl",false);
	end;
	if self.Go.doorbl ~= nil and self.Done.doorbl ~= false then
		self:anim("doorbl",false);
	end;
	if self.Go.doorfr ~= nil and self.Done.doorfr ~= false then
		self:anim("doorfr",false);
	end;
	if self.Go.doorbr ~= nil and self.Done.doorbr ~= false then
		self:anim("doorbr",false);
	end;
	if self.Go.doorb ~= nil and self.Done.doorb ~= false then
		self:anim("doorb",false);
	end;
end;

function Fliegl_Pritsche_FW:validateAttacherJoint(craneimplement, jointDesc, dt)
    return true;
end;

function Fliegl_Pritsche_FW:connectCollisions(varName)
	local Collision = self.collisionArm[varName];
	local constr = JointConstructor:new();
	constr:setActors(self.rootNode, Collision.collision);
	constr:setJointTransforms(Collision.armAttacher, Collision.collisionAttacher);
	for i=1, 3 do
		constr:setRotationLimit(i-1, 0, 0, 0);
		constr:setTranslationLimit(i-1, true, 0, 0);
	end;
	Collision.index = constr:finalize();
end;

function Fliegl_Pritsche_FW:anim(varName, loopCheck)

	if self.moveColli[varName] ~= nil then
		local Collision = self.collisionArm[varName];
		setJointFrame(Collision.index, 0, Collision.armAttacher);
	end;
	
	if self.Go[varName] == true and self.Done[varName] ~= false then
		local charId = getAnimCharacterSet(self.charId[varName]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackLoopState(charId, 0, loopCheck);
		setAnimTrackSpeedScale(charId, 0, 1);
		enableAnimTrack(charId, 0);
		if getAnimTrackTime(charId, 0) >= getAnimClipDuration(charId, clipIndex) and loopCheck == false then
			disableAnimTrack(charId, 0);	
			self.Done[varName] = false;	
			self.CheckDone[varName] = true;	
		end; 
	elseif self.Go[varName] == false and self.Done[varName] ~= false then
		local charId = getAnimCharacterSet(self.charId[varName]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
		if loopCheck == true then
			disableAnimTrack(charId, 0);
			self.Done[varName] = false;	
		end; 	
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackLoopState(charId, 0, loopCheck);
		setAnimTrackSpeedScale(charId, 0, -1);
		enableAnimTrack(charId, 0);
		if getAnimTrackTime(charId, 0) <= 0 then
			disableAnimTrack(charId, 0);
			self.Done[varName] = false;	
			self.CheckDone[varName] = false;
		end;
	end;
end; 	
