

Blitzer_TN = {};

function Blitzer_TN.prerequisitesPresent(specializations)
    return true; 
    --SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function Blitzer_TN:load(xmlFile)
    -- init variables
    self.fl_keys = {};
    self.fl_worklights = {};
    self.fl_numLights = {};
    self.fl_nameLights = {};
    self.fl_activeLights = {};
    self.fl_numDifferentWorkLights = 0;
    self.fl_Leuchtdauer = {};
    self.fl_Leuchtpause = {};
    self.fl_waitCounter = {};
    self.fl_Blinker = {};
    self.fl_StayOn = {};
    self.fl_collisiontrigger = {};
    self.fl_EmitLight = {};
    self.fl_LightSource = {};
    self.flActive = false;
    
    self.flHelp = false;
    self.flNeedsActivation = false;
    
    if Utils.getNoNil(getXMLInt(xmlFile, "vehicle.flasherlights_by_TN#needsActivation"), 0) == 1 then
        self.flNeedsActivation = true;
    end;
    
    -- get number of different worklights, each switched seperately
    self.fl_numDifferentWorkLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.flasherlights_by_TN#count"), 0);
    
    print("****************");
    print("www.ls-mod-gigant.com  ");
    print(string.format("  Anzahl unterschiedlicher Blitzer: %d", self.fl_numDifferentWorkLights ));

    -- loop through all worklight definitions
    for i=1, self.fl_numDifferentWorkLights do
      local curWorklight = string.format("vehicle.flasherlights_by_TN.flasher_" .. "%d", i);
    
      -- get the name of this worklights
      local curName = getXMLString(xmlFile, curWorklight .. "#name");
      self.fl_nameLights[i] = curName;
      
      -- get the lights in this worklights
      self.fl_numLights[curName] = Utils.getNoNil(getXMLInt(xmlFile, curWorklight .. "#count"), 0);
      
      -- set the key for this worklight
      --local inputKey = getXMLString(xmlFile, curWorklight .. "#key");
      --self.fl_keys[curName] = Input[inputKey];
           
      -- set the duration for this worklight
      self.fl_Leuchtdauer[curName] = Utils.getNoNil(getXMLInt(xmlFile, curWorklight .. "#dauer"), 0);
      
      -- set the pause for this worklight
      self.fl_Leuchtpause[curName] = Utils.getNoNil(getXMLInt(xmlFile, curWorklight .. "#pause"), 0);
      
      -- keep flashing when leaving the car?
      self.fl_StayOn[curName] = Utils.getNoNil(getXMLInt(xmlFile, curWorklight .. "#stay_on"), 0);

      local traffictrigger = getXMLString(xmlFile, curWorklight .. "#collisiontrigger");
      self.fl_collisiontrigger[curName] = Utils.indexToObject(self.components, traffictrigger);

      -- get the lightsource
      local LightSource = getXMLString(xmlFile, curWorklight .. "#lightsource");
      self.fl_LightSource[curName] = Utils.indexToObject(self.components, LightSource);
      
      -- should the light be active ?
      self.fl_EmitLight[curName] = Utils.getNoNil(getXMLInt(xmlFile, curWorklight .. "#emitlight"), 0);
      
      self.fl_worklights[curName] = {};
      -- fetch the lights to turn on and off
      for j=1, self.fl_numLights[curName] do
        local worklightnamei = string.format(curWorklight .. ".light_" .. "%d", j);
        print(string.format("    %s -> Lampe: '%s'",curName,worklightnamei));
        local light = getXMLString(xmlFile, worklightnamei .. "#index");
        self.fl_worklights[curName][j] = Utils.indexToObject(self.components, light);
        setVisibility(self.fl_worklights[curName][j], false);
      end;
      self.fl_activeLights[curName] = false;
      self.fl_Blinker[curName] = 0;
      self.fl_waitCounter[curName] = 0;
    end;
    
        -- HUD
    self.hudInfo = Utils.getFilename("Texturen/hud.png", self.baseDirectory.. "BlitzerTN/");
    self.hudInfoPoxX = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.flasherlights_by_TN.HUD#x"), 0.8200);
    self.hudInfoPoxY = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.flasherlights_by_TN.HUD#y"), 0.220);
    self.hudInfoWidth = 0.105;
    self.hudInfoHeight = 0.025;
    self.hudInfoOverlay = Overlay:new("hudInfoOverlay", self.hudInfo, self.hudInfoPoxX, self.hudInfoPoxY, self.hudInfoWidth, self.hudInfoHeight);

    -- Help-Box
    self.helpBox = Utils.getFilename("Texturen/helpBox.png", self.baseDirectory .. "BlitzerTN/");
    self.helpBoxPoxX = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.flasherlights_by_TN.HelpBox#x"), 0.200);
    self.helpBoxPoxY = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.flasherlights_by_TN.HelpBox#y"), 0.100);
    self.helpBoxWidth = 0.160;
    self.helpBoxHeight = 0.200;
    self.helpBoxOverlay = Overlay:new("helpBoxOverlay", self.helpBox, self.helpBoxPoxX, self.helpBoxPoxY, self.helpBoxWidth, self.helpBoxHeight);
    self.showHelp = false;
end;

function Blitzer_TN:delete()
end;

function Blitzer_TN:mouseEvent(posX, posY, isDown, isUp, button)
end;


function Blitzer_TN:keyEvent(unicode, sym, modifier, isDown)

end;

function Blitzer_TN:update(dt)
  --if self.isEntered then
  --end;
  
  for i=1, self.fl_numDifferentWorkLights do
      -- get name of light
      local curName = self.fl_nameLights[i];
      
      if self.fl_activeLights[curName] then
	-- Zhler fr die Steuerung (Timer)
	if self.fl_Blinker[curName] <= 3*self.fl_Leuchtdauer[curName] + self.fl_Leuchtpause[curName] then
	    self.fl_Blinker[curName] = self.fl_Blinker[curName] +1;
	elseif self.fl_Blinker[curName] > 3*self.fl_Leuchtdauer[curName] + self.fl_Leuchtpause[curName] then
	    self.fl_Blinker[curName] =0;
	end;
      
	-- Blitzer aus wenn
	if self.fl_Blinker[curName] >= 1*self.fl_Leuchtdauer[curName] and self.fl_Blinker[curName] <= 2*self.fl_Leuchtdauer[curName] or
	   self.fl_Blinker[curName] >= 3*self.fl_Leuchtdauer[curName] and self.fl_Blinker[curName] <= 4*self.fl_Leuchtdauer[curName] or
	   self.fl_Blinker[curName] >= 5*self.fl_Leuchtdauer[curName] then
	   for j=1, self.fl_numLights[curName] do
	   	if self.fl_worklights[curName][j] ~= nil then
	  		setVisibility(self.fl_worklights[curName][j], false);
        	end;
           end;
      	   if self.fl_LightSource[curName] ~= nil then
	        setVisibility(self.fl_LightSource[curName], false);
           end;
           
	end;
	
	-- Blitzer an wenn
	if self.fl_Blinker[curName] >= 0                              and self.fl_Blinker[curName] <= 1*self.fl_Leuchtdauer[curName] or
	   self.fl_Blinker[curName] >= 2*self.fl_Leuchtdauer[curName] and self.fl_Blinker[curName] <= 3*self.fl_Leuchtdauer[curName] or
	   self.fl_Blinker[curName] >= 4*self.fl_Leuchtdauer[curName] and self.fl_Blinker[curName] <= 5*self.fl_Leuchtdauer[curName] then
	   for k=1, self.fl_numLights[curName] do
	   	if self.fl_worklights[curName][k] ~= nil then
	  		setVisibility(self.fl_worklights[curName][k], true);
        	end;
           end;         	
      	   if self.fl_LightSource[curName] ~= nil then
               if self.fl_EmitLight[curName] == 1 then
	  	   setVisibility(self.fl_LightSource[curName], true);
               else
         	   setVisibility(self.fl_LightSource[curName], false);
               end;           
           end;
	end;
      else
	   for j=1, self.fl_numLights[curName] do
	   	if self.fl_worklights[curName][j] ~= nil then
	  		setVisibility(self.fl_worklights[curName][j], false);
        	end;
           end;
      	   if self.fl_LightSource[curName] ~= nil then
	        setVisibility(self.fl_LightSource[curName], false);
           end;
      end;
  end;
  
 
    -- Process Key Events (start)
--  if self.isEntered then
--    if InputBinding.hasEvent(InputBinding.FLTN_activate) then
--      self.flActive = not self.flActive;
--    end;
--    
--    if self.flActive or not self.flNeedsActivation then
--	if InputBinding.hasEvent(InputBinding.FLTN_help) then
--	  self.flHelp = not self.flHelp;
--	end;
--
--	for i=1, self.fl_numDifferentWorkLights do
--          local curName = self.fl_nameLights[i];
--   
--	  if InputBinding.hasEvent(InputBinding[ string.format("FLTN_%d", i) ] ) then
--		self.fl_activeLights[curName] = not self.fl_activeLights[curName];
--		self.fl_waitCounter[curName] = 0;
--		setVisibility(self.fl_collisiontrigger[curName], self.fl_activeLights[curName]);
--	  end;
--	end;
--    end;
--  end;
  -- Process Key Events (end)

end;


function Blitzer_TN:onLeave()
  for i=1, self.fl_numDifferentWorkLights do
    local curName = self.fl_nameLights[i];
    if self.fl_StayOn[curName] == 0 then
      for j=1, self.fl_numLights[curName] do
        setVisibility(self.fl_worklights[curName][j], false);
      end;
    end;
  end;   
end;


function Blitzer_TN:draw()

end;
function key_convert(key)
  if key ~= nil then 
    local keyname = "";
    -- kleine Buchstaben
    if key > 97 and key < 122 then
    	keyname = string.upper(string.char(key));
    -- grosse buchstaben
    elseif key > 65 and key < 90 then
    	keyname = string.char(key);
    -- NUM-Tasten	
    elseif key > 127 and key < 136 then
    	keyname = "NUM "..string.char(key-79);    	
    -- Numbers
    elseif key > 48 and key < 57 then
    	keyname = string.char(key);    	
    elseif key == 70 then
    	keyname = "Pos 1";
    elseif key == 71 then
    	keyname = "Ende";
    elseif key == 81 then
    	keyname = "Entf";
    elseif key == 69 then
    	keyname = "Einf";
    elseif key == 72 then
    	keyname = "Bild hoch";
    elseif key == 73 then
    	keyname = "Bild runter";
    elseif key == 58 then
    	keyname = "NUM ,";
    elseif key == 59 then
    	keyname = "NUM /";
    elseif key == 60 then
    	keyname = "NUM *";
    elseif key == 61 then
    	keyname = "NUM -";
    elseif key == 62 then
    	keyname = "NUM +";
    elseif key == 63 then
    	keyname = "NUM Enter";
    else 
    	keyname = "#"..key;
    end;
    return(keyname);
  end;
end;