

Arbeitslicht_TN = {};

function Arbeitslicht_TN.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function Arbeitslicht_TN:load(xmlFile)
    print("******************");
    print("Holz LKW mit Kran by www.ls-mod-gigant.com");

    -- init variables
    self.keys = {};
    self.worklights = {};
    self.numLights = {};
    self.nameLights = {};
    self.activeLights = {};
    self.numDifferentWorkLights = 0;
    self.WorklightsActive = false;
    self.WorklightsHelp = false;
    self.WorklightsNeedsActivation = false;
    
    if Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights_by_TN#needsActivation"), 0) == 1 then
        self.WorklightsNeedsActivation = true;
    end;

    -- get number of different worklights, each switched seperately
    self.numDifferentWorkLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights_by_TN#count"), 0);
    
    print("Holz LKW mit Kran by www.ls-mod-gigant.com  ");

    -- loop through all worklight definitions
    for i=1, self.numDifferentWorkLights do
      local curWorklight = string.format("vehicle.worklights_by_TN.worklight_" .. "%d", i);
    
      -- get the name of this worklights
      local curName = getXMLString(xmlFile, curWorklight .. "#name");
      self.nameLights[i] = curName;
      
      -- get the lights in this worklights
      self.numLights[curName] = Utils.getNoNil(getXMLInt(xmlFile, curWorklight .. "#count"), 0);
      
      -- set the key for this worklight
      --local inputKey = getXMLString(xmlFile, curWorklight .. "#key");
      --self.keys[curName] = Input[inputKey];
      
      self.worklights[curName] = {};
      -- fetch the lights to turn on and off
      for j=1, self.numLights[curName] do
        local worklightnamei = string.format(curWorklight .. ".light_" .. "%d", j);
        print(string.format("    %s -> Lampe: '%s'",curName,worklightnamei));
        local light = getXMLString(xmlFile, worklightnamei .. "#index");
        self.worklights[curName][j] = Utils.indexToObject(self.components, light);
        setVisibility(self.worklights[curName][j], false);
      end;
      self.activeLights[curName] = false;
    end;
    
    -- HUD
    self.hudInfo = Utils.getFilename("Texturen/hud.png", self.baseDirectory.. "ArbeitslichtTN/");
    self.hudInfoPoxX = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.worklights_by_TN.HUD#x"), 0.8200);
    self.hudInfoPoxY = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.worklights_by_TN.HUD#y"), 0.200);
    self.hudInfoWidth = 0.105;
    self.hudInfoHeight = 0.025;
    self.hudInfoOverlay = Overlay:new("hudInfoOverlay", self.hudInfo, self.hudInfoPoxX, self.hudInfoPoxY, self.hudInfoWidth, self.hudInfoHeight);

    -- Help-Box
    self.helpBox = Utils.getFilename("Texturen/helpBox.png", self.baseDirectory .. "ArbeitslichtTN/");
    self.helpBoxPoxX = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.worklights_by_TN.HelpBox#x"), 0.8200);
    self.helpBoxPoxY = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.worklights_by_TN.HelpBox#y"), 0.300);
    self.helpBoxWidth = 0.160;
    self.helpBoxHeight = 0.200;
    self.helpBoxOverlay = Overlay:new("helpBoxOverlay", self.helpBox, self.helpBoxPoxX, self.helpBoxPoxY, self.helpBoxWidth, self.helpBoxHeight);
    self.showHelp = false;
    
end;

function Arbeitslicht_TN:delete()
end;

function Arbeitslicht_TN:mouseEvent(posX, posY, isDown, isUp, button)
end;


function Arbeitslicht_TN:keyEvent(unicode, sym, modifier, isDown)

end;

function Arbeitslicht_TN:update(dt)
  if self.isEntered then
    for i=1, self.numDifferentWorkLights do
      local curName = self.nameLights[i];
      for j=1, self.numLights[curName] do
	  setVisibility(self.worklights[curName][j], self.activeLights[curName]);
      end;
    end;   
  end;
  
  if self:getIsActiveForInput() then    
    if self.WorklightsActive or not self.WorklightsNeedsActivation then
    --Start of Menu
	if self.WorklightsHelp then
		--self.helpBoxOverlay:render();
		local x1   = 0.300;
		local x2   = x1 + 0.135;
		local x3   = x1 + 0.100;
		local y    = 0.300;
		local step = 0.013;
		
		y = y - step;
		renderText(x1, y, 0.015, "--=== MAN Licht-Info ===--");

		y = y - step;

		y = y - step;
	        renderText(x2, y, 0.015, "Num 1");
		renderText(x1, y, 0.015, "Blinker links");
		if self.flashLeft then
			renderText(x3, y, 0.015, "("..g_i18n:getText("WLTN_on")..")");
		else
			renderText(x3, y, 0.015, "("..g_i18n:getText("WLTN_off")..")");
		end;
		
		y = y - step;
	        renderText(x2, y, 0.015, "Num 3");
		renderText(x1, y, 0.015, "Blinker rechts");
		if self.flashRight then
			renderText(x3, y, 0.015, "("..g_i18n:getText("WLTN_on")..")");
		else
			renderText(x3, y, 0.015, "("..g_i18n:getText("WLTN_off")..")");
		end;
		
		y = y - step;
	        renderText(x2, y, 0.015, "Num 2");
		renderText(x1, y, 0.015, "Warn-Blinker");
		if self.flashWarner then
			renderText(x3, y, 0.015, "("..g_i18n:getText("WLTN_on")..")");
		else
			renderText(x3, y, 0.015, "("..g_i18n:getText("WLTN_off")..")");
		end;
		
		y = y - step;
	        renderText(x2, y, 0.015, "R");
		renderText(x1, y, 0.015, "Blaulicht");
		if self.blaulichtAn then
			renderText(x3, y, 0.015, "("..g_i18n:getText("WLTN_on")..")");
		else
			renderText(x3, y, 0.015, "("..g_i18n:getText("WLTN_off")..")");
		end;
		
		y = y - step;
	        renderText(x2, y, 0.015, "4");
		renderText(x1, y, 0.015, "Blinklicht");
		if self.rundumleuchtenAn then
			renderText(x3, y, 0.015, "("..g_i18n:getText("WLTN_on")..")");
		else
			renderText(x3, y, 0.015, "("..g_i18n:getText("WLTN_off")..")");
		end;		
		
		for i=1, self.numDifferentWorkLights do
      			local curName = self.nameLights[i];
			y = y - step;
		        renderText(x2, y, 0.015, key_convert(InputBinding[ string.format("WLTN_%d", i) ]));
			renderText(x1, y, 0.015, string.format("%s %d", g_i18n:getText("WLTN_light"), i) );

			if self.activeLights[curName] then
				renderText(x3, y, 0.015, "("..g_i18n:getText("WLTN_on")..")");
			else
				renderText(x3, y, 0.015, "("..g_i18n:getText("WLTN_off")..")");
			end;
		end;
		
	end;
    end;
    --End of Menu    
  end;
  
    -- Process Key Events (start)
  if self.isEntered then
    if InputBinding.hasEvent(InputBinding.WLTN_activate) then
      self.WorklightsActive = not self.WorklightsActive;
    end;
    
    if self.WorklightsActive or not self.WorklightsNeedsActivation then
	if InputBinding.hasEvent(InputBinding.WLTN_help) then
	self.WorklightsHelp = not self.WorklightsHelp;
	end;

	for i=1, self.numDifferentWorkLights do
          local curName = self.nameLights[i];
   
	  if InputBinding.hasEvent(InputBinding[ string.format("WLTN_%d", i) ] ) then
	     self.activeLights[curName] = not self.activeLights[curName];
	  end;
	end;
    end;
  end;
  -- Process Key Events (end)
  

end;


function Arbeitslicht_TN:onLeave()
  for i=1, self.numDifferentWorkLights do
    local curName = self.nameLights[i];
    for j=1, self.numLights[curName] do
      setVisibility(self.worklights[curName][j], false);
    end;
  end;   
end;


function Arbeitslicht_TN:draw()

end;
