SetCrabSteeringEvent = {}
SetCrabSteeringEvent_mt = Class(SetCrabSteeringEvent, Event)

InitEventClass(SetCrabSteeringEvent, "SetCrabSteeringEvent")

SetCrabSteeringEvent.emptyNew = function (self)
	local self = Event:new(SetCrabSteeringEvent_mt)

	return self
end
SetCrabSteeringEvent.new = function (self, vehicle, state)
	local self = SetCrabSteeringEvent:emptyNew()
	self.vehicle = vehicle
	self.state = state

	return self
end
SetCrabSteeringEvent.readStream = function (self, streamId, connection)
	local id = streamReadInt32(streamId)
	self.vehicle = networkGetObject(id)
	self.state = streamReadUIntN(streamId, CrabSteering.STEERING_SEND_NUM_BITS)

	self.run(self, connection)

	return 
end
SetCrabSteeringEvent.writeStream = function (self, streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle))
	streamWriteUIntN(streamId, self.state, CrabSteering.STEERING_SEND_NUM_BITS)

	return 
end
SetCrabSteeringEvent.run = function (self, connection)
	self.vehicle:setCrabSteering(self.state, true)

	if not connection.getIsServer(connection) then
		g_server:broadcastEvent(SetCrabSteeringEvent:new(self.vehicle, self.state), nil, connection, self.object)
	end

	return 
end
SetCrabSteeringEvent.sendEvent = function (vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetCrabSteeringEvent:new(vehicle, state), nil, nil, self)
		else
			g_client:getServerConnection():sendEvent(SetCrabSteeringEvent:new(vehicle, state))
		end
	end

	return 
end

return 
