LiquidManureTankFix = {
	prerequisitesPresent = function (specializations)
		return true
	end
}
LiquidManureTankFix.load = function (self, xmlFile)
	self.getCanBeTurnedOn = Utils.overwrittenFunction(self.getCanBeTurnedOn, LiquidManureTankFix.getCanBeTurnedOn)
	self.defaultSprayLitersPerSecond = 0

	return 
end
LiquidManureTankFix.delete = function (self)
	return 
end
LiquidManureTankFix.mouseEvent = function (self, posX, posY, isDown, isUp, button)
	return 
end
LiquidManureTankFix.keyEvent = function (self, unicode, sym, modifier, isDown)
	return 
end
LiquidManureTankFix.update = function (self, dt)
	if self.getIsActive(self) then
		local attacherVehicle = self.getRootAttacherVehicle(self)
		local results = {}

		Vehicle.searchForVehicleTypeInAttachedImplements(attacherVehicle, "manureBarrelCultivator", results)

		local cultivator = nil

		for i, object in pairs(results) do
			if object ~= self then
				cultivator = object

				break
			end
		end

		local doAttach = false
		local doDetach = false

		if self.attachedTool == nil and cultivator ~= nil then
			doAttach = true
		elseif self.attachedTool ~= nil and cultivator == nil then
			doDetach = true
		end

		if doAttach then
			self.attachedTool = cultivator
		end

		if doDetach then
			self.attachedTool = nil
		end

		local turnOn = false

		if self.attachedTool ~= nil then
			local implement = self.attachedTool.attacherVehicle:getImplementByObject(self.attachedTool)
			local jointDesc = self.attachedTool.attacherVehicle.attacherJoints[implement.jointDescIndex]

			if jointDesc ~= nil and jointDesc.moveDown == true then
				turnOn = true
			end
		end

		if turnOn and self.getIsTurnedOn(self) == false then
			self.setIsTurnedOn(self, true)
		elseif not turnOn and self.getIsTurnedOn(self) == true then
			self.setIsTurnedOn(self, false)
		end
	end

	return 
end
LiquidManureTankFix.updateTick = function (self, dt)
	return 
end
LiquidManureTankFix.draw = function (self)
	return 
end
LiquidManureTankFix.getCanBeTurnedOn = function (self, superFunc)
	return false
end
Vehicle.searchForVehicleTypeInAttachedImplements = function (vehicle, vehicleTypeName, results)
	for _, implement in pairs(vehicle.attachedImplements) do
		if implement.object ~= nil and implement.object.specializations ~= nil then
			if implement.object.typeName == vehicleTypeName then
				table.insert(results, implement.object)
			end

			Vehicle.searchForVehicleTypeInAttachedImplements(implement.object, vehicleTypeName, results)
		end
	end

	return 
end
