SetBuildState = {};
SetBuildState_mt = Class(SetBuildState, Event);

InitEventClass(SetBuildState, "SetBuildState");

function SetBuildState:emptyNew()
    local self = Event:new(SetBuildState_mt);
    self.className = "SetBuildState";
    return self;
end;

function SetBuildState:new(object, buildState, buildVisibility)
    local self = SetBuildState:emptyNew()
    self.object = object;
	self.isBuildFinish = buildState;
	self.isVisibility = buildVisibility;
	return self;
end;

function SetBuildState:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isBuildFinish = streamReadBool(streamId);
	self.isVisibility = streamReadBool(streamId);
	self.object = networkGetObject(id);
    self:run(connection);
end;

function SetBuildState:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isBuildFinish);
	streamWriteBool(streamId, self.isVisibility);
end;

function SetBuildState:run(connection)
	self.object:setBuildState(self.isBuildFinish, self.isVisibility, false);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetBuildState:new(self.object, self.isBuildFinish, self.isVisibility), nil, connection, self.object);
    end;
end;

function SetBuildState.sendEvent(vehicle, buildState, buildVisibility, noEventSend)
	if buildState ~= vehicle.buildSet.isBuild then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetBuildState:new(vehicle, buildState, buildVisibility), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetBuildState:new(vehicle, buildState, buildVisibility));
			end;
		end;
	end;
end;

