FertilizerMod = {};

function FertilizerMod.prerequisitesPresent(specializations)
    return true;
end;

function FertilizerMod:load(xmlFile)

	self.setBuildState = SpecializationUtil.callSpecializationsFunction("setBuildState");
	self.updateMoving = SpecializationUtil.callSpecializationsFunction("updateMoving");
	self.cultivateArea = SpecializationUtil.callSpecializationsFunction("cultivateArea");
	self.groundContactReport = SpecializationUtil.callSpecializationsFunction("groundContactReport");
	
	self.fillTrailerRaycast = FertilizerMod.fillTrailerRaycast;
	
	self.buildSet = {};
	self.buildSet.offset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.build#offset"), 0.0);
	self.buildSet.isBuild = false;
	self.buildSet.isVisibility = false;
	self:setBuildState(self.buildSet.isBuild, self.buildSet.isVisibility, true);
	self.buildSet.areaStart = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.build.cultivatorArea#start"));
	self.buildSet.areaWidth = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.build.cultivatorArea#width"));
	self.buildSet.areaHeight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.build.cultivatorArea#height"));
	self.buildSet.isRigidBodyTypeSet = false;
	self.buildSet.time = 0;
	
	self.terrainContactNode = {};
	self.terrainContactNode.node = self.components[1].node;
	self.terrainContactNode.hasGroundContact = false;
	self.terrainContactNode.contactReportActive = false;
	
	self.siloTrigger = {};
	self.siloTrigger.triggerIds = {};
	local firstTriggerId = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.siloTrigger.raycastSet#fillRaycast"));
	table.insert(self.siloTrigger.triggerIds, firstTriggerId);
	addTrigger(firstTriggerId, "fillTrailerRaycast", self);
    for i=1, 3 do
        local child = getChildAt(firstTriggerId, i-1);
        table.insert(self.siloTrigger.triggerIds, child);
        addTrigger(child, "fillTrailerRaycast", self);
    end;
	self.siloTrigger.fillType = Fillable.FILLTYPE_FERTILIZER;
	self.siloTrigger.siloParticleSystem = {};
    Utils.loadParticleSystem(xmlFile, self.siloTrigger.siloParticleSystem, "vehicle.siloTrigger.particleSystem", self.components, false, "$data/vehicles/particleSystems/trailerDischargeParticleSystem.i3d", self.baseDirectory);
	self.siloTrigger.activeAttachable = nil;
	self.siloTrigger.isEnable = true;
	self.siloTrigger.fillDone = false;
	self.siloTrigger.literPerSecond = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.siloTrigger.fillSpeed#literPerSecond"), 200);
	self.siloTrigger.elevatorPart = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.siloTrigger.shader#elevatorPart"));
	self.siloTrigger.planePart = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.siloTrigger.shader#planePart"));
	setShaderParameter(self.siloTrigger.elevatorPart, "partScale", 90000000000, 1, 1, 1, false);
	setShaderParameter(self.siloTrigger.planePart, "partScale", 90000000000, 1, 1, 1, false);
	self.siloTrigger.randomSound = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.siloTrigger.randomSound#index"));
	setVisibility(self.siloTrigger.randomSound, false);
	self.siloTrigger.fillTrailerId = nil;
	
	self.tipTrigger = {};
	local triggerId = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tipTrigger.raycastSet#tipTriggerRaycast"));
	self.tipTrigger = TipTrigger:new(self.isServer, self.isClient);
	self.tipTrigger:load(triggerId);
	self.tipTrigger:register(true);
	
	self.noRenderOnLoad = false;
	self.allowBuild = true;
end;

function FertilizerMod:delete()
	Utils.deleteParticleSystem(self.siloTrigger.siloParticleSystem);
	for i=1, table.getn(self.siloTrigger.triggerIds) do
        removeTrigger(self.siloTrigger.triggerIds[i]);
    end;
	for k, tipTrigger in pairs(g_currentMission.tipTriggers) do
		if tipTrigger == g_currentMission.currentTipTrigger then
			g_currentMission.currentTipTrigger = nil;
		end;
	end;
	if self.isServer then
		self.tipTrigger:delete();
	end;
	FertilizerMod.removeContactReports(self);
end;

function FertilizerMod:readStream(streamId, connection)
	if connection:getIsServer() then
		local serverId = streamReadInt32(streamId);
		g_client:finishRegisterObject(self.tipTrigger, serverId);
		local buildState = streamReadBool(streamId);
		local isVisibility = streamReadBool(streamId);
		self:setBuildState(buildState, isVisibility, true);
	end;
end;

function FertilizerMod:writeStream(streamId, connection)
	if not connection:getIsServer() then
		streamWriteInt32(streamId, self.tipTrigger.id)
		streamWriteBool(streamId, self.buildSet.isBuild);
		streamWriteBool(streamId, self.buildSet.isVisibility);
	end;
end;

function FertilizerMod:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FertilizerMod:keyEvent(unicode, sym, modifier, isDown)
end;

function FertilizerMod:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicle then
		local isBuild = getXMLString(xmlFile, key.."#isBuild");
		if isBuild == "true" then
			self:setBuildState(true, true);
			self.noRenderOnLoad = true;
			self.terrainContactNode.hasGroundContact = true;
			self.terrainContactNode.contactReportActive = true;
		end;
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function FertilizerMod:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'isBuild="'..tostring(self.buildSet.isBuild)..'"';
	return attributes, nil;
end;

function FertilizerMod:update(dt)

	local otherStationAllow = false;
	for k, vehicle in pairs(g_currentMission.vehicles) do
		if vehicle ~= self then
			if vehicle.buildSet ~= nil and vehicle.allowBuild and not vehicle.buildSet.isRigidBodyTypeSet then
				otherStationAllow = true;
			end;
		elseif vehicle == self then
			if otherStationAllow then
				self.allowBuild = false;
				break;
			elseif not otherStationAllow then
				self.allowBuild = true;
				break;
			end;
		end;
	end;
	
	if self.isServer then
		if self.allowBuild then
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) and g_currentMission.player.isControlled and g_currentMission.player.isEntered then
				if not self.buildSet.isBuild then
					self:setBuildState(self.buildSet.isBuild, not self.buildSet.isVisibility);
				end;
			end;
			if self.buildSet.isVisibility then
				if not self.buildSet.isBuild then
					if not g_currentMission.player.isControlled and not g_currentMission.player.isEntered then
						self:setBuildState(self.buildSet.isBuild, false);
					end;
					g_currentMission:addExtraPrintText(g_i18n:getText("helpTextFertilizerMod"));
					g_currentMission:addHelpButtonText(g_i18n:getText("FertilizerMod_2"), InputBinding.IMPLEMENT_EXTRA);
					g_currentMission:addHelpButtonText(g_i18n:getText("FertilizerMod_3"), InputBinding.ACTIVATE_OBJECT);
					
					link(g_currentMission.player.graphicsRootNode, self.components[1].node)
					setTranslation(self.components[1].node, 0, 0, -30);
					setRotation(self.components[1].node, 0, 0, 0);
				
					local x, y, z = getWorldTranslation(self.components[1].node);
					local xRot, yRot, zRot = getWorldRotation(self.components[1].node);
					link(getRootNode(), self.components[1].node);
					setTranslation(self.components[1].node, x, y+self.buildSet.offset, z);
					setRotation(self.components[1].node, xRot, yRot, zRot);
					
					local buildFinish = false;
					if InputBinding.hasEvent(InputBinding.ACTIVATE_OBJECT) then
						buildFinish = true;
					end;
					self:setBuildState(buildFinish, self.buildSet.isVisibility);
				end;
			elseif g_currentMission.player.isControlled and g_currentMission.player.isEntered then
				g_currentMission:addHelpButtonText(g_i18n:getText("FertilizerMod_1"), InputBinding.IMPLEMENT_EXTRA);
			end;
		elseif not self.buildSet.isBuild then
			self:setBuildState(self.buildSet.isBuild, false);
		end;		
	end;
	
	for k, tipTrigger in pairs(g_currentMission.tipTriggers) do
		if tipTrigger == self.tipTrigger then
			if tipTrigger.isEnabled ~= self.buildSet.isRigidBodyTypeSet then
				tipTrigger.isEnabled  = self.buildSet.isRigidBodyTypeSet;
			end;
		end;
	end;
	if self.siloTrigger.isEnable ~= self.buildSet.isRigidBodyTypeSet then
		self.siloTrigger.isEnable = self.buildSet.isRigidBodyTypeSet;
	end;
	
	local isFilling = false;
	if self.siloTrigger.fillTrailerId ~= nil and not self.siloTrigger.fillDone and self.siloTrigger.fillTrailerId.allowFillFromAir then
		local selfFillType = self.siloTrigger.fillType;
		local trailer = self.siloTrigger.fillTrailerId;
		local fillLevel = trailer.fillLevel;
		isFilling = true;
		local deltaFillLevel = math.min(self.siloTrigger.literPerSecond*(dt/1000.0), 5000);
		trailer:setFillLevel(fillLevel+deltaFillLevel, selfFillType);
		local newFillLevel = trailer.fillLevel;
		if fillLevel == newFillLevel then
			self.siloTrigger.fillDone = true;
			isFilling = false;
		end;
		local difficultyMultiplier = math.max(3 * (3 - g_currentMission.missionStats.difficulty), 1);
		local fruitType = FruitUtil.fillTypeToFruitType[selfFillType];
		local money = FruitUtil.fruitIndexToDesc[fruitType].pricePerLiter * difficultyMultiplier * deltaFillLevel;
		if self.isServer then
			g_currentMission:addSharedMoney(-money);
		end;
	end;
	if isFilling then
		setShaderParameter(self.siloTrigger.elevatorPart, "partScale", 1, 1, 1, 1, false);
		setShaderParameter(self.siloTrigger.planePart, "partScale", -12, 1, 1, 1, false);
	else
		setShaderParameter(self.siloTrigger.elevatorPart, "partScale", 90000000000, 1, 1, 1, false);
		setShaderParameter(self.siloTrigger.planePart, "partScale", 90000000000, 1, 1, 1, false);
	end;
	Utils.setEmittingState(self.siloTrigger.siloParticleSystem, isFilling);
	setVisibility(self.siloTrigger.randomSound, isFilling);
	
	if not self.siloTrigger.isEnable then
		setShaderParameter(self.siloTrigger.elevatorPart, "partScale", 90000000000, 1, 1, 1, false);
		setShaderParameter(self.siloTrigger.planePart, "partScale", 90000000000, 1, 1, 1, false);
		Utils.setEmittingState(self.siloTrigger.siloParticleSystem, false);
		setVisibility(self.siloTrigger.randomSound, false);
	end;	
	
	local bodyType = getRigidBodyType(self.components[1].node);
	if bodyType == "Dynamic" then
		local worldX, worldY, worldZ = localDirectionToWorld(self.components[1].node, 0, -dt*1000, 0);
		addForce(self.components[1].node, worldX, worldY, worldZ, 0, 0, 0, true);
		if self.isServer and not self.noRenderOnLoad then
			g_currentMission:addWarning(g_i18n:getText("HallBuildWait"), 0.040, 0.035);
		end;
	end;
end;

function FertilizerMod:updateTick(dt)
	if self.buildSet.isBuild then
		if not self.buildSet.isRigidBodyTypeSet and self.terrainContactNode.hasGroundContact then
			if self.buildSet.time < 1000 then
				self.buildSet.time = self.buildSet.time + dt;
			else
				setRigidBodyType(self.components[1].node, "Static");
				setCollisionMask(self.components[1].node, 2102);
				self.buildSet.isRigidBodyTypeSet = true;
				FertilizerMod.removeContactReports(self);
			end;
		end;
	else
		self.buildSet.time = 0;
	end;
end;

function FertilizerMod:setBuildState(buildState, buildVisibility, noEventSend)
	SetBuildState.sendEvent(self, buildState, buildVisibility, noEventSend);
	self.buildSet.isBuild = buildState;
	self.buildSet.isVisibility = buildVisibility;
	setVisibility(self.components[1].node, self.buildSet.isVisibility);
	if self.buildSet.isBuild == true then
		self.buildSet.isRigidBodyTypeSet = false;
		FertilizerMod.addContactReports(self);
		setRigidBodyType(self.components[1].node, "Dynamic");
		setCollisionMask(self.components[1].node, 2102);
		self:cultivateArea();
	elseif self.buildSet.isBuild == false then
		setRigidBodyType(self.components[1].node ,"NoRigidBody");
	end;
end;

function FertilizerMod:cultivateArea()
	local x, y, z = getWorldTranslation(self.buildSet.areaStart);
	local x1, y1, z1 = getWorldTranslation(self.buildSet.areaWidth);
	local x2, y2, z2 = getWorldTranslation(self.buildSet.areaHeight);
	local detailId = g_currentMission.terrainDetailId;
	Utils.getXZWidthAndHeight(detailId, x, z, x1, z1, x2, z2);
	Utils.updateDestroyCommonArea(x, z, x1, z1, x2, z2);
end;

function FertilizerMod:addContactReports()
	if not self.terrainContactNode.contactReportActive then
		if self.terrainContactNode.node ~= nil then
			addContactReport(self.terrainContactNode.node, 0.0001, "groundContactReport", self);
			self.terrainContactNode.contactReportActive = true;
		end;
	end;
end;

function FertilizerMod:removeContactReports()
	if self.terrainContactNode.contactReportActive then
		if self.terrainContactNode.node ~= nil then
			removeContactReport(self.terrainContactNode.node);
			self.terrainContactNode.hasGroundContact = false;
			self.terrainContactNode.contactReportActive = false;
		end;
		
	end;
end;

function FertilizerMod:groundContactReport(objectId, otherObjectId, isStart, normalForce, tangentialForce)
	if otherObjectId ~= self then
		if self.terrainContactNode.node ~= nil then
			if not self.terrainContactNode.hasGroundContact and self.buildSet.time < 10 then
				self.terrainContactNode.hasGroundContact = isStart or normalForce > 0 or tangentialForce > 0;
			end;
		end;
	end;
end;

function FertilizerMod:fillTrailerRaycast(triggerId, otherId, onEnter, onLeave)
    if self.siloTrigger.isEnable then
		local selfFillType = self.siloTrigger.fillType;
        local trailer = g_currentMission.objectToTrailer[otherId];
		local attachable = nil;		
		local implements = g_currentMission.attachables;
		for k, implement in pairs(g_currentMission.attachables) do
			if implement.rootNode == otherId then
				attachable = implement;
			end;
		end;
        if trailer ~= nil and trailer:allowFillType(selfFillType) then
			if onEnter then
				self.siloTrigger.fillTrailerId = trailer;
				self.siloTrigger.fillDone = false;
			elseif onLeave then
				self.siloTrigger.fillTrailerId = nil;
				self.siloTrigger.fillDone = false;
			end;
        end;
		if attachable ~= nil and attachable:allowFillType(selfFillType) then
			if onEnter then
				self.siloTrigger.activeAttachable = attachable; 
			elseif onLeave then
				self.siloTrigger.activeAttachable = nil;
			end;
		end;
    end;
end;

function FertilizerMod:updateMoving()
end;

function FertilizerMod:draw()	
end;