--
-- Hollandfarm_Map_The_remake_V3
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

Hollandfarm_Map_The_remake_V3 = {}

local Hollandfarm_Map_The_remake_V3_mt = Class(Hollandfarm_Map_The_remake_V3, Mission00);

function Hollandfarm_Map_The_remake_V3:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = Hollandfarm_Map_The_remake_V3_mt;
    end;
    local self = Hollandfarm_Map_The_remake_V3:superClass():new(baseDirectory, mt);
    return self;
end;

function Hollandfarm_Map_The_remake_V3:delete()
    Hollandfarm_Map_The_remake_V3:superClass().delete(self);
end;

function Hollandfarm_Map_The_remake_V3:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("Hollandfarm_Map_The_remake_V3.i3d", self.baseDirectory));
        
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("$data/maps/missions/CattleMeadow.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
    
    Hollandfarm_Map_The_remake_V3:superClass().load(self);
end
function Hollandfarm_Map_The_remake_V3:loadFinished()
    Hollandfarm_Map_The_remake_V3:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function Hollandfarm_Map_The_remake_V3:mouseEvent(posX, posY, isDown, isUp, button)
    Hollandfarm_Map_The_remake_V3:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function Hollandfarm_Map_The_remake_V3:keyEvent(unicode, sym, modifier, isDown)
    Hollandfarm_Map_The_remake_V3:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function Hollandfarm_Map_The_remake_V3:update(dt)
    Hollandfarm_Map_The_remake_V3:superClass().update(self, dt);
end;

function Hollandfarm_Map_The_remake_V3:draw()
    Hollandfarm_Map_The_remake_V3:superClass().draw(self);
end;
