--
-- manure
--
-- @poc@lypse



manure = {};

function manure:onCreate(id)
	
	manure:load(id);	
end;

manureOnCreate = manure.onCreate;


function manure:load(id)
	
    addTrigger(id, "manureCallback", self);
    self.posStart = getChildAt(id, 0);
    self.posWidth = getChildAt(id, 1);
    self.posHeight = getChildAt(id, 2);  
    self.dectime = 70;
    self.delete = id;    
end;

function manure:loadMap(name)
	self.fill = Fillable.FILLTYPE_PAILLAGE;
	self.silo = g_currentMission:getSiloAmount(self.fill);
	if self.silo == 0 then
		if self.isServer then
			g_currentMission:setSiloAmount(self.fill, math.min(self.silo +2));
		end;
	end;
end;

function manure:deleteMap()
	removeTrigger(self.delete);
end;

function manure:delete()
end;

function manure:mouseEvent(posX, posY, isDown, isUp, button)
end;

function manure:keyEvent(unicode, sym, modifier, isDown)
end;

function manure:update(dt)
	g_currentMission.manureProductionScale = 0;
	local fillType = Fillable.FILLTYPE_PAILLAGE;
	local siloAmount = g_currentMission:getSiloAmount(fillType);
	local numcows = AnimalHusbandry.getNumberOfAnimals();
	local tscale = 0;
	if numcows > 0 and numcows <= 10 then
		tscale = 0.005;
	elseif numcows > 10 and numcows <= 20 then
		tscale = 0.008;
	elseif numcows > 20 then 
		tscale = 0.01;
	end; 

	if numcows > 0 then
		if siloAmount > 2 then
			if self.dectime == nil then
				self.dectime = 100
			end
            if self.dectime > 1 then      
                self.dectime = self.dectime - dt*tscale*g_currentMission.environment.timeScale;       
            end;
            if self.dectime <= 1 then                       
				if self.isServer then
					g_currentMission:setSiloAmount(fillType, math.max(siloAmount-1));
				end
                self.dectime = 100;
            end;
        end;
    
		if siloAmount > 1 and siloAmount < 2 then
			siloAmount = 1
		end;
		if siloAmount == 1 then
			if self.isServer then
				g_currentMission:setSiloAmount(fillType, 2);
			end
            local x,y,z = getWorldTranslation(self.posStart);
            local x1,y1,z1 = getWorldTranslation(self.posWidth);
            local x2,y2,z2 = getWorldTranslation(self.posHeight);              
			Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_PAILLAGE, x, z, x1, z1, x2, z2, 0);
            local old, total = Utils.getFruitWindrowArea(FruitUtil.FRUITTYPE_MANURE, x, z, x1, z1, x2, z2);
            local value = 1+math.floor(old / total + 0.7); 
            value = math.min(value, g_currentMission.maxWindrowValue);              
            Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_MANURE, x, z, x1, z1, x2, z2, value, true); 
		end;
	end;
end;


function manure:draw()
end;


addModEventListener(manure);

