--
-- Silage
--
-- @poc@lypse



Silage = {};

function Silage:onCreate(id)
	
	Silage:load(id);	
end;

SilageOnCreate = Silage.onCreate;


function Silage:load(id) 
    addTrigger(id, "SilageCallback", self);   
    self.posStart = getChildAt(id, 0);
    self.posWidth = getChildAt(id, 1);
    self.posHeight = getChildAt(id, 2);
    self.deleteListenerId = addDeleteListener(id, "delete", self);   
    self.dectime = 3600;  
    self.triggerId = id; 

end;

function Silage:loadMap(name)
	self.fill = Fillable.FILLTYPE_DRYGRASS;
	self.silo = g_currentMission:getSiloAmount(self.fill);
	if self.silo == 0 then
		if self.isServer then
			g_currentMission:setSiloAmount(self.fill, math.min(self.silo +2));
		end;
	end;
end;

function Silage:deleteMap()
	removeTrigger(self.triggerId);
	removeDeleteListener(self.triggerId, self.deleteListenerId);
end;

function Silage:delete()
end;

function Silage:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Silage:keyEvent(unicode, sym, modifier, isDown)
end;

function Silage:update(dt)
	local numcows = AnimalHusbandry.getNumberOfAnimals();
	local tscale = 0;
	if numcows > 0 and numcows <= 5 then
		tscale = 0.05;
	elseif numcows > 5 and numcows <= 10 then
		tscale = 0.1;
	elseif numcows > 10 then 
		tscale = 0.2;
	end;

	local fillType = Fillable.FILLTYPE_DRYGRASS;
	local siloAmount = g_currentMission:getSiloAmount(fillType);

	if numcows > 0 then
        if siloAmount > 2 then
			if self.dectime == nil then
				self.dectime = 3600
			end
            if self.dectime > 1 then      
				self.dectime = self.dectime - dt*tscale*g_currentMission.environment.timeScale;       
            end;
            if self.dectime < 1 then                       
				if self.isServer then
					g_currentMission:setSiloAmount(fillType, math.max(siloAmount-1));
				end
                self.dectime = 3600;
            end;
        end;
		if siloAmount > 1 and siloAmount < 2 then
			siloAmount = 1
		end;
		if siloAmount == 1 then
			if self.isServer then
				g_currentMission:setSiloAmount(fillType, 2);
			end
            local x,y,z = getWorldTranslation(self.posStart);
            local x1,y1,z1 = getWorldTranslation(self.posWidth);
            local x2,y2,z2 = getWorldTranslation(self.posHeight);              
			Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_MAIZE, x, z, x1, z1, x2, z2, 0);
		end;
	end;
end;


function Silage:draw()
end;


addModEventListener(Silage);

