--
-- SampleModMap
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

SampleModMap = {}

local SampleModMap_mt = Class(SampleModMap, Mission00);

function SampleModMap:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = SampleModMap_mt;
    end;
    local self = SampleModMap:superClass():new(baseDirectory, mt);
    return self;
end;

function SampleModMap:delete()
    SampleModMap:superClass().delete(self);
end;

function SampleModMap:load()
    self.environment = Environment:new(Utils.getFilename("sky/sky_day_night.i3d", self.baseDirectory), false, 8, false, false);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
    
    -- load paths for AI traffic vehicles
    self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));
    
    -- load paths for AI pedestrians
    self:loadMap(Utils.getFilename("map01/paths/pedestrianPaths.i3d", self.baseDirectory));
        
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("$data/maps/missions/CattleMeadow.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
    
	
	-- create Map Hotspots
    self.missionPDA:createMapHotspot("Farming Shop", "dataS2/missions/hud_pda_spot_shop.png", 779, 699, 0.055, 0.036, false, false, 0);
    self.missionPDA:createMapHotspot("Brewery", "dataS2/missions/hud_pda_spot_brewery.png", 958, 1752, 0.055, 0.036, false, false, 0);
    self.missionPDA:createMapHotspot("Mill", "dataS2/missions/hud_pda_spot_mill.png", 335, 762, 0.055, 0.036, false, false, 0);
    self.missionPDA:createMapHotspot("Dairy", "dataS2/missions/hud_pda_spot_dairy.png", 1401, 944, 0.055, 0.036, false, false, 0);
    self.missionPDA:createMapHotspot("Cow", "dataS2/missions/hud_pda_spot_cow.png", 1208, 236, 0.055, 0.036, false, false, 0);
	bgapic = Utils.getFilename("map01/bga.png", self.baseDirectory);
	self.missionPDA:createMapHotspot("BGA", bgapic, 425, 275, 0.055, 0.036, false, false, 0);

    --load Bottles

    self:loadCollectableBottles(Utils.getFilename("missions/collectableBottles.i3d", self.baseDirectory));
    
    --load Glass Containers

    self:loadGlassContainers(Utils.getFilename("missions/glassContainers.i3d", self.baseDirectory));
	
	--set Milk Production
	g_currentMission.milkProductionScale = 0.5;
	g_currentMission.milkPriceScale = 0.5;
	g_currentMission.manureProductionScale = 0.5;
    
    SampleModMap:superClass().load(self);
end
function SampleModMap:loadFinished()
    SampleModMap:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function SampleModMap:mouseEvent(posX, posY, isDown, isUp, button)
    SampleModMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function SampleModMap:keyEvent(unicode, sym, modifier, isDown)
    SampleModMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function SampleModMap:update(dt)
    SampleModMap:superClass().update(self, dt);
end;

function SampleModMap:draw()
    SampleModMap:superClass().draw(self);
end;
