actros = {}

function actros.prerequisitesPresent(specializations)
     Vehicle.registerJointType("shovel");
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function actros:load(xmlFile)

    local rotationPartNodebras1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.bras1#index"));
    if rotationPartNodebras1 ~= nil then
        self.bras1 = {};
        self.bras1.node = rotationPartNodebras1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.bras1#minRot"));
        self.bras1.minRot = {};
        self.bras1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.bras1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.bras1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.bras1#maxRot"));
        self.bras1.maxRot = {};
        self.bras1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.bras1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.bras1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.bras1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.bras1#rotTime"), 2)*1000;
     
     
	    self.bras1.pivotverin = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.bras1#pivotverin"));
    end;
    
    self.verin1 = {};
	self.verin1.node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin1#indexverin"));
	self.verin1.tige = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin1#indextige"));
	self.verin1.translationtige = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.verin1#translationtige"));
	local ax, ay, az = getWorldTranslation(self.verin1.tige);
    local bx, by, bz = getWorldTranslation(self.verin1.translationtige);
    self.verin1.tigeDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
    
  


end;

function actros:delete()

end;


function actros:mouseEvent(posX, posY, isDown, isUp, button)
end;

function actros:keyEvent(unicode, sym, modifier, isDown)  

	if sym == Input.KEY_KP_8 then
		self.rotationMinbras1 = isDown;
                self.playHidraulic2 = not self.playHidraulic2;	 
         end;
	if sym == Input.KEY_KP_5 then
		self.rotationMaxbras1 = isDown;
	 self.playHidraulic3 = not self.playHidraulic3;
        end;



  
end;


function actros:update(dt)

	self.bras1Moving = 0; 
	
           	local doRotate = self.rotationMaxbras1 or self.rotationMinbras1
    	if self.bras1 ~= nil and doRotate then
		local x, y, z = getRotation(self.bras1.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.bras1.maxRot, self.bras1.minRot, 3, self.bras1.rotTime, dt, not self.rotationMaxbras1);
		setRotation(self.bras1.node, unpack(newRot));
		
	end;
   	if self.verin1 ~= nil and self.bras1 ~= nil then
		local ax, ay, az = getWorldTranslation(self.verin1.node);
		local bx, by, bz = getWorldTranslation(self.bras1.pivotverin);
		local x, y, z = worldDirectionToLocal(getParent(self.verin1.node), bx-ax, by-ay, bz-az);
		setDirection(self.verin1.node, x*-1, y*-1, z*-1, 0, 1, 0);
		if self.verin1.tige ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.verin1.tige, 0, 0, (distance-self.verin1.tigeDistance)*-1);
		end;
	end;

end;
      


function actros:draw()

end;
