Palette = {};

function Palette.prerequisitesPresent(specializations)
	return true;
end;

function Palette:load(xmlFile)
	self.timer = {};
	self.timer.cnt = 0;
	self.timer.maxCnt = 5000;
	self.timer.run = false;
end;

function Palette:delete()
end;

function Palette:readStream(streamId, connection)
end;

function Palette:writeStream(streamId, connection)
end;

function Palette:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Palette:keyEvent(unicode, sym, modifier, isDown)
end;

function Palette:update(dt)
end;

function Palette:updateTick(dt)
	if self.timer.run then
		self.timer.cnt = self.timer.cnt + dt;
		if self.timer.cnt > self.timer.maxCnt then
			self.timer.cnt = 0;
			self.timer.run = false;
			for i,j in pairs(self.componentJoints) do
				setVisibility(self.components[j.componentIndices[2]].node, false);
				setRigidBodyType(self.components[j.componentIndices[2]].node, "None");
			end;
		end;
	end;
	if not self.timer.run and self.attacherVehicle ~= nil then 
		for i,j in pairs(self.componentJoints) do
			local jx, jy, jz = getWorldTranslation(j.jointNode);
			local jrx, jry, jrz = getWorldRotation(j.jointNode);

			setTranslation(self.components[j.componentIndices[2]].node, jx, jy, jz);
			setRotation(self.components[j.componentIndices[2]].node, jrx, jry, jrz);
		end;
	end;
end;

function Palette:onAttach(attacherVehicle)
	self.attacherVehicle = attacherVehicle;
	for i,j in pairs(self.componentJoints) do
		removeJoint(j.jointIndex);
		j.jointIndex = nil;
	end;
	self.timer.run = true;
end;

function Palette:onDetach()
	self.attacherVehicle = nil;
	self.timer.run = false;
	for i,j in pairs(self.componentJoints) do
		
		local jx, jy, jz = getWorldTranslation(j.jointNode);
		local jrx, jry, jrz = getWorldRotation(j.jointNode);

		setTranslation(self.components[j.componentIndices[2]].node, jx, jy, jz);
		setRotation(self.components[j.componentIndices[2]].node, jrx, jry, jrz);
		setRigidBodyType(self.components[j.componentIndices[2]].node, "Dynamic");
		setVisibility(self.components[j.componentIndices[2]].node, true);
		
		local constr = JointConstructor:new();					
		constr:setActors(self.components[1].node, self.components[j.componentIndices[2]].node);
		constr:setJointTransforms(j.jointNode,  self.components[j.componentIndices[2]].node);
		for i=1, 3 do		                    
			constr:setTranslationLimit(i-1, true, 0, 0);
			constr:setRotationLimit(i-1, 0, 0);
		end;		
		j.jointIndex = constr:finalize();		
			
	end;

end;

function Palette:draw()
end;