-- by modelleicher
-- www.schwabenmodding.bplaced.net

Heckcontainer = {};

function Heckcontainer.prerequisitesPresent(specializations)
	return true;
end;

function Heckcontainer:load(xmlFile)
	-- specific funktion of this lua:
	self.changeFlapState = Heckcontainer.changeFlapState; -- is called if the changing state InputBinding Event occurs

	-- load the index of the flap and the collision that set to no visible or no collision
	self.flapIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Heckcontainer#flapIndex"));
	self.flapCollisionIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Heckcontainer#flapCollisionIndex"));
	
	-- some variables
	self.isOn = true;
	self.renderTextState = 1; 
    self.capacityBackup = self.capacity;

	self:changeFlapState(self.isOn, true);
end;

function Heckcontainer:delete()
end;
function Heckcontainer:readStream(streamId, connection)
    self:changeFlapState(streamReadBool(streamId), true); 
end;
function Heckcontainer:writeStream(streamId, connection)
    streamWriteInt32(streamId, self.isOn);  
end;
function Heckcontainer:mouseEvent(posX, posY, isDown, isUp, button)
end;
function Heckcontainer:keyEvent(unicode, sym, modifier, isDown)
end;
function Heckcontainer:changeFlapState(state, noEventSend)
    changeFlapStateEvent.sendEvent(self, state, noEventSend);	
	if state ~= nil then
		if state == true then
			self.isOn = true;
			setVisibility(self.flapIndex, true);
			setRigidBodyType(self.flapCollisionIndex, "Kinematic")
			self.capacity = self.capacityBackup;
		elseif state == false then
			self.isOn = false;
			setVisibility(self.flapIndex, false);
			setRigidBodyType(self.flapCollisionIndex, "NoRigidBody")	
			self.capacity = 0.0;
		end;
	end;
end;
function Heckcontainer:update(dt)
	if self:getIsActiveForInput() then
		if self.fillLevel == 0 then -- only able to change the state if theres no fruit into it
			if InputBinding.hasEvent(InputBinding.changeFlapState) then
				self:changeFlapState(not self.isOn);
			end;
			self.renderTextState = 1;
		else
			self.renderTextState = 2;
		end;
	else
		self.renderTextState = 0;
	end;
end;
function Heckcontainer:updateTick(dt)
end;
function Heckcontainer:draw()
	if self.renderTextState == 1 then
		if self.isOn then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_off_flap"), self.typeDesc), InputBinding.changeFlapState);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_on_flap"), self.typeDesc), InputBinding.changeFlapState);		
		end;
	elseif self.renderTextState == 2 then
		g_currentMission:addExtraPrintText(tostring(g_i18n:getText("empty_before_change_flap")));
	end;
end;

changeFlapStateEvent = {};
changeFlapStateEvent_mt = Class(changeFlapStateEvent, Event);
InitEventClass(changeFlapStateEvent, "changeFlapStateEvent");
function changeFlapStateEvent:emptyNew() 
    local self = Event:new(changeFlapStateEvent_mt );
    self.className="changeFlapStateEvent";
    return self;
end;
function changeFlapStateEvent:new(vehicle, state) 
    self.vehicle = vehicle;
    self.isOn = state;
    return self;
end;

function changeFlapStateEvent:readStream(streamId, connection) 
    local id = streamReadInt32(streamId); 
    self.isOn = streamReadBool(streamId); 
    self.vehicle = networkGetObject(id);
    self:run(connection); 
end;

function changeFlapStateEvent:writeStream(streamId, connection)  
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
    streamWriteBool(streamId, self.isOn );  
end;

function changeFlapStateEvent:run(connection) 
    self.vehicle:changeFlapState(self.isOn, true);
	if not connection:getIsServer() then  
		g_server:broadcastEvent(changeFlapStateEvent:new(self.vehicle, self.isOn), nil, connection, self.object);
	end;
end;

function changeFlapStateEvent.sendEvent(vehicle, state, noEventSend)  
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(changeFlapStateEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(changeFlapStateEvent:new(vehicle, state));
		end;
	end;
end;

