--
-- HamelnerLand
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

HamelnerLand = {}

local HamelnerLand_mt = Class(HamelnerLand, Mission00);

function HamelnerLand:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = HamelnerLand_mt;
    end;
    local self = HamelnerLand:superClass():new(baseDirectory, mt);
    return self;
end;

function HamelnerLand:delete()
    HamelnerLand:superClass().delete(self);
end;

function HamelnerLand:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
    g_currentMission.tipTriggerRangeThreshold = 20;
  
    -- load paths for AI traffic vehicles
    self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));
        
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("$data/maps/missions/CattleMeadow.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
    
	raiffeisenpic = Utils.getFilename("pdasymbole/raiffeisen.png", self.baseDirectory);
	brauereipic = Utils.getFilename("pdasymbole/brauerei.png", self.baseDirectory);
	eifokpic = Utils.getFilename("pdasymbole/eifok.png", self.baseDirectory);
	milchpic = Utils.getFilename("pdasymbole/milch.png", self.baseDirectory);
	BGApic = Utils.getFilename("pdasymbole/BGA.png", self.baseDirectory);
	haendlerpic = Utils.getFilename("pdasymbole/haendler.png", self.baseDirectory);
	hofpic = Utils.getFilename("pdasymbole/hof.png", self.baseDirectory);

	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Raiffeisen", raiffeisenpic, 123, 1506, 0.030, 0.030, false, false, 0);

	-- create Map Hotspot
	self.missionPDA:createMapHotspot("Brauerei", brauereipic, 1250, 927, 0.030, 0.030, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Eifok", eifokpic, 711, 522, 0.030, 0.030, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Milch", milchpic, 1140, 862, 0.030, 0.030, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("BGA", BGApic, 976, 603, 0.030, 0.030, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Haendler", haendlerpic, 1109, 567, 0.030, 0.030, false, false, 0);

	-- create Map Hotspots
	self.missionPDA:createMapHotspot("Hof", hofpic, 1167, 314, 0.030, 0.030, false, false, 0);
    
    HamelnerLand:superClass().load(self);
end
function HamelnerLand:loadFinished()
    HamelnerLand:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function HamelnerLand:mouseEvent(posX, posY, isDown, isUp, button)
    HamelnerLand:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function HamelnerLand:keyEvent(unicode, sym, modifier, isDown)
    HamelnerLand:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function HamelnerLand:update(dt)
    HamelnerLand:superClass().update(self, dt);
end;

function HamelnerLand:draw()
    HamelnerLand:superClass().draw(self);
end;
