
print("mod loaded: FastSwitcher (SP) v1.1");

fastSwitcherClass = {};

function fastSwitcherClass:loadMap(name)
  if Steerable.load ~= nil then
    local orgSteerableLoad = Steerable.load
    Steerable.load = function(self,xmlFile)
        orgSteerableLoad(self,xmlFile)
        -- Try to find the name of the vehicle.
        if self.name == nil then self.name = getXMLString(xmlFile, "vehicle.name.".. g_languageShort); end
        if self.name == nil then self.name = getXMLString(xmlFile, "vehicle.name"); end
        if self.name == nil then self.name = getXMLString(xmlFile, "vehicle#type"); end
        if self.name == nil then
            self.name = "Steerable" -- Oh well, lets just call it this then!
        end
      end
  end
  if Attachable.load ~= nil then
    local orgAttachableLoad = Attachable.load
    Attachable.load = function(self,xmlFile)
        orgAttachableLoad(self,xmlFile)
        -- Try to find the name of the attachable
        if self.name == nil then self.name = getXMLString(xmlFile, "vehicle.name.".. g_languageShort); end
        if self.name == nil then self.name = getXMLString(xmlFile, "vehicle.name"); end
        if self.name == nil then self.name = getXMLString(xmlFile, "vehicle#type"); end
        if self.name == nil then
            self.name = "Attachable" -- Oh well, lets just call it this then!
        end
    end
  end
end;

function fastSwitcherClass:deleteMap()
end;

function fastSwitcherClass:mouseEvent(posX, posY, isDown, isUp, button)
end;

function fastSwitcherClass:keyEvent(unicode, sym, modifier, isDown)
  if isDown then
    local key
    if sym <= 57 and sym >= 48 then             -- Keys '0' to '9'
--print("FastSwitcher.keyEvent(). sym="..sym..", modifier="..modifier)
      if bitAND(modifier,4095) == 64 then       -- Left CTRL
-- 111111111111 = 4095
-- 000001000000 = 64
        key = tonumber(string.char(sym))
        if key == 0 then key = 10; end
      elseif bitAND(modifier,4095) == 128 then  -- Right CTRL
-- 111111111111 = 4095
-- 000010000000 = 128
        key = tonumber(string.char(sym))
        if key == 0 then key = 10; end
        key = key + 10
      elseif bitAND(modifier,4095) == 65 then  -- Left CTRL + Left Shift
-- 111111111111 = 4095
-- 000001000001 = 65
        key = tonumber(string.char(sym))
        if key == 0 then key = 10; end
        key = key + 20
      elseif bitAND(modifier,4095) == 130 then  -- Right CTRL + Right Shift
-- 111111111111 = 4095
-- 000010000010 = 130
        key = tonumber(string.char(sym))
        if key == 0 then key = 10; end
        key = key + 30
      end
    end

    if key ~= nil then
      local vehicles = table.getn(g_currentMission.steerables)
      if vehicles > 0 and key <= vehicles then
        Input.keyPressedState = {}  -- Make sure, that the next vehicle dont get anything activated.

        if not g_currentMission.steerables[key].isEntered then
--        g_currentMission:toggleVehicle( <index_offset> )  -- Somehow I think this could be used, to make it work in multiplayer. But I have no way of testing it.

          if not g_currentMission.controlPlayer then
            g_currentMission:onLeaveVehicle()
          end
          g_currentMission:onEnterVehicle(g_currentMission.steerables[key])



--        if g_currentMission.controlPlayer then
--          --print("FastSwitcher.keyEvent(). g_currentMission.controlPlayer")
--          Input.keyPressedState = {}
--          g_currentMission:onEnterVehicle(g_currentMission.steerables[key])
--        else
--          local current
--          for i=1,table.getn(g_currentMission.steerables) do
--            if g_currentMission.currentVehicle == g_currentMission.steerables[i] then
--              current = i
--              break
--            end
--          end
--          --print("FastSwitcher.keyEvent(). currentVehicle="..Utils.getNoNil(g_currentMission.currentVehicle, "nil")..",key="..key)
--          if current ~= nil and key ~= current then
--            local vehicle = key - current
--            --print("FastSwitcher.keyEvent(). vehicle="..vehicle)
--            Input.keyPressedState = {}
--            g_currentMission:toggleVehicle(vehicle)
--          else
--            Input.keyPressedState = {}
--            g_currentMission:onLeaveVehicle()
--            g_currentMission:onEnterVehicle(g_currentMission.steerables[key])
--          end
--        end
        end
      end
    end
  end
end

function fastSwitcherClass:update(dt)

-- Debug code.
--  for i=1,350 do
--    if Input.keyPressedState[i] then
--        print("Input.keyPressedState[".. i .."]")
--    end
--  end
-- Debug end.

  local form
  if Input.keyPressedState[306] then        -- left CTRL
    form = 1
    if Input.keyPressedState[304] then      -- left SHIFT
      form = 21
    end
  elseif Input.keyPressedState[305] then    -- right CTRL
    form = 11
    if Input.keyPressedState[303] then      -- right SHIFT
      form = 31
    end
  end

  if form then
    local posX = 0.01
    local posY = 0.7
    local fontSize = 0.025
    local lineDist = fontSize + 0.010
    
	setTextBold(true);
	setTextColor(1,1,1,1); -- r,g,b (white)
	
    renderText(posX, posY-(-1)*lineDist, fontSize, "== ".. g_i18n:getText("vehicles") .." "..form.." - "..(form+9).." ==")
    
    for line=0,9 do
      local veh = g_currentMission.steerables[line+form]
      if veh ~= nil then
        local pfx,imp1,imp2,hire = "","","",""
        
        --if veh == g_currentMission.currentVehicle then cur = " "; end
        
        if veh.isEntered then
            -- Prefix with playername
            pfx = Utils.getNoNil(veh.controllerName, "Unknown") ..": ";
        	setTextColor(0.7, 0.7, 0.7, 1); -- r,g,b (lightgray)
        else
            -- Prefix with vehicle number
            pfx = "".. line+form ..": "
        	setTextColor(1,1,1,1); -- r,g,b (white)
        end

        if (veh.attachedImplements[1] ~= nil and veh.attachedImplements[1].object ~= nil) then
          imp1 = " ".. g_i18n:getText("with") .." [".. Utils.getNoNil(veh.attachedImplements[1].object.name, "(implement1)") .."]"
        end
        if (veh.attachedImplements[2] ~= nil and veh.attachedImplements[2].object ~= nil) then
          imp2 =                              " & [".. Utils.getNoNil(veh.attachedImplements[2].object.name, "(implement2)") .."]"
        end

        if veh.isHired then hire = " ".. g_i18n:getText("hired"); end

        renderText(posX, posY-(line*lineDist), fontSize, pfx .. veh.name .. imp1 .. imp2 .. hire)
      end
    end
  end
end;

function fastSwitcherClass:draw()
end;


addModEventListener(fastSwitcherClass);
