--
-- albuttDgrab
--
-- henly20 Ls-uk-info 31-8-2010

albuttDgrab = {};



function albuttDgrab.prerequisitesPresent(specializations)
    return true;
end;

function albuttDgrab:load(xmlFile)

	self.setRotationGrab = SpecializationUtil.callSpecializationsFunction("setRotationGrab");


	local rotationGrabNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationGrab#index"));
		if rotationGrabNode ~= nil then
        self.rotationGrab = {};
        self.rotationGrab.node = rotationGrabNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationGrab#minRot"));
        self.rotationGrab.minRot = {};
        self.rotationGrab.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationGrab.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationGrab.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationGrab#maxRot"));
        self.rotationGrab.maxRot = {};
        self.rotationGrab.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationGrab.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationGrab.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationGrab.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationGrab#rotTime"), 2)*1000;
        self.rotationGrab.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationGrab#touchRotLimit"), 10));
    end;
	
	self.rotationGrabMax = false;	

	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local xUp, yUp, zUp = Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, hydraulicName .. "#upVectors"),"0 1 0"));
		self.hydraulics[i].upVectors = {xUp, yUp, zUp};
		
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		if self.hydraulics[i].translationPunch ~= nil then
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
	end;
	self.setHydraulicTime = 30;
	
end;

function albuttDgrab:readStream(streamId, connection)
     self.rotateGrab = streamReadBool(streamId);
      if self.rotationGrab ~= nil then
          local x = streamReadFloat32(streamId);
          local y = streamReadFloat32(streamId);
          local z = streamReadFloat32(streamId);
          setRotation(self.rotationGrab.node, x, y, z);
      end;

end;

function albuttDgrab:writeStream(streamId, connection)
	streamWriteBool(streamId, self.rotateGrab);
		if self.rotationGrab ~= nil then
          local x, y, z = getRotation(self.rotationGrab.node);
          streamWriteFloat32(streamId, x);
          streamWriteFloat32(streamId, y);
          streamWriteFloat32(streamId, z);
      end;
end;

function albuttDgrab:delete()

end;

function albuttDgrab:mouseEvent(posX, posY, isDown, isUp, button)
end;

function albuttDgrab:keyEvent(unicode, sym, modifier, isDown)

end;

function albuttDgrab:update(dt)

      if self:getIsActiveForInput() then
          if InputBinding.hasEvent(InputBinding.ROTATEGRAB) then
				self:setRotationGrab(not self.rotationGrabMax);
          end;
     end;

end;

function albuttDgrab:updateTick(dt)
	if self:getIsActive() and self.isClient then
	if self.rotationGrab ~= nil then
        local x, y, z = getRotation(self.rotationGrab.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationGrab.maxRot, self.rotationGrab.minRot, 3, self.rotationGrab.rotTime, dt, not self.rotationGrabMax);
        setRotation(self.rotationGrab.node, unpack(newRot));
    end;
	
	if self:getIsActive() then			
		self.setHydraulicTime = 30;	
	end;

	if self.setHydraulicTime > 0 then
		for k,v in pairs(self.hydraulics) do 
			self:setHydraulicDirection(k);
		end;
		self.setHydraulicTime = self.setHydraulicTime - 1;
	end;	
	end;
end;

function albuttDgrab:draw()

		if self.rotationGrabMax  then
		g_currentMission:addExtraPrintText("Key X : Felcsuk");	
	else
		g_currentMission:addExtraPrintText("Key X : Lenyit");	
	end;

end;

function albuttDgrab:setHydraulicDirection(index)
	local hydraulic = self.hydraulics[index];

	if hydraulic.fixPoint ~= nil then
		local ax, ay, az = getWorldTranslation(hydraulic.node);
		local bx, by, bz = getWorldTranslation(hydraulic.fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(hydraulic.node), bx-ax, by-ay, bz-az);
		local xUp, yUp, zUp = unpack(hydraulic.upVectors);
		setDirection(hydraulic.node, x, y, z, xUp, yUp, zUp);
		if hydraulic.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(hydraulic.punch, 0, 0, distance-hydraulic.punchDistance);
		end;
	end;
end;

function albuttDgrab:setRotationGrab(rotationGrabMax, noEventSend)
     if noEventSend == nil or noEventSend == false then
          if g_server ~= nil then
              g_server:broadcastEvent(SetRotationEventGrab:new(self, rotationGrabMax), nil, nil, self);
          else
              g_client:getServerConnection():sendEvent(SetRotationEventGrab:new(self, rotationGrabMax));
          end;
      end;
      self.rotationGrabMax = rotationGrabMax;
end;

SetRotationEventGrab = {};
SetRotationEventGrab_mt = Class(SetRotationEventGrab, Event);
 
InitEventClass(SetRotationEventGrab, "SetRotationEventGrab");

function SetRotationEventGrab:emptyNew()
      local self = Event:new(SetRotationEventGrab_mt);
      self.className="SetRotationEventGrab";
      return self;
end;
 
function SetRotationEventGrab:new(object, rotationGrabMax)
     local self = SetRotationEventGrab:emptyNew()
     self.object = object;
     self.rotationGrabMax = rotationGrabMax;
      return self;
end;

function SetRotationEventGrab:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
     self.rotationGrabMax = streamReadBool(streamId);
     self.object = networkGetObject(id);
      self:run(connection);
end;
 
function SetRotationEventGrab:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.rotationGrabMax);
end;

function SetRotationEventGrab:run(connection)
     self.object:setRotationGrab(self.rotationGrabMax, true);
     if not connection:getIsServer() then
          g_server:broadcastEvent(SetRotationEventGrab:new(self.object, self.rotationGrabMax), nil, connection, self.object);
     end;
end;