--
-- baleAttacherBTM
-- Class Balle-AttachAble Tippers
--
-- @author  Geri-G
-- @date  13/07/10
--
-- Copyright (C) Geri-G

baleAttacherBTM = {};

function baleAttacherBTM.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function baleAttacherBTM:load(xmlFile)

	self.setIsBaleAttached = SpecializationUtil.callSpecializationsFunction("setIsBaleAttached");
	self.searchBales = baleAttacherBTM.searchBales;
	self.attachobjects = baleAttacherBTM.attachobjects;
	self.detachobjects = baleAttacherBTM.detachobjects;
	self.OrientJoint = baleAttacherBTM.OrientJoint;
	self.setWorkState = baleAttacherBTM.setWorkState;
	self.isBaleInRange = baleAttacherBTM.isBaleInRange;
	self.place = {};
	self.place.node1 = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Baletrailer#castPoint1"));		
	self.place.node2 = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.Baletrailer#castPoint2"));
	self.place.attacherNode = Utils.indexToObject(self.components, Utils.getNoNil(getXMLString(xmlFile,"vehicle.Baletrailer#attacherNode"),"0>"));
	self.place.highOffset = Utils.getNoNil(getXMLFloat(xmlFile,"vehicle.Baletrailer#highOffset"),4);	
	self.Attachedobjects = {};
	self.attacherMod = 0;
	self.attacherModOld = 0;
	self.allowAttachment = true;
	self.balesAttached = false;
end;
function baleAttacherBTM:readStream(streamId, connection)
      local baleAttach = streamReadBool(streamId);
      self:setIsBaleAttached(baleAttach, true);		
end;

function baleAttacherBTM:writeStream(streamId, connection)
      streamWriteBool(streamId, self.isBaleAttach);
end;
function baleAttacherBTM:update(dt)
      if self:getIsActiveForInput() then
              if InputBinding.hasEvent(InputBinding.ATTACHBALEBTM) then
                  self:setIsBaleAttached(not self.isBaleAttach);
              end;
      end;
end;

function baleAttacherBTM:updateTick(dt)
	if self:getIsActive() and self.isServer then
		if self.isBaleAttach then
			if self.balesAttached == false then
				self:setWorkState(false);
			end;
		else
			if self.balesAttached == true then
				self:setWorkState(true);
			end;
		end;
	end;
end;
function baleAttacherBTM:draw()

	if self:getIsActive() then
	if self.isBaleAttach then
		g_currentMission:addExtraPrintText("Magnet g: fest");	
	else
		g_currentMission:addExtraPrintText("Magnet g: lose");
	end;
	end;

end;
function baleAttacherBTM:isBaleInRange(node1,node2,Yoffset,Bale)
	local Xmax, Ymax, Zmax = getWorldTranslation(node1);
		  Xmax, Ymax, Zmax = worldToLocal(self.place.attacherNode,Xmax, Ymax, Zmax);
		  
	local Xmin, Ymin, Zmin = getWorldTranslation(node2);	
		  Xmin, Ymin, Zmin = worldToLocal(self.place.attacherNode,Xmin, Ymin, Zmin);
	
	local Xt, Yt, Zt = getWorldTranslation(Bale);
		  Xt, Yt, Zt = worldToLocal(self.place.attacherNode,Xt, Yt, Zt);
		
	if (Xt < math.max(Xmax,Xmin) and Xt > math.min(Xmax,Xmin)) and (Zt < math.max(Zmax,Zmin) and Zt > math.min(Zmax,Zmin)) and (Yt<= ((Ymax+Ymin)/2)+Yoffset and Yt>= (Ymax+Ymin)/2) then
		return true;
	else
		return false;
	end;
end;
function baleAttacherBTM:searchBales()
	for index,item in pairs(g_currentMission.itemsToSave) do
		if item.item:isa(Bale) then 

			if item.item.isAttached == nil then--and (getUserAttribute(item.item.nodeId, "isHaybale") == true or getUserAttribute(item.item.nodeId, "isStrawbale") == true or getUserAttribute(item.item.nodeId, "isRoundbale") == true) then

				local isInRange = self:isBaleInRange(self.place.node1,self.place.node2,self.place.highOffset,item.item.nodeId);			

				local is1stAttached = false;
				if isInRange then
					is1stAttached = self:attachobjects(item.item.nodeId,item.item);
				end;
				if is1stAttached then
					self.balesAttached = true;
				end;
			end;
		end;
	end;
	for k,v in pairs(g_currentMission.vehicles) do
		if v ~= self and v ~= self.attacherVehicle then
			local is1stAttached = false;
			for index,components in pairs(v.components) do		
				local isInRange = self:isBaleInRange(self.place.node1,self.place.node2,self.place.highOffset,components.node);	
				if isInRange then	
					is1stAttached = self:attachobjects(components.node);
				end;
			end;
			if is1stAttached then
				self.balesAttached = true;
			end;
		end;
	end;
end;

function baleAttacherBTM:setIsBaleAttached(baleAttach, noEventSend)
      SetBaleAttachEvent.sendEvent(self, baleAttach, noEventSend)
      self.isBaleAttach = baleAttach;
end;

function baleAttacherBTM:setWorkState(baleAttach,noEventSend)
	--setWorkState.sendEvent(self, baleAttach, noEventSend);
	if baleAttach then
		self:detachobjects();	
	else
		self:searchBales();
	end;
end;
function baleAttacherBTM:OrientJoint(Source, Target)	
	local xw, yw, zw = getWorldTranslation(Source);		
	local x,y,z = worldToLocal(getParent(Target), xw, yw, zw);	
	setTranslation(Target, x,y,z);			
	--JointRotation Anpassung an das Objekt
	local zX, zY, zZ = localDirectionToWorld(Source, 0,0,1);
	local zX, zY, zZ = worldDirectionToLocal(getParent(Target), zX, zY, zZ);
	local yX, yY, yZ = localDirectionToWorld(Source, 0,1,0);
	local yX, yY, yZ = worldDirectionToLocal(getParent(Target), yX, yY, yZ);
	setDirection(Target, zX, zY, zZ, yX, yY, yZ);
	return false;
end;

function baleAttacherBTM:attachobjects(object,baleT)
	local attachedobject = {};
	attachedobject.object = object;
	if self.isServer then
		attachedobject.AT = createTransformGroup("AT");
		link(self.place.attacherNode,attachedobject.AT);
		
		attachedobject.objectMass = getMass(object);
		setMass(object,attachedobject.objectMass*0.01);
		
		self:OrientJoint(object,attachedobject.AT);

		local constr = JointConstructor:new();					
		constr:setActors(self.place.attacherNode, object);
		constr:setJointTransforms(attachedobject.AT,  object);
		for i=1, 3 do
			constr:setTranslationLimit(i-1, true, 0, 0);
			constr:setRotationLimit(i-1,0,0);
		end;
		attachedobject.JointIndex = constr:finalize();
		
		if baleT ~= nil then
			attachedobject.baleT = baleT;
			baleT.isAttached = true;
		end;
	end;

	table.insert(self.Attachedobjects, attachedobject);
	return true;
end;

function baleAttacherBTM:detachobjects()
	if self.isServer then
		for k,v in pairs(self.Attachedobjects) do
			removeJoint(v.JointIndex);
			delete(v.AT);
			v.JointIndex = nil;
			setMass(v.object,v.objectMass);
			if v.baleT ~= nil then
				v.baleT.isAttached = nil;
			end;
		end;
	end;
	
	self.Attachedobjects = nil;
	self.Attachedobjects = {};
	self.balesAttached = false;
end;



function baleAttacherBTM:onAttach(attacherVehicle)

end;
function baleAttacherBTM:onDetach()

end;
function baleAttacherBTM:onActivate()

end;
function baleAttacherBTM:onDeactivate()

end;
function baleAttacherBTM:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then

	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function baleAttacherBTM:getSaveAttributesAndNodes(nodeIdent)
   -- local attributes = ' side="'..tostring(self.currentSide)..'"';
    local attributes = nil;
    local node = nil;
    return attributes, node;
end;
function baleAttacherBTM:delete()

end;

function baleAttacherBTM:mouseEvent(posX, posY, isDown, isUp, button)
end;

function baleAttacherBTM:keyEvent(unicode, sym, modifier, isDown)
end;

SetBaleAttachEvent = {};
SetBaleAttachEvent_mt = Class(SetBaleAttachEvent, Event);
  
InitEventClass(SetBaleAttachEvent, "SetBaleAttachEvent");
  
function SetBaleAttachEvent:emptyNew()
     local self = Event:new(SetBaleAttachEvent_mt);
      self.className="SetBaleAttachEvent";
      return self;
end;
  
function SetBaleAttachEvent:new(object, baleAttach)
      local self = SetBaleAttachEvent:emptyNew()
      self.object = object;
      self.baleAttach = baleAttach;
      return self;
end;
  
function SetBaleAttachEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.baleAttach = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
  
function SetBaleAttachEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.baleAttach);
end;
  
function SetBaleAttachEvent:run(connection)
      if not connection:getIsServer() then
         g_server:broadcastEvent(self, false, connection, self.object);
      end;
      self.object:setIsBaleAttached(self.baleAttach, true);
end;
  
function SetBaleAttachEvent.sendEvent(vehicle, baleAttach, noEventSend)
      if baleAttach ~= vehicle.isBaleAttach then
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(SetBaleAttachEvent:new(vehicle, baleAttach), nil, nil, vehicle);
              else
                  g_client:getServerConnection():sendEvent(SetBaleAttachEvent:new(vehicle, baleAttach));
              end;
          end;
      end;
end;