--
-- Specialisation for hurricane
-- 
-- Author: thegamermodteam angellbad
-- 
-- nao modificar sem minha permissao
-- 
--
-- 

hurricane = {};

function hurricane.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function hurricane:load(xmlFile)
	self.agulhadevelocidade = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.agulhadevelocidade#index"));
	self.RPM = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.RPM#index"));
	self.fensterOpen = false;
end;

function hurricane:delete()
end;

function hurricane:readStream(streamId, connection)
end;

function hurricane:writeStream(streamId, connection)
end;

function hurricane:mouseEvent(posX, posY, isDown, isUp, button)
end;

function hurricane:keyEvent(unicode, sym, modifier, isDown)
end;

function hurricane:update(dt)
	if self.isMotorStarted then
        local kmh = math.min(65, math.max(0, self.lastSpeed*self.speedDisplayScale*3600));
        local rotateagulhadevelocidade = (((kmh / 25)*72) +10);
		local rotateRPM = (((kmh / 25)*34) +10);
		setRotation(self.agulhadevelocidade, 0, 0, Utils.degToRad( rotateagulhadevelocidade));
		setRotation(self.RPM, 0, 0, Utils.degToRad( rotateRPM));
    else
        setRotation(self.agulhadevelocidade, 0, 0, 0);
        setRotation(self.RPM, 0, 0, 0);
    end;	
end;

function hurricane:draw()
end;

function hurricane:validateAttacherJoint(implement, jointDesc, dt)
end;

function hurricane:onLeave()
end;

function hurricane:onEnter()
end;
