pickUpBB9090Event = {};
pickUpBB9090Event_mt = Class(pickUpBB9090Event, Event);

InitEventClass(pickUpBB9090Event, "pickUpBB9090Event");

function pickUpBB9090Event:emptyNew()
    local self = Event:new(pickUpBB9090Event_mt);
    self.className="pickUpBB9090Event";
    return self;
end;

function pickUpBB9090Event:new(vehicle, mode)
    local self = pickUpBB9090Event:emptyNew()
    self.vehicle = vehicle;
	self.mode = mode;
    return self;
end;

function pickUpBB9090Event:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.mode = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function pickUpBB9090Event:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.mode);
end;

function pickUpBB9090Event:run(connection)   
	self.vehicle:pickUpMode(self.mode, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(pickUpBB9090Event:new(self.vehicle, self.mode), nil, connection, self.vehicle);
    end;
end;

function pickUpBB9090Event.sendEvent(vehicle, mode, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(pickUpBB9090Event:new(vehicle, mode), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(pickUpBB9090Event:new(vehicle, mode));
		end;
	end;
end;