WorkBB9090Event = {};
WorkBB9090Event_mt = Class(WorkBB9090Event, Event);

InitEventClass(WorkBB9090Event, "WorkBB9090Event");

function WorkBB9090Event:emptyNew()
    local self = Event:new(WorkBB9090Event_mt);
    self.className="WorkBB9090Event";
    return self;
end;

function WorkBB9090Event:new(vehicle, mode)
    local self = WorkBB9090Event:emptyNew()
    self.vehicle = vehicle;
	self.mode = mode;
    return self;
end;

function WorkBB9090Event:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.mode = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function WorkBB9090Event:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.mode);
end;

function WorkBB9090Event:run(connection)   
	self.vehicle:WorkBB9090(self.mode, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(WorkBB9090Event:new(self.vehicle, self.mode), nil, connection, self.vehicle);
    end;
end;

function WorkBB9090Event.sendEvent(vehicle, mode, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(WorkBB9090Event:new(vehicle, mode), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(WorkBB9090Event:new(vehicle, mode));
		end;
	end;
end;