EmptyBB9090Event = {};
EmptyBB9090Event_mt = Class(EmptyBB9090Event, Event);

InitEventClass(EmptyBB9090Event, "EmptyBB9090Event");

function EmptyBB9090Event:emptyNew()
    local self = Event:new(EmptyBB9090Event_mt);
    self.className="EmptyBB9090Event";
    return self;
end;

function EmptyBB9090Event:new(vehicle, mode)
    local self = EmptyBB9090Event:emptyNew()
    self.vehicle = vehicle;
	self.mode = mode;
    return self;
end;

function EmptyBB9090Event:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.mode = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function EmptyBB9090Event:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.mode);
end;

function EmptyBB9090Event:run(connection)
	self.vehicle:EmptyBB9090(self.mode, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(EmptyBB9090Event:new(self.vehicle, self.mode), nil, connection, self.vehicle);
    end;
end;

function EmptyBB9090Event.sendEvent(vehicle, mode, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(EmptyBB9090Event:new(vehicle, mode), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(EmptyBB9090Event:new(vehicle, mode));
		end;
	end;
end;