BLightBB9090Event = {};
BLightBB9090Event_mt = Class(BLightBB9090Event, Event);

InitEventClass(BLightBB9090Event, "BLightBB9090Event");

function BLightBB9090Event:emptyNew()
    local self = Event:new(BLightBB9090Event_mt);
    self.className="BLightBB9090Event";
    return self;
end;

function BLightBB9090Event:new(vehicle, mode)
    local self = BLightBB9090Event:emptyNew()
    self.vehicle = vehicle;
	self.mode = mode;
    return self;
end;

function BLightBB9090Event:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.mode = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function BLightBB9090Event:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.mode);
end;

function BLightBB9090Event:run(connection)
	self.vehicle:BLightBB9090(self.mode, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(BLightBB9090Event:new(self.vehicle, self.mode), nil, connection, self.vehicle);
    end;
end;

function BLightBB9090Event.sendEvent(vehicle, mode, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(BLightBB9090Event:new(vehicle, mode), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(BLightBB9090Event:new(vehicle, mode));
		end;
	end;
end;