
-- Lucas
-- 
--
-- @author @poc@lypse
-- 	


Lucas = {};


function Lucas.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Lucas:load(xmlFile)
	
    local count = getXMLInt(xmlFile, "vehicle.translationParts#count");
    self.translationParts = {}
	local part = self.translationParts;
    for i=1, count do
		local varName = string.format("translationPart" .. "%d", i);
		part[varName] = {};
        local partname = string.format("vehicle.translationParts.translationPart" .. "%d", i);
	    part[varName].index = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partname .. "#index"));
	    local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partname .. "#minTrans"));
	    part[varName].minTrans = {};
	    part[varName].minTrans[1] = Utils.getNoNil(x, 0);
	    part[varName].minTrans[2] = Utils.getNoNil(y, 0);
	    part[varName].minTrans[3] = Utils.getNoNil(z, 0);
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partname .. "#maxTrans"));
		part[varName].maxTrans = {};
	    part[varName].maxTrans[1] = Utils.getNoNil(x, 0);
	    part[varName].maxTrans[2] = Utils.getNoNil(y, 0);
	    part[varName].maxTrans[3] = Utils.getNoNil(z, 0);
		part[varName].transTime = Utils.getNoNil(getXMLInt(xmlFile, partname .. "#transTime"), 2)*1000;	
		part[varName].touchTransLimit = Utils.getNoNil(getXMLInt(xmlFile, partname .. "#touchTransLimit"), 1)/1000;
    end;
	
	local count = getXMLInt(xmlFile, "vehicle.rotationParts#count");
    self.rotationParts = {}
	local part = self.rotationParts;
    for i=1, count do
		local varName = string.format("rotationPart" .. "%d", i);
		part[varName] = {};
        local partname = string.format("vehicle.rotationParts.rotationPart" .. "%d", i);
	    part[varName].index = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partname .. "#index"));
	    local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partname .. "#minRot"));
	    part[varName].minRot = {};
	    part[varName].minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
	    part[varName].minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
	    part[varName].minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partname .. "#maxRot"));
		part[varName].maxRot = {};
	    part[varName].maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
	    part[varName].maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
	    part[varName].maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
		part[varName].rotTime = Utils.getNoNil(getXMLInt(xmlFile, partname .. "#rotTime"), 2)*1000;	
		part[varName].touchRotLimit = Utils.getNoNil(getXMLInt(xmlFile, partname .. "#touchRotLimit"), 1)/1000;	
    end;
	
	local count = getXMLInt(xmlFile, "vehicle.drums#count");
    self.drums = {}
	local part = self.drums;
    for i=1, count do
		part[i] = {};
        local partname = string.format("vehicle.drums.drum" .. "%d", i);
	    part[i].index = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, partname .. "#index"));
		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, partname .. "#rot"));
		part[i].rot = {};
	    part[i].rot[1] = Utils.getNoNil(x, 0);
	    part[i].rot[2] = Utils.getNoNil(y, 0);
	    part[i].rot[3] = Utils.getNoNil(z, 0);
		for j=1, 3 do
			if part[i].rot[j] ~= 0 then
				part[i].rot[j] = 1/part[i].rot[j]
			end;
		end;
    end;
	
	
	
	
	self.destroySpeed = getXMLFloat(xmlFile, "vehicle.destroySpeed#value");

	
						
	self.keys = {};
	self.keysDesc = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
		self.keysDesc[inputName] = getXMLString(xmlFile, baseName.. "#keyDesc");
        i = i+1;
    end;
	
 self.baleTypes = {};
       local i = 0;
       while true do
           local key = string.format("vehicle.baleTypes.baleType(%d)", i);
           if not hasXMLProperty(xmlFile, key) then
             break;
          end;
           local filename = getXMLString(xmlFile, key.."#filename");
          if filename ~= nil then
               table.insert(self.baleTypes, filename);
          end;
          i = i + 1;
      end;
     
        
  
	self.toFront = false;
	self.isFront = false;
	
	self.doShutOpen = false;
	self.isShutOpen = false;
	self.doShutClose = false;
	self.isShutClose = true;
	self.isEnabled = false;
	
        self.balecar = false;
	self.bale = false;
	self.baleDummi = nil;
	self.hasBale = false;
	self.isRoundBale = false;	
	self.maxCapacity = 500;
	self.fillLevel = 0;
	

       
	self.baleGrabber = {};

	self.baleGrabber.grabNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.baleGrabber#grabNode"));

       	
   
end;





function Lucas:delete()
    
end;

function Lucas:mouseEvent(posX, posY, isDown, isUp, button)
  
end;

function Lucas:keyEvent(unicode, sym, modifier, isDown)
end;

function Lucas:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	
 
    local mode1 = Utils.getNoNil(getXMLBool(xmlFile, key.."#carre"),false);
    local mode2 = Utils.getNoNil(getXMLBool(xmlFile, key.."#round"),false);    
    if mode1 == true then
      self.hasBale = true;
      self.isFront = true;
      self.balecar = true;
    elseif mode2 == true then
      self.isRoundBale = true;
      self.hasBale = true;
      self.isFront = true;
    end;
   
   	
   
    return BaseMission.VEHICLE_LOAD_OK;
end;

function Lucas:getSaveAttributesAndNodes(nodeIdent)
	-- save function
	
        local isCarre='error';
	if self.balecar then
		isCarre='true';
	else
		isCarre='false';
	end;
         local isRound='error';
	if self.isRoundBale then
		isRound='true';
	else
		isRound='false';
	end;
     
       
    local attributes = 'carre="'..isCarre..'" round="'..isRound..'"';

   return attributes, nil;
end;

function Lucas:update(dt)
if self:getIsActiveForInput() then
  if InputBinding.hasEvent(InputBinding.LUCAS_DOOR) then
		if (self.isShutOpen and self.isFront) or (self.isShutOpen and not self.hasBale) then
			self.doShutClose = true;
		end;
		if self.isShutClose then
			self.doShutOpen = true;
		end;
    end;	                 

  if InputBinding.hasEvent(InputBinding.LUCAS_WORK) then
    self.isEnabled = not self.isEnabled;   
  end;
	
   
		
		if InputBinding.isPressed(InputBinding.LUCAS_GAUCHE) then
			local part = self.rotationParts.rotationPart2;
			local rot = {getRotation(part.index)};
			local newRot = Utils.getMovedLimitedValues(rot, part.maxRot, part.minRot, 3, part.rotTime, dt, false);
			setRotation(part.index, unpack(newRot));
        end;
		
		if InputBinding.isPressed(InputBinding.LUCAS_DROITE) then
			local part = self.rotationParts.rotationPart2;
			local rot = {getRotation(part.index)};
			local newRot = Utils.getMovedLimitedValues(rot, part.maxRot, part.minRot, 3, part.rotTime, dt, true);
			setRotation(part.index, unpack(newRot));
        end;
		
		if InputBinding.isPressed(InputBinding.LUCAS_BAS) then
			local part = self.rotationParts.rotationPart3;
			local rot = {getRotation(part.index)};
			local newRot = Utils.getMovedLimitedValues(rot, part.maxRot, part.minRot, 3, part.rotTime, dt, false);
			setRotation(part.index, unpack(newRot));
                        local part1 = self.translationParts.translationPart4;
			local trans = {getTranslation(part1.index)};
			local newTrans = Utils.getMovedLimitedValues(trans, part1.maxTrans, part1.minTrans, 3, part1.transTime, dt, false);
			setTranslation(part1.index, unpack(newTrans));
        end;
		
		if InputBinding.isPressed(InputBinding.LUCAS_HAUT) then
			local part = self.rotationParts.rotationPart3;
			local rot = {getRotation(part.index)};
			local newRot = Utils.getMovedLimitedValues(rot, part.maxRot, part.minRot, 3, part.rotTime, dt, true);
			setRotation(part.index, unpack(newRot));
                        local part1 = self.translationParts.translationPart4;
			local trans = {getTranslation(part1.index)};
			local newTrans = Utils.getMovedLimitedValues(trans, part1.maxTrans, part1.minTrans, 3, part1.transTime, dt, true);
			setTranslation(part1.index, unpack(newTrans));
        end;		
	
		
		if self.doShutOpen then
			self.isShutClose = false;
			local onPos = true;
			local part = self.rotationParts.rotationPart1;
			local rot = {getRotation(part.index)};
			local newRot = Utils.getMovedLimitedValues(rot, part.maxRot, part.minRot, 3, part.rotTime, dt, false);
			setRotation(part.index, unpack(newRot));
			local checkeps = part.maxRot;
			for i = 1, 3 do
				onPos = onPos and math.abs(newRot[i]-checkeps[i]) < part.touchRotLimit;
			end;
			if onPos then
				self.doShutOpen = false;
				self.isShutOpen = true;
			end;
		end;
		
		if self.doShutClose then
			self.isShutOpen = false;
			local onPos = true;
			local part = self.rotationParts.rotationPart1;
			local rot = {getRotation(part.index)};
			local newRot = Utils.getMovedLimitedValues(rot, part.maxRot, part.minRot, 3, part.rotTime, dt, true);
			setRotation(part.index, unpack(newRot));
			local checkeps = part.minRot;
			for i = 1, 3 do
				onPos = onPos and math.abs(newRot[i]-checkeps[i]) < part.touchRotLimit;
			end;
			if onPos then
				self.doShutClose = false;
				self.isShutClose = true;
			end;
		end;
		
		if self.toFront then
			local onPos = true;
			local part = self.baleDummy;
			local trans = {getTranslation(part.index)};
			local newTrans = Utils.getMovedLimitedValues(trans, part.maxTrans, part.minTrans, 3, part.transTime, dt, false);
			setTranslation(part.index, unpack(newTrans));
			local checkeps = part.maxTrans;
			for i = 1, 3 do
				onPos = onPos and math.abs(trans[i]-checkeps[i]) < part.touchTransLimit;
			end;
			if onPos then
				self.toFront = false;
				self.isFront = true;	
			end;
		end;
		
		if self.isShutOpen and not self.hasBale then
				local nearestBale = ObjectInRangeLucas(self);                            		
		end;
		
		if self.isEnabled then
			for i=1, table.getn(self.drums) do
				rotate(self.drums[i].index, dt*self.drums[i].rot[1], dt*self.drums[i].rot[2], dt*self.drums[i].rot[3]);
			end;
		end;
	       
		if self.isFront and self.fillLevel > 0 and self.hasBale then                               
                       if self.maxCapacity ~= 0 then
				local percent = self.fillLevel / 500;
				if self.isRoundBale then
                                        self.baleDummy = self.translationParts.translationPart2;
                                        setVisibility(self.baleDummy.index, true);
					local part = self.baleDummy;                                        
					local trans = {getTranslation(part.index)};
					local newTrans = trans;
					newTrans[1] = part.maxTrans[1] - (-1.05 + (1.05 * percent));
					newTrans[2] = part.maxTrans[2] - (1.2 + (-1.2 * percent));
					setTranslation(part.index, unpack(newTrans));
					setScale(part.index, percent, percent, 1);
				elseif self.balecar then
                                        self.baleDummy = self.translationParts.translationPart1;
                                        setVisibility(self.baleDummy.index, true);
					local part = self.baleDummy;
					local trans = {getTranslation(part.index)};
					local newTrans = trans;
					newTrans[1] = part.maxTrans[1] - (-1.40 + (1.40 * percent));
					setTranslation(part.index, unpack(newTrans));
					setScale(part.index, 1, 1, percent);
				end;
			end;
                       if self.isEnabled then
                        for k, cuttingArea in pairs(self.cuttingAreas) do
                           if self:getIsAreaActive(cuttingArea) then
				 local x,y,z = getWorldTranslation(cuttingArea.start);
                                 local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                                 local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
                             local old, total = Utils.getFruitWindrowArea(FruitUtil.FRUITTYPE_PAILLAGE, x, z, x1, z1, x2, z2);
                             local value = 1+math.floor(old / total + 0.7); 
                             value = math.min(value, g_currentMission.maxWindrowValue);
                             local area = Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_MANURE, x, z, x1, z1, x2, z2, 0)*g_currentMission.windrowCutLongRatio; 
                             local area2 = Utils.updateFruitWindrowArea(FruitUtil.FRUITTYPE_PAILLAGE, x, z, x1, z1, x2, z2, value, true);
                          end;
                         end;
			local delta = self.destroySpeed * dt;
                        if self.fillLevel < delta then
				delta = self.fillLevel;
				self.fillLevel = 0;  
                                Utils.setEmittingState(self.dischargeParticleSystems[self.currentFillType], false);
		        else	
			self.fillLevel = self.fillLevel - delta;                                              
                        g_currentMission:setSiloAmount(self.currentFillType, g_currentMission:getSiloAmount(self.currentFillType)+ delta);
                        Utils.setEmittingState(self.dischargeParticleSystems[self.currentFillType], true);               
			end;
			end;				
			
		end;
		
		if self.hasBale and self.fillLevel == 0 then
                        self.hasBale = false;
			self.isFront = false;
                        self.baleDummy = self.translationParts.translationPart1;   
			setVisibility(self.baleDummy.index, false);
			setTranslation(self.baleDummy.index, unpack(self.baleDummy.minTrans));
			setScale(self.baleDummy.index, 1, 1, 1);
                        self.currentFillType = FruitUtil.FRUITTYPE_UNKNOWN
                end; 
end;                
end;
	


function Lucas:draw()    
	
	if self.isShutOpen and not self.hasBale then
		g_currentMission:addExtraPrintText("Touche X: Porte ouverte"); 
	end;
		
	if self.isShutClose then
		g_currentMission:addExtraPrintText("Touche X: Porte ferme"); 
	end;

	
	
	
	
	g_currentMission:addExtraPrintText("Touche 7/9: Orienter la goulotte/gauche/droite");
	g_currentMission:addExtraPrintText("Touche 4/6: Orienter la goulotte/haut/bas");	
	
end;

function Lucas:onAttach()
   
end;

function Lucas:onDetach()
	
	 
end;


function ObjectInRangeLucas(self)
	local nearestObject = nil;	
	local nearestDistance = 1;
        local refnod = self.baleGrabber.grabNode;        
	local px, py, pz = getWorldTranslation(refnod);      
	for index, item in pairs(g_currentMission.itemsToSave) do            
               if item.item:isa(Bale) then	   
			for _, filename in pairs(self.baleTypes) do                               
                              if item.item.i3dFilename == filename then                                 
				local vx, vy, vz = getWorldTranslation(item.item.nodeId);
				local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
				if distance < nearestDistance then                                                                              
					index = i
					nearestObject = item.item;
					nearestDistance = distance;                                        
                                        setRigidBodyType(item.item.nodeId,"none");
                                        link(refnod,item.item.nodeId);
                                        local object = g_currentMission:getNodeObject(item.item.nodeId);                                           
                                        object:delete();                                                                             
                                        local usedFruitType = FruitUtil.FRUITTYPE_PAILLAGE;
                                        local usedFillType = FruitUtil.fruitTypeToFillType[usedFruitType];                                                                             
                                        self:setFillLevel(self.fillLevel + 500, usedFillType);
                                        if filename == "data/maps/models/objects/strawbale/bales/strawbaleBaler.i3d" then
                                          self.baleDummy = self.translationParts.translationPart1;
                                          setVisibility(self.baleDummy.index, true);
                                          self.balecar = true; 
                                          self.isRoundBale = false;
                                        elseif filename == "data/maps/models/objects/roundbales/roundbaleStraw.i3d" then
                                          self.baleDummy = self.translationParts.translationPart2;
                                          setVisibility(self.baleDummy.index, true);
                                          self.isRoundBale = true;
                                          self.balecar = false;   
                                        end;
                                        self.toFront = true;                                       
                                        self.hasBale = true;                                      
                                           				
				end;
                                 break;
                              end;
			end;
		end;
	end;
	return nearestObject;
end;


