pickUpMF2190Event = {};
pickUpMF2190Event_mt = Class(pickUpMF2190Event, Event);

InitEventClass(pickUpMF2190Event, "pickUpMF2190Event");

function pickUpMF2190Event:emptyNew()
    local self = Event:new(pickUpMF2190Event_mt);
    self.className="pickUpMF2190Event";
    return self;
end;

function pickUpMF2190Event:new(vehicle, mode)
    local self = pickUpMF2190Event:emptyNew()
    self.vehicle = vehicle;
	self.mode = mode;
    return self;
end;

function pickUpMF2190Event:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.mode = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function pickUpMF2190Event:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.mode);
end;

function pickUpMF2190Event:run(connection)   
	self.vehicle:pickUpMode(self.mode, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(pickUpMF2190Event:new(self.vehicle, self.mode), nil, connection, self.vehicle);
    end;
end;

function pickUpMF2190Event.sendEvent(vehicle, mode, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(pickUpMF2190Event:new(vehicle, mode), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(pickUpMF2190Event:new(vehicle, mode));
		end;
	end;
end;