﻿TimeSetEvent = {};
TimeSetEvent_mt = Class(TimeSetEvent, Event);

InitEventClass(TimeSetEvent, "TimeSetEvent");

function TimeSetEvent:emptyNew()
	local self = Event:new(TimeSetEvent_mt);
	self.className=" TimeSetEvent";
	return self;
end;

function TimeSetEvent:new(object, bale, baleTime)
	local self =  TimeSetEvent:emptyNew()
	self.bale = bale;
	self.baleTime = baleTime;
	self.object = object;
	return self;
end;

function TimeSetEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.bale = streamReadInt32(streamId);
	self.baleTime = streamReadFloat32(streamId);
	self.object = networkGetObject(id);
	self:run(connection);
end;

function TimeSetEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt32(streamId, self.bale);
	streamWriteFloat32(streamId, self.baleTime);
end;

function TimeSetEvent:run(connection)
	self.object:TimeSet(self.object, self.bale, self.baleTime);
	if not connection:getIsServer() then
        g_server:broadcastEvent(TimeSetEvent:new(self.object, self.bale, self.baleTime), nil, connection, self.object);
    end;
end;

function TimeSetEvent.sendEvent(self, i, baleTime, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(TimeSetEvent:new(self, i, baleTime), nil, nil, self);
		else
			g_client:getServerConnection():sendEvent(TimeSetEvent:new(self, i, baleTime));
		end;
	end;
end;