-- Helfertools specialization by rafftnix
-- author: rafftnix
-- History: 
--          v1.0: initial Version (November 2011) 
-- 			v2.0: Mousemenue, "Vorgewende", Multiplayer support added and renamed because of Compatiblity. (January 2012)
-- 			v2.1: Moveable HUD added and some Bugfixes (January 2012)
--
-- nderungen am Skript nur mit meiner Zustimmung!
-- Modification only with my permission!

Helfertools = {};

function Helfertools.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Hirable, specializations);
end;

function Helfertools:load(xmlFile)
	-- Functions
	self.changeHelferanzahl = SpecializationUtil.callSpecializationsFunction("changeHelferanzahl");
	self.setVorgewende = SpecializationUtil.callSpecializationsFunction("setVorgewende");
	self.setTurnstageVorgewende = SpecializationUtil.callSpecializationsFunction("setTurnstageVorgewende");
	self.TakeHirableDir = SpecializationUtil.callSpecializationsFunction("TakeHirableDir");
	self.InsertHirableDir = SpecializationUtil.callSpecializationsFunction("InsertHirableDir");
	
	-- HUD
	local overlayfile = getUserProfileAppPath().."mods/zzz_Helfertools/HUD.png";
	self.HelfertoolsOverlay = createImageOverlay(overlayfile);
	setOverlayColor(self.HelfertoolsOverlay, 1, 1, 1, 0.75);
	
	-- Basic settings
	self.Helferanzahl = 1;
	self.Vorgewende = 0;
	self.turnStage6Timeout = 20000;
	self.HUDisActive = false;
	self.TurnStageBackup = 0;
	self.Infotimer = 0;
	self.InfotimerBackup = 1500;
	self.Info = "";
	self.showInfo = false;
	self.HUDBaseX = 0.85;
	self.HUDBaseY = 0.53;
	self.HUDMove = false;
	
	-- Turn Scale 
	local ueberlappung = 0.975;
	if self.aiTurnThreshWidthScale ~= nil then
		self.aiTurnThreshWidthScale = ueberlappung;
	end;
	if self.aiTurnWidthScale ~= nil then
		self.aiTurnWidthScale = ueberlappung;
	end;
end;

function Helfertools:delete()
end;

function Helfertools:TakeHirableDir(X, Z, noEventSend)
	if self.isAIThreshing then
		g_HirableCombineDirX = X;
		g_HirableCombineDirZ = Z;
	elseif self.isAITractorActivated then
		g_HirableTractorDirX = X;
		g_HirableTractorDirZ = Z;
	end;
	if not noEventSend then
		if self.isServer then
			ShareHirableDir.sendEvent(self, X, Z, noEventSend);
		elseif self.isClient then 
			InitiateHostTakeHirableDir.sendEvent(self, true);
		end;
	end;
	self.Info = "Helferkurs kopiert";
	self.showInfo = true;
	self.Infotimer = self.InfotimerBackup;
end;

function Helfertools:InsertHirableDir(X, Z, noEventSend)
	if self.isAIThreshing and self.aiThreshingDirectionX ~= nil then
		self.aiThreshingDirectionX = X;
		self.aiThreshingDirectionZ = Z;
	elseif self.isAITractorActivated and self.aiTractorDirectionX ~= nil then
		self.aiTractorDirectionX = X; 
		self.aiTractorDirectionZ = Z;
	end;
	if not noEventSend then
		InsertHirableDirEvent.sendEvent(self, X, Z, noEventSend);
	end;
	self.Info = "Helferkurs eingesetzt";
	self.showInfo = true;
	self.Infotimer = self.InfotimerBackup;
end;

function Helfertools:changeHelferanzahl(Helferanzahl, noEventSend)
	self.Helferanzahl = Helferanzahl; 
	for k, implement in pairs(self.attachedImplements) do
		if implement.object.aiLeftMarker ~= nil and implement.object.aiRightMarker ~= nil then
			if implement.object.aiRightMarkerbackupX ~= nil and implement.object.aiLeftMarkerbackupX ~= nil then
				local x, y, z = getTranslation(implement.object.aiLeftMarker);
				setTranslation(implement.object.aiLeftMarker, (implement.object.aiLeftMarkerbackupX * self.Helferanzahl), y, z);
				local x, y, z = getTranslation(implement.object.aiRightMarker);
				setTranslation(implement.object.aiRightMarker, (implement.object.aiRightMarkerbackupX * self.Helferanzahl), y, z);
				if implement.object.aiBackMarker ~= nil then
					local x, y, z = getTranslation(implement.object.aiBackMarker);
					setTranslation(implement.object.aiBackMarker, (implement.object.aiBackMarkerbackupX * self.Helferanzahl), y, z);
				end;
			end;
		end;
	end;
	if not noEventSend then
		HelferanzahlEvent.sendEvent(self, self.Helferanzahl, noEventSend);
	end;
end;

function Helfertools:setVorgewende(Vorgewende, noEventSend)
	self.Vorgewende = Vorgewende;
	for k, implement in pairs(self.attachedImplements) do
		if implement.object.aiLeftMarker ~= nil and implement.object.aiRightMarker ~= nil and implement.object.aiBackMarker ~= nil then
			local x, y, z = getTranslation(implement.object.aiLeftMarker);
			setTranslation(implement.object.aiLeftMarker, x, y, implement.object.aiLeftMarkerbackupZ + self.Vorgewende);
			local x, y, z = getTranslation(implement.object.aiRightMarker);
			setTranslation(implement.object.aiRightMarker, x, y, implement.object.aiRightMarkerbackupZ + self.Vorgewende);
			local x, y, z = getTranslation(implement.object.aiRightMarker);
			setTranslation(implement.object.aiBackMarker, x, y, implement.object.aiBackMarkerbackupZ + self.Vorgewende);
		end;
	end;
	if not noEventSend then
		VorgewendeEvent.sendEvent(self, self.Vorgewende, noEventSend);
	end;
end;

function Helfertools:setTurnstageVorgewende() -- turnStage Fix
	for k, implement in pairs(self.attachedImplements) do
		if implement.object.aiLeftMarker ~= nil then
			if self.turnStage == 1 then
				local x, y, z = getTranslation(implement.object.aiLeftMarker);
				setTranslation(implement.object.aiLeftMarker, x, y, implement.object.aiLeftMarkerbackupZ);
				local x, y, z = getTranslation(implement.object.aiRightMarker);
				setTranslation(implement.object.aiRightMarker, x, y, implement.object.aiRightMarkerbackupZ);
				if implement.object.aiBackMarker ~= nil then
					local x, y, z = getTranslation(implement.object.aiRightMarker);
					setTranslation(implement.object.aiBackMarker, x, y, implement.object.aiBackMarkerbackupZ);
				end;
			elseif self.turnStage == 0 then
				local x, y, z = getTranslation(implement.object.aiLeftMarker);
				setTranslation(implement.object.aiLeftMarker, x, y, implement.object.aiLeftMarkerbackupZ + self.Vorgewende);
				local x, y, z = getTranslation(implement.object.aiRightMarker);
				setTranslation(implement.object.aiRightMarker, x, y, implement.object.aiRightMarkerbackupZ + self.Vorgewende);
				if implement.object.aiBackMarker ~= nil then
					local x, y, z = getTranslation(implement.object.aiRightMarker);
					setTranslation(implement.object.aiBackMarker, x, y, implement.object.aiBackMarkerbackupZ + self.Vorgewende);
				end;
			end;
		end;
	end;
end;

function Helfertools:mouseEvent(posX, posY, isDown, isUp, button)
	if self.HUDMove then
		self.HUDBaseX = posX;
		self.HUDBaseY = posY;
	end;
	-- HUD move
	local HudchangedJet = false;
	if self.HUDMove and isDown and button == 1 then
		self.HUDMove = false;
		HudchangedJet = true;
	end;
	if isDown and button == 1 and HudchangedJet ~= true then
		if (self.HUDBaseX-0.10) < posX and posX < (self.HUDBaseX+0.06) and (self.HUDBaseY-0.01) < posY and posY < (self.HUDBaseY+0.01) then
			self.HUDMove = true;
		end;
	end;
	
	if self.HUDisActive and isDown and button == 1 then
		if (self.HUDBaseX+0.12) > posX and (self.HUDBaseX+0.10) < posX and (self.HUDBaseY-0.01) > posY and (self.HUDBaseY-0.04) < posY then
			if self.Helferanzahl < 10 then
				self:changeHelferanzahl((self.Helferanzahl + 1));
			end;
		end;
		if (self.HUDBaseX+0.14) > posX and (self.HUDBaseX+0.12) < posX and (self.HUDBaseY-0.01) > posY and (self.HUDBaseY-0.04) < posY then
			if self.Helferanzahl >= 2 then
				self:changeHelferanzahl((self.Helferanzahl - 1));
			end;
		end;
		if (self.HUDBaseX+0.12) > posX and (self.HUDBaseX+0.10) < posX and (self.HUDBaseY-0.04) > posY and (self.HUDBaseY-0.07) < posY then
			if not SpecializationUtil.hasSpecialization(Combine, self.specializations) then
				if self.Vorgewende < 40 then
					self:setVorgewende((self.Vorgewende + 1));
				end;
			end;
		end;
		if (self.HUDBaseX+0.13) > posX and (self.HUDBaseX+0.12) < posX and (self.HUDBaseY-0.04) > posY and (self.HUDBaseY-0.07) < posY then
			if not SpecializationUtil.hasSpecialization(Combine, self.specializations) then
				if self.Vorgewende >= 1 then
					self:setVorgewende((self.Vorgewende - 1));
				end;
			end;
		end;
		if (self.HUDBaseX+0.11) > posX and (self.HUDBaseX-0.10) < posX and (self.HUDBaseY-0.07) > posY and (self.HUDBaseY-0.10) < posY then
			if self.isAIThreshing then
				self:TakeHirableDir(self.aiThreshingDirectionX, self.aiThreshingDirectionZ);
			elseif self.isAITractorActivated then
				self:TakeHirableDir(self.aiTractorDirectionX, self.aiTractorDirectionZ);
			end;
		end;
		if (self.HUDBaseX+0.11) > posX and (self.HUDBaseX-0.10) < posX and (self.HUDBaseY-0.10) > posY and (self.HUDBaseY-0.13) < posY then
			if self.isAIThreshing and g_HirableCombineDirX ~= nil then
				self:InsertHirableDir(g_HirableCombineDirX, g_HirableCombineDirZ);
			elseif self.isAITractorActivated and g_HirableTractorDirX ~= nil then
				self:InsertHirableDir(g_HirableTractorDirX, g_HirableTractorDirZ);
			end;
		end;
	end;
end;

function Helfertools:keyEvent(unicode, sym, modifier, isDown)
end;

function Helfertools:onLeave()
	InputBinding.setShowMouseCursor(false);
	self.HUDMove = false;
end;

function Helfertools:onEnter()
	InputBinding.setShowMouseCursor(self.HUDisActive);
end;

function Helfertools:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.HELFERTOOLS_HUD) then
			self.HUDisActive = not self.HUDisActive;
			InputBinding.setShowMouseCursor(self.HUDisActive);
		end;		
	end;		
	
	if self.Infotimer > 0 and self.showInfo then
		self.Infotimer = self.Infotimer - dt;
		if self.Infotimer < 0 then
			self.showInfo = false;
		end;
	end;
	if self.cameras[self.camIndex] ~= nil then
		self.cameras[self.camIndex].isActivated = not self.HUDisActive;
	end;
	if self.TurnStageBackup == self.turnStage then
	else
		self:setTurnstageVorgewende();
	end;
	self.TurnStageBackup = self.turnStage;
end;

function Helfertools:draw()
	setTextBold(false);
	if self.HUDisActive then
		renderText((self.HUDBaseX-0.10), (self.HUDBaseY-0.01), 0.025, "Fenster verschieben");
		renderOverlay(self.HelfertoolsOverlay, (self.HUDBaseX-0.10), (self.HUDBaseY-0.13), 0.23, 0.15);
		renderText((self.HUDBaseX-0.10), (self.HUDBaseY-0.04), 0.025, "Helferanzahl: "..tostring(self.Helferanzahl));
		renderText((self.HUDBaseX+0.10), (self.HUDBaseY-0.04), 0.025, "+ -");
		if not SpecializationUtil.hasSpecialization(Combine, self.specializations) then
			renderText((self.HUDBaseX-0.10), (self.HUDBaseY-0.07), 0.025, "Vorgewendelaenge: "..tostring(self.Vorgewende).."m");
			renderText((self.HUDBaseX+0.10),(self.HUDBaseY-0.07), 0.025, "+ -");
		end;
		if self.isAITractorActivated or self.isAIThreshing then
			renderText((self.HUDBaseX-0.10), (self.HUDBaseY-0.10), 0.025, "Helferkurs kopieren");
		end;
		if self.isAITractorActivated and g_HirableTractorDirX ~= nil then
			renderText((self.HUDBaseX-0.10), (self.HUDBaseY-0.13), 0.025, "Helferkurs einsetzen");
		elseif self.isAIThreshing and g_HirableCombineDirX ~= nil then
			renderText((self.HUDBaseX-0.10), (self.HUDBaseY-0.13), 0.025, "Helferkurs einsetzen");
		end;
		if self.showInfo then
			renderText((self.HUDBaseX-0.10), (self.HUDBaseY+0.02), 0.025, self.Info);
		end;
	else
		g_currentMission:addHelpButtonText("Helfertools HUD anschalten", InputBinding.HELFERTOOLS_HUD);
	end;
end;

-- Events

HelferanzahlEvent = {};
HelferanzahlEvent_mt = Class(HelferanzahlEvent, Event);
InitEventClass(HelferanzahlEvent, "HelferanzahlEvent");
function HelferanzahlEvent:emptyNew()
    local self = Event:new(HelferanzahlEvent_mt);
    self.className="HelferanzahlEvent";
    return self;
end;

function HelferanzahlEvent:new(object, Helferanzahl)
    local self = HelferanzahlEvent:emptyNew(); 
    self.object = object; 
	self.Helferanzahl = Helferanzahl;
    return self;
end;

function HelferanzahlEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteInt8(streamId, self.Helferanzahl);
end;

function HelferanzahlEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.Helferanzahl = streamReadInt8(streamId);
    self:run(connection);
end;

function HelferanzahlEvent:run(connection)
	self.object:changeHelferanzahl(self.Helferanzahl, true); 
	if not connection:getIsServer() then
		g_server:broadcastEvent(HelferanzahlEvent:new(self.object, self.Helferanzahl), nil, connection, self.object);
	end; 
end;

function HelferanzahlEvent.sendEvent(object, Helferanzahl, noEventSend)
	if noEventSend == nil or noEventSend == false then  
		if g_server ~= nil then   
			g_server:broadcastEvent(HelferanzahlEvent:new(object, Helferanzahl), nil, nil, object); 
		else  
			g_client:getServerConnection():sendEvent(HelferanzahlEvent:new(object, Helferanzahl)); 
		end;
	end;
end;

VorgewendeEvent = {};
VorgewendeEvent_mt = Class(VorgewendeEvent, Event);
InitEventClass(VorgewendeEvent, "VorgewendeEvent");
function VorgewendeEvent:emptyNew()
    local self = Event:new(VorgewendeEvent_mt);
    self.className="VorgewendeEvent";
    return self;
end;

function VorgewendeEvent:new(object, Vorgewende)
    local self = VorgewendeEvent:emptyNew(); 
    self.object = object; 
	self.Vorgewende = Vorgewende;
    return self;
end;

function VorgewendeEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteInt8(streamId, self.Vorgewende);
end;

function VorgewendeEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.Vorgewende = streamReadInt8(streamId);
    self:run(connection);
end;

function VorgewendeEvent:run(connection)
	self.object:setVorgewende(self.Vorgewende, true); 
	if not connection:getIsServer() then
		g_server:broadcastEvent(VorgewendeEvent:new(self.object, self.Vorgewende), nil, connection, self.object);
	end; 
end;

function VorgewendeEvent.sendEvent(object, Vorgewende, noEventSend)
	if noEventSend == nil or noEventSend == false then  
		if g_server ~= nil then   
			g_server:broadcastEvent(VorgewendeEvent:new(object, Vorgewende), nil, nil, object); 
		else  
			g_client:getServerConnection():sendEvent(VorgewendeEvent:new(object, Vorgewende)); 
		end;
	end;
end;

ShareHirableDir = {};
ShareHirableDir_mt = Class(ShareHirableDir, Event);
InitEventClass(ShareHirableDir, "ShareHirableDir");
function ShareHirableDir:emptyNew()
    local self = Event:new(ShareHirableDir_mt);
    self.className="ShareHirableDir";
    return self;
end;

function ShareHirableDir:new(object, X, Z)
    local self = ShareHirableDir:emptyNew(); 
	self.object = object;
    self.X = X; 
	self.Z = Z;
    return self;
end;

function ShareHirableDir:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteFloat32(streamId, self.X);
	streamWriteFloat32(streamId, self.Z);
end;

function ShareHirableDir:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.X = streamReadFloat32(streamId);
	self.Z = streamReadFloat32(streamId);
    self:run(connection);
end;

function ShareHirableDir:run(connection)
	self.object:TakeHirableDir(self.X, self.Z, true); 
	if not connection:getIsServer() then
		g_server:broadcastEvent(ShareHirableDir:new(self.object, self.X, self.Z), nil, connection, self.object);
	end; 
end;

function ShareHirableDir.sendEvent(object, X, Z, noEventSend)
	if noEventSend == nil or noEventSend == false then  
		if g_server ~= nil then   
			g_server:broadcastEvent(ShareHirableDir:new(object, X, Z), nil, nil, object); 
		else  
			g_client:getServerConnection():sendEvent(ShareHirableDir:new(object, X, Z)); 
		end;
	end;
end;

InitiateHostTakeHirableDir = {};
InitiateHostTakeHirableDir_mt = Class(InitiateHostTakeHirableDir, Event);
InitEventClass(InitiateHostTakeHirableDir, "InitiateHostTakeHirableDir");
function InitiateHostTakeHirableDir:emptyNew()
    local self = Event:new(InitiateHostTakeHirableDir_mt);
    self.className="InitiateHostTakeHirableDir";
    return self;
end;

function InitiateHostTakeHirableDir:new(object, value)
    local self = InitiateHostTakeHirableDir:emptyNew(); 
    self.object = object; 
	self.value = value;
    return self;
end;

function InitiateHostTakeHirableDir:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.value);
end;

function InitiateHostTakeHirableDir:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.value = streamReadBool(streamId);
    self:run(connection);
end;

function InitiateHostTakeHirableDir:run(connection)
	if self.object.isAIThreshing then
		self.object:TakeHirableDir(self.object.aiThreshingDirectionX, self.object.aiThreshingDirectionZ, true);
	elseif self.object.isAITractorActivated then
		self.object:TakeHirableDir(self.object.aiTractorDirectionX, self.object.aiTractorDirectionZ, true);
	end;
	if not connection:getIsServer() then
		g_server:broadcastEvent(InitiateHostTakeHirableDir:new(self.object, self.value), nil, connection, self.object);
	end; 
end;

function InitiateHostTakeHirableDir.sendEvent(object, value, noEventSend)
	if noEventSend == nil or noEventSend == false then  
		if g_server ~= nil then   
			g_server:broadcastEvent(InitiateHostTakeHirableDir:new(object, value), nil, nil, object); 
		else  
			g_client:getServerConnection():sendEvent(InitiateHostTakeHirableDir:new(object, value)); 
		end;
	end;
end;

InsertHirableDirEvent = {};
InsertHirableDirEvent_mt = Class(InsertHirableDirEvent, Event);
InitEventClass(InsertHirableDirEvent, "InsertHirableDirEvent");
function InsertHirableDirEvent:emptyNew()
    local self = Event:new(InsertHirableDirEvent_mt);
    self.className="InsertHirableDirEvent";
    return self;
end;

function InsertHirableDirEvent:new(object, X, Z)
    local self = InsertHirableDirEvent:emptyNew(); 
	self.object = object;
    self.X = X; 
	self.Z = Z;
    return self;
end;

function InsertHirableDirEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteFloat32(streamId, self.X);
	streamWriteFloat32(streamId, self.Z);
end;

function InsertHirableDirEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.X = streamReadFloat32(streamId);
	self.Z = streamReadFloat32(streamId);
    self:run(connection);
end;

function InsertHirableDirEvent:run(connection)
	self.object:InsertHirableDir(self.X, self.Z, true); 
	if not connection:getIsServer() then
		g_server:broadcastEvent(InsertHirableDirEvent:new(self.object, self.X, self.Z), nil, connection, self.object);
	end; 
end;

function InsertHirableDirEvent.sendEvent(object, X, Z, noEventSend)
	if noEventSend == nil or noEventSend == false then  
		if g_server ~= nil then   
			g_server:broadcastEvent(InsertHirableDirEvent:new(object, X, Z), nil, nil, object); 
		else  
			g_client:getServerConnection():sendEvent(InsertHirableDirEvent:new(object, X, Z)); 
		end;
	end;
end;