-- AttachableSettings specialization by rafftnix
-- author: rafftnix
-- History: 
--          v1.0: initial Version (November 2011) 
--			v1.1: Moveable HUD added and some Bugfixes (January 2011) 
--
-- nderungen am Skript nur mit meiner Zustimmung!
-- Modification only with my permission!

AttachableSettings = {};

function AttachableSettings.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function AttachableSettings:load(xmlFile)
	if self.aiLeftMarker  ~= nil then
		local x, y, z = getTranslation(self.aiLeftMarker);
		self.aiLeftMarkerbackupX = x;
		self.aiLeftMarkerbackupZ = z;
		local x, y, z = getTranslation(self.aiRightMarker);
		self.aiRightMarkerbackupX = x;
		self.aiRightMarkerbackupZ = z;
		local x, y, z = getTranslation(self.aiBackMarker);
		self.aiBackMarkerbackupX = x;
		self.aiBackMarkerbackupZ = z;
	end;
end;

function AttachableSettings:delete()
end;

function AttachableSettings:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AttachableSettings:keyEvent(unicode, sym, modifier, isDown)
end;

function AttachableSettings:onAttach(attacherVehicle)
	if self.aiLeftMarker ~= nil and self.attacherVehicle.Helferanzahl ~= nil then
		local x, y, z = getTranslation(self.aiLeftMarker);
		setTranslation(self.aiLeftMarker, self.aiLeftMarkerbackupX * self.attacherVehicle.Helferanzahl, y, self.aiLeftMarkerbackupZ + self.attacherVehicle.Vorgewende);
		local x, y, z = getTranslation(self.aiRightMarker);
		setTranslation(self.aiRightMarker, self.aiRightMarkerbackupX * self.attacherVehicle.Helferanzahl, y, self.aiRightMarkerbackupZ + self.attacherVehicle.Vorgewende);
		if self.aiBackMarker ~= nil then
			local x, y, z = getTranslation(self.aiBackMarker);
			setTranslation(self.aiBackMarker, self.aiBackMarkerbackupX * self.attacherVehicle.Helferanzahl, y, self.aiBackMarkerbackupZ + self.attacherVehicle.Vorgewende);
		end;
	end;
end;

function AttachableSettings:onDetach(attacherVehicle)
	if self.aiLeftMarker ~= nil then
		local x, y, z = getTranslation(self.aiLeftMarker);
		setTranslation(self.aiLeftMarker, self.aiLeftMarkerbackupX, y, self.aiLeftMarkerbackupZ);
		local x, y, z = getTranslation(self.aiRightMarker);
		setTranslation(self.aiRightMarker, self.aiRightMarkerbackupX, y, self.aiRightMarkerbackupZ);
		if self.aiBackMarker ~= nil then
			local x, y, z = getTranslation(self.aiBackMarker);
			setTranslation(self.aiBackMarker, self.aiBackMarkerbackupX, y, self.aiBackMarkerbackupZ);
		end;
	end;
end;

function AttachableSettings:update(dt)
end;

function AttachableSettings:draw()
end;