-- BlendOnOff
-- Author Daniel "Desperados93" Witzel
--  (2012) by Daniel "Desperados93" Witzel


BlendOnOff = {};

function BlendOnOff.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function BlendOnOff:load(xmlFile)
	self.BlendOn = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.BlendOnOff#BlendOn"));
	self.BlendOff = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.BlendOnOff#BlendOff"));
end;

function BlendOnOff:draw()
end;

function BlendOnOff:delete()
end;

function BlendOnOff:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BlendOnOff:keyEvent(unicode, sym, modifier, isDown)
end;

function BlendOnOff:update()
end;

function BlendOnOff:onAttach()
	setVisibility(self.BlendOn, true);
	setVisibility(self.BlendOff, false);
end;

function BlendOnOff:onDetach()
	setVisibility(self.BlendOn, false);
	setVisibility(self.BlendOff, true);
end;