-- attachVehicles
-- Specialization for Tieflader.
-- @ Geri-G, ls-modsource.com
-- @ date : 22/02/2010

-- edited by modelleicher
-- to attach/detach things by drive/not drive.. So theres no more animation required
-- @ date: 23.08.2012

attachVehicles = {};

function attachVehicles.prerequisitesPresent(specializations)
    return true;
end;

function attachVehicles:load(xmlFile)
	self.GetVehiclesInRange = attachVehicles.GetVehiclesInRange;
	self.attachVehicles = attachVehicles.attachVehicles;
	self.detachVehicles = attachVehicles.detachVehicles;
	self.Attachers={};
	self.PF={};
	local Parent = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Attacher#ParentIndex"));
	local Parent2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Attacher#PlaceFinderParent"));
	local numAttachers = getNumOfChildren(Parent);
	local numPlaceFinders = getNumOfChildren(Parent2);
	for i=1, numAttachers do
		self.Attachers[i] = {};
		self.Attachers[i].node = getChildAt(Parent, i-1);
		self.Attachers[i].attachedObject = nil;
	end;	
	for j=1, numPlaceFinders do
		self.PF[j] = {};
		self.PF[j].Transform = getChildAt(Parent2, j-1);
	end;
	self.once = true;
	self.done = true;
end;

function attachVehicles:delete()
end;
function attachVehicles:mouseEvent(posX, posY, isDown, isUp, button)
end;
function attachVehicles:keyEvent(unicode, sym, modifier, isDown)
end;
function attachVehicles:onAttach(attacherVehicle)
	self.attacherVehicle = attacherVehicle;
end;

function attachVehicles:onDetach()
	self.attacherVehicle = nil;
end;
function attachVehicles:update(dt)
	if self:getIsActive() then	
		
		-- this part attaches if tractor is moving and detaches if it is not
		if self.attacherVehicle ~= nil then
			if self.attacherVehicle.movingDirection == -1 or self.attacherVehicle.movingDirection == 1 then
				if self.once == true then
					self.nearestVehicles = {self:GetVehiclesInRange()};
					self.once = false;
					self.done = false;
					for i = 1, table.getn(self.nearestVehicles) do
						self:attachVehicles(self.nearestVehicles[i], i);
					end;
				end;
			else
				self.once = true;
				if self.done == false then
					for i = 1, table.getn(self.nearestVehicles) do
						self:detachVehicles(self.nearestVehicles[i], i);
					end;	
					self.done = true;
				end;
			end;
		end;
	end;	
end;

function attachVehicles:draw()
end;
function attachVehicles:attachVehicles(node, k)
	if self.Attachers[k].node ~= nil and self.Attachers[k].attachedObject == nil then 			
		--JointTranslation Anpassung an das Objekt
		local xw, yw, zw = getWorldTranslation(node.components[1].node);		
		local x,y,z = worldToLocal(getParent(self.Attachers[k].node), xw, yw, zw);	
		setTranslation(self.Attachers[k].node, x,y,z);			
		--JointRotation Anpassung an das Objekt
		local zX, zY, zZ = localDirectionToWorld(node.components[1].node, 0,0,1);
		local zX, zY, zZ = worldDirectionToLocal(getParent(self.Attachers[k].node), zX, zY, zZ);
		local yX, yY, yZ = localDirectionToWorld(node.components[1].node, 0,1,0);
		local yX, yY, yZ = worldDirectionToLocal(getParent(self.Attachers[k].node), yX, yY, yZ);
		setDirection(self.Attachers[k].node, zX, zY, zZ, yX, yY, yZ);
		
		if node.enterReferenceNode == nil then
			node:onAttach(self);
		end;
		--anhaengen
		local constr = JointConstructor:new();					
		constr:setActors(self.components[1].node, node.components[1].node);
		constr:setJointTransforms(self.Attachers[k].node,  node.components[1].node);
		for i=1, 3 do		                    
			constr:setTranslationLimit(i-1, true, 0, 0);
			constr:setRotationLimit(i-1, 0, 0);
		end;		
		self.Attachers[k].attachedObject = constr:finalize();
	end;
end;
function attachVehicles:detachVehicles(node, k)
	if self.Attachers[k].attachedObject ~= nil then	
		node.attacherVehicle = nil;
		
		if node.enterReferenceNode == nil then
			node:onDetach(self);
		end;		
		removeJoint(self.Attachers[k].attachedObject);
		self.Attachers[k].attachedObject = nil;
		
		setTranslation(self.Attachers[k].node,0,0,0);
		setRotation(self.Attachers[k].node,0,0,0);
	end;
end;
function attachVehicles:GetVehiclesInRange()
	local nearestNode = {};
	local nearestDistance = 2;
	for u,obj in pairs(self.PF) do
		local px, py, pz = getWorldTranslation(obj.Transform);
		
		for k,v in pairs(g_currentMission.vehicles) do
			if v ~= self and v ~= self.attacherVehicle and v.attacherVehicle == nil then
				local x,y,z = getWorldTranslation(v.components[1].node);
				local distance = Utils.vector3Length(px-x, py-y, pz-z);
				if distance < nearestDistance then
					if table.getn(nearestNode)+1 <= table.getn(self.Attachers) then
						nearestNode[table.getn(nearestNode)+1] = v;
					end;
				end;
			end;
		end;
	end;
	return unpack(nearestNode)
end;

